/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.ui.ManageSelection;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Highlighter;

public class UITextArea
extends JTextArea {
    private static final long serialVersionUID = 6512803283442088990L;
    private int preferred_width = 360;
    private Image backgroundImage = null;
    private Highlighter highlighter = null;
    private boolean isSelectable = false;

    public UITextArea() {
        JLabel label = new JLabel();
        this.setBorder(new EmptyBorder(new Insets(0, 5, 0, 0)));
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setFont(label.getFont());
        this.setRows(0);
        this.highlighter = this.getHighlighter();
        this.setHighlighter(null);
        this.invalidate();
    }

    public UITextArea(String text) {
        this();
        this.setText(text);
    }

    public UITextArea(int fz, int my_width, boolean bold) {
        this();
        this.preferred_width = my_width;
        JLabel label = new JLabel();
        Font system_font = label.getFont();
        Font new_font = bold ? system_font.deriveFont(1, fz) : system_font.deriveFont((float)fz);
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.setFont(new_font);
        this.invalidate();
    }

    public void setSelectable() {
        this.setHighlighter(this.highlighter);
        this.isSelectable = true;
        ManageSelection manageSelection = new ManageSelection(this);
        this.addFocusListener(manageSelection);
        this.addMouseListener(manageSelection);
    }

    @Override
    public boolean isFocusTraversable() {
        return this.isSelectable;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.invalidate();
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        boolean isOpaque = this.backgroundImage == null;
        this.setOpaque(isOpaque);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.backgroundImage != null) {
            g.drawImage(this.backgroundImage, 0, 0, this);
        } else {
            this.setBackground(new Color(this.getParent().getBackground().getRGB()));
        }
        super.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d;
        if (this.backgroundImage != null) {
            d = new Dimension(this.backgroundImage.getWidth(this), this.backgroundImage.getHeight(this));
        } else if (this.getRows() == 0 && this.getColumns() == 0) {
            int columns = this.preferred_width / this.getColumnWidth();
            this.setColumns(columns);
            d = super.getPreferredSize();
            this.setColumns(0);
        } else {
            d = super.getPreferredSize();
        }
        return d;
    }
}

