/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt.ui;

import com.sun.deploy.config.OSType;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleHelper;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public final class SwingConsoleWindow
extends JFrame
implements ConsoleWindow {
    private static final long serialVersionUID = 8147918735685532337L;
    private final ConsoleController controller;
    private final JTextArea textArea;
    private final JScrollPane scroller;
    private final JScrollBar sbHor;
    private final JScrollBar sbVer;

    public static SwingConsoleWindow create(final ConsoleController controller) throws Exception {
        final SwingConsoleWindow[] ret = new SwingConsoleWindow[1];
        SwingConsoleWindow.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ret[0] = new SwingConsoleWindow(controller);
            }
        });
        return ret[0];
    }

    public SwingConsoleWindow(final ConsoleController controller) {
        super(ResourceManager.getString("console.caption"));
        this.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        this.controller = controller;
        Rectangle screen = UIFactory.getMouseScreenBounds();
        this.setBounds(screen.x, screen.y, 450, 400);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        this.getRootPane().putClientProperty("Window.style", "small");
        this.getContentPane().setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setFont(ResourceManager.getUIFont());
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(0, 5, 0, 0));
        if (OSType.isMac()) {
            this.textArea.setFont(new Font("Monospaced", 0, 11));
        }
        this.scroller = new JScrollPane(this.textArea);
        if (OSType.isMac()) {
            this.scroller.setBorder(new Border(){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    g.setColor(Color.gray);
                    g.drawLine(0, height - 1, width, height - 1);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }

                @Override
                public Insets getBorderInsets(Component c) {
                    return new Insets(0, 0, 1, 0);
                }
            });
        }
        JViewport viewport = this.scroller.getViewport();
        viewport.setScrollMode(1);
        this.sbVer = this.scroller.getVerticalScrollBar();
        this.sbHor = this.scroller.getHorizontalScrollBar();
        this.getContentPane().add((Component)this.scroller, "Center");
        ActionListener dumpThreadStack = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Trace.print(ResourceManager.getString("console.dump.stack"));
                Trace.print(ResourceManager.getString("console.menu.text.top"));
                ConsoleHelper.dumpAllStacks(controller);
                Trace.print(ResourceManager.getString("console.menu.text.tail"));
                Trace.print(ResourceManager.getString("console.done"));
            }
        };
        ActionListener showThreads = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Trace.print(ResourceManager.getString("console.dump.thread"));
                ThreadGroup tg = controller.getMainThreadGroup();
                ConsoleHelper.dumpThreadGroup(tg);
                Trace.println(ResourceManager.getString("console.done"));
            }
        };
        ActionListener reloadPolicyConfig = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Trace.print(ResourceManager.getString("console.reload.policy"));
                controller.reloadSecurityPolicy();
                Trace.println(ResourceManager.getString("console.completed"));
            }
        };
        ActionListener reloadProxyConfig = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Trace.println(ResourceManager.getString("console.reload.proxy"));
                controller.reloadProxyConfig();
                Trace.println(ResourceManager.getString("console.done"));
            }
        };
        ActionListener showSystemProperties = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleHelper.displaySystemProperties();
            }
        };
        ActionListener showHelp = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleHelper.displayHelp(controller, SwingConsoleWindow.this);
            }
        };
        ActionListener showClassLoaderCache = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Trace.println(controller.dumpClassLoaders());
            }
        };
        ActionListener clearClassLoaderCache = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.clearClassLoaders();
                Trace.println(ResourceManager.getString("console.clear.classloader"));
            }
        };
        ActionListener clearConsole = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingConsoleWindow.this.clear();
            }
        };
        ActionListener copyConsole = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectionStart = SwingConsoleWindow.this.textArea.getSelectionStart();
                int selectionEnd = SwingConsoleWindow.this.textArea.getSelectionEnd();
                if (selectionEnd - selectionStart <= 0) {
                    SwingConsoleWindow.this.textArea.selectAll();
                }
                SwingConsoleWindow.this.textArea.copy();
            }
        };
        ActionListener closeConsole = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingConsoleWindow.this.setVisible(false);
                SwingConsoleWindow.this.dispose();
                controller.notifyConsoleClosed();
            }
        };
        final ActionListener showMemory = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long freeMemory = Runtime.getRuntime().freeMemory() / 1024L;
                long totalMemory = Runtime.getRuntime().totalMemory() / 1024L;
                long percentFree = (long)(100.0 / ((double)totalMemory / (double)freeMemory));
                Trace.print(ResourceManager.getString("console.memory", totalMemory, freeMemory, percentFree));
                Trace.println(ResourceManager.getString("console.completed"));
            }
        };
        ActionListener runFinalize = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Trace.print(ResourceManager.getString("console.finalize"));
                System.runFinalization();
                Trace.println(ResourceManager.getString("console.completed"));
                showMemory.actionPerformed(e);
            }
        };
        ActionListener runGC = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Trace.print(ResourceManager.getString("console.gc"));
                System.gc();
                Trace.println(ResourceManager.getString("console.completed"));
                showMemory.actionPerformed(e);
            }
        };
        ActionListener traceLevel0 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleHelper.setTraceLevel(0);
            }
        };
        ActionListener traceLevel1 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleHelper.setTraceLevel(1);
            }
        };
        ActionListener traceLevel2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleHelper.setTraceLevel(2);
            }
        };
        ActionListener traceLevel3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleHelper.setTraceLevel(3);
            }
        };
        ActionListener traceLevel4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleHelper.setTraceLevel(4);
            }
        };
        ActionListener traceLevel5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleHelper.setTraceLevel(5);
            }
        };
        ActionListener logging = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Trace.println(ResourceManager.getString("console.log") + controller.toggleLogging() + ResourceManager.getString("console.completed"));
            }
        };
        if (controller.isDumpStackSupported()) {
            this.textArea.registerKeyboardAction(dumpThreadStack, KeyStroke.getKeyStroke(86, 0), 2);
        }
        if (controller.isProxyConfigReloadSupported()) {
            this.textArea.registerKeyboardAction(reloadProxyConfig, KeyStroke.getKeyStroke(80, 0), 2);
        }
        if (controller.isSecurityPolicyReloadSupported()) {
            this.textArea.registerKeyboardAction(reloadPolicyConfig, KeyStroke.getKeyStroke(82, 0), 2);
        }
        if (controller.isClearClassLoaderSupported()) {
            this.textArea.registerKeyboardAction(clearClassLoaderCache, KeyStroke.getKeyStroke(88, 0), 2);
        }
        if (controller.isDumpClassLoaderSupported()) {
            this.textArea.registerKeyboardAction(showClassLoaderCache, KeyStroke.getKeyStroke(76, 0), 2);
        }
        if (controller.isLoggingSupported()) {
            this.textArea.registerKeyboardAction(logging, KeyStroke.getKeyStroke(79, 0), 2);
        }
        this.textArea.registerKeyboardAction(showThreads, KeyStroke.getKeyStroke(84, 0), 2);
        this.textArea.registerKeyboardAction(showSystemProperties, KeyStroke.getKeyStroke(83, 0), 2);
        this.textArea.registerKeyboardAction(showHelp, KeyStroke.getKeyStroke(72, 0), 2);
        this.textArea.registerKeyboardAction(showMemory, KeyStroke.getKeyStroke(77, 0), 2);
        this.textArea.registerKeyboardAction(clearConsole, KeyStroke.getKeyStroke(67, 0), 2);
        this.textArea.registerKeyboardAction(runGC, KeyStroke.getKeyStroke(71, 0), 2);
        this.textArea.registerKeyboardAction(runFinalize, KeyStroke.getKeyStroke(70, 0), 2);
        this.textArea.registerKeyboardAction(closeConsole, KeyStroke.getKeyStroke(81, 0), 2);
        this.textArea.registerKeyboardAction(traceLevel0, KeyStroke.getKeyStroke(48, 0), 2);
        this.textArea.registerKeyboardAction(traceLevel1, KeyStroke.getKeyStroke(49, 0), 2);
        this.textArea.registerKeyboardAction(traceLevel2, KeyStroke.getKeyStroke(50, 0), 2);
        this.textArea.registerKeyboardAction(traceLevel3, KeyStroke.getKeyStroke(51, 0), 2);
        this.textArea.registerKeyboardAction(traceLevel4, KeyStroke.getKeyStroke(52, 0), 2);
        this.textArea.registerKeyboardAction(traceLevel5, KeyStroke.getKeyStroke(53, 0), 2);
        JButton clear = new JButton(ResourceManager.getString("console.clear"));
        clear.setMnemonic(ResourceManager.getMnemonic("console.clear"));
        JButton copy = new JButton(ResourceManager.getString("console.copy"));
        copy.setMnemonic(ResourceManager.getMnemonic("console.copy"));
        JButton close = new JButton(ResourceManager.getString("console.close"));
        close.setMnemonic(ResourceManager.getMnemonic("console.close"));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1));
        panel.add(clear);
        panel.add(new JLabel("    "));
        panel.add(copy);
        panel.add(new JLabel("    "));
        panel.add(close);
        this.getContentPane().add((Component)panel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingConsoleWindow.this.setVisible(false);
                SwingConsoleWindow.this.dispose();
                controller.notifyConsoleClosed();
            }
        });
        clear.addActionListener(clearConsole);
        copy.addActionListener(copyConsole);
        close.addActionListener(closeConsole);
    }

    @Override
    public void clear() {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlainDocument document = new PlainDocument();
                SwingConsoleWindow.this.textArea.setDocument(document);
                SwingConsoleWindow.this.textArea.revalidate();
                SwingConsoleWindow.this.setScrollPosition();
                ConsoleHelper.displayVersion(SwingConsoleWindow.this.controller, SwingConsoleWindow.this);
                SwingConsoleWindow.this.append("\n");
                ConsoleHelper.displayHelp(SwingConsoleWindow.this.controller, SwingConsoleWindow.this);
            }
        });
    }

    private void invokeLater(final Runnable r) {
        if (r == null) {
            return;
        }
        try {
            DeploySysRun.execute(new DeploySysAction(){

                @Override
                public Object execute() {
                    SwingUtilities.invokeLater(r);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Trace.ignoredException(e);
        }
    }

    private static void invokeAndWait(final Runnable r) {
        if (r == null) {
            return;
        }
        try {
            DeploySysRun.execute(new DeploySysAction(){

                @Override
                public Object execute() {
                    try {
                        if (!EventQueue.isDispatchThread()) {
                            SwingUtilities.invokeAndWait(r);
                        } else {
                            r.run();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Trace.ignoredException(e);
        }
    }

    @Override
    public void append(final String text) {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (text.length() > 1048575) {
                        SwingConsoleWindow.this.textArea.setText(text.substring(text.length() - 1048575));
                    } else {
                        int diff = SwingConsoleWindow.this.textArea.getText().length() + text.length() - 1048575;
                        if (diff > 0) {
                            SwingConsoleWindow.this.textArea.replaceRange("", 0, diff);
                        }
                        SwingConsoleWindow.this.textArea.append(text);
                    }
                    SwingConsoleWindow.this.textArea.revalidate();
                    SwingConsoleWindow.this.setScrollPosition();
                }
                catch (Exception e) {
                    SwingConsoleWindow.this.clear();
                    Trace.println(ResourceManager.getString("console.trace.error"));
                }
            }
        });
    }

    private void setScrollPosition() {
        this.scroller.validate();
        this.sbVer.setValue(this.sbVer.getMaximum());
        this.sbHor.setValue(this.sbHor.getMinimum());
    }

    @Override
    public void setVisible(final boolean visible) {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingConsoleWindow.this.setVisibleImpl(visible);
            }
        });
    }

    private void setVisibleImpl(boolean visible) {
        if (this.isVisible() != visible) {
            super.setVisible(visible);
        }
        if (visible) {
            this.toFront();
        } else {
            this.dispose();
        }
    }

    @Override
    public void setTitle(final String string) {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingConsoleWindow.this.setTitleImpl(string);
            }
        });
    }

    private void setTitleImpl(String string) {
        super.setTitle(string);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public String getRecentLog() {
        final String[] ret = new String[]{"empty"};
        Trace.flush();
        SwingConsoleWindow.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Document doc = SwingConsoleWindow.this.textArea.getDocument();
                try {
                    ret[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return ret[0];
    }
}

