/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.ui;

import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleHelper;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggerConsole
implements ConsoleWindow {
    private static final Logger LOGGER = Logger.getLogger("DeployConsole");
    private final ConsoleController controller;
    private volatile boolean visible = true;

    public static LoggerConsole create(ConsoleController controller) {
        return new LoggerConsole(controller);
    }

    public LoggerConsole(ConsoleController controller) {
        this.controller = controller;
    }

    @Override
    public void clear() {
        LOGGER.log(Level.INFO, "CLEAR");
        ConsoleHelper.displayVersion(this.controller, this);
        this.append("\n");
        ConsoleHelper.displayHelp(this.controller, this);
    }

    @Override
    public void append(String text) {
        LOGGER.log(Level.FINE, text);
    }

    @Override
    public void setVisible(boolean visible) {
        LOGGER.log(Level.INFO, visible ? "Visible" : "Invisible");
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void dispose() {
        LOGGER.log(Level.INFO, "Disposed");
    }

    @Override
    public void setTitle(String title) {
        LOGGER.log(Level.CONFIG, "Console Title : {0}", title);
    }

    @Override
    public String getRecentLog() {
        return "";
    }
}

