/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SafeThreadFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class NativeLibraryBundle {
    private static File rootDir;
    private static final String LOCK_SUFFIX = ".lck";
    private static Attributes.Name independentLibsAttribute;
    private static Set<String> dirsCreatedByThisJVM;
    private File lockFile;
    private FileLockWrapper lock;
    private String dirName;
    private Map<String, String> libNameMap = new HashMap<String, String>();
    private File destination = null;
    static Map<String, NativeLibraryBundle> originFileLocks;

    public synchronized String get(String name) {
        return this.libNameMap.get(name.toLowerCase());
    }

    private synchronized void put(String libname, String path) {
        this.libNameMap.put(libname.toLowerCase(), path);
    }

    protected void finalize() {
        NativeLibraryBundle.releaseLocksOfOriginals(this);
        if (NativeLibraryBundle.deleteRecursively(new File(rootDir, this.dirName))) {
            this.lock.release();
            NativeLibraryBundle.deleteFile(this.lockFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized File getDestinationDir() throws IOException {
        if (this.destination == null) {
            Set<String> set = dirsCreatedByThisJVM;
            synchronized (set) {
                this.lockFile = File.createTempFile("tmp", LOCK_SUFFIX, rootDir);
                String lockFileName = this.lockFile.getName();
                this.dirName = lockFileName.substring(0, lockFileName.lastIndexOf(LOCK_SUFFIX));
                dirsCreatedByThisJVM.add(this.dirName);
            }
            this.lock = FileLockWrapper.lockFile(this.lockFile);
            this.destination = new File(rootDir, this.dirName);
            NativeLibraryBundle.makeDir(this.destination);
        }
        return this.destination;
    }

    private static synchronized boolean tryLockOriginalCopy(File src, boolean dirmode, NativeLibraryBundle bundle) {
        String path = dirmode ? src.getParent() : src.getAbsolutePath();
        NativeLibraryBundle o = originFileLocks.get(path);
        if (o == null) {
            originFileLocks.put(src.getParent(), bundle);
            return true;
        }
        return o == bundle;
    }

    private static synchronized void releaseLocksOfOriginals(NativeLibraryBundle b) {
        Iterator<Map.Entry<String, NativeLibraryBundle>> it = originFileLocks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, NativeLibraryBundle> m = it.next();
            if (m.getValue() == b) continue;
            it.remove();
        }
    }

    private void processLib(Manifest man, File src, boolean dirmode) throws IOException {
        String path = null;
        if (!NativeLibraryBundle.tryLockOriginalCopy(src, dirmode, this)) {
            Trace.println("Failed to grab lock for " + src, TraceLevel.CACHE);
            path = this.copyLib(src);
        } else {
            path = src.getAbsolutePath();
        }
        this.put(src.getName(), path);
    }

    public void prepareLibrary(String libname, JarFile jf, String dir) throws IOException {
        Attributes mainAttr;
        Manifest man = jf.getManifest();
        Attributes attributes = mainAttr = man != null ? man.getMainAttributes() : null;
        if (mainAttr != null && "true".equals(mainAttr.get(independentLibsAttribute))) {
            Trace.println("Lock individual library " + libname, TraceLevel.CACHE);
            File f = new File(dir, libname);
            this.processLib(man, f, false);
        } else {
            File src = new File(dir);
            File[] files = src.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.processLib(man, files[i], true);
            }
        }
    }

    private String copyLib(File src) throws IOException {
        String fileName;
        if (src.isFile() && ((fileName = src.getName()).endsWith(Platform.get().getLibrarySufix()) || OSType.isMac() && fileName.endsWith(".jnilib"))) {
            FileChannel in = new FileInputStream(src).getChannel();
            File dest = new File(this.getDestinationDir(), src.getName());
            FileChannel out = new FileOutputStream(dest).getChannel();
            in.transferTo(0L, in.size(), out);
            out.force(true);
            in.close();
            out.close();
            return dest.getAbsolutePath();
        }
        return null;
    }

    private static void deleteOldDirs() {
        File[] dirs = rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        for (int i = 0; i < dirs.length; ++i) {
            File dir = dirs[i];
            if (dirsCreatedByThisJVM.contains(dir.getName())) continue;
            File lockFile = new File(rootDir, dir.getName() + LOCK_SUFFIX);
            try {
                boolean success;
                FileLockWrapper lock = FileLockWrapper.tryLockFile(lockFile);
                if (lock == null || !(success = NativeLibraryBundle.deleteRecursively(dir))) continue;
                lock.release();
                NativeLibraryBundle.deleteFile(lockFile);
                continue;
            }
            catch (IOException e) {
                Trace.ignoredException(e);
            }
        }
    }

    private static void deleteFile(File file) {
        if (!file.delete()) {
            Trace.print("Failed to delete file " + file.getAbsolutePath());
        }
    }

    private static void makeDir(File dir) {
        if (!dir.mkdir()) {
            Trace.print("Failed to create directory " + dir.getAbsolutePath());
        }
    }

    private static boolean deleteRecursively(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                NativeLibraryBundle.deleteRecursively(file);
                continue;
            }
            NativeLibraryBundle.deleteFile(file);
        }
        return dir.delete();
    }

    static {
        independentLibsAttribute = new Attributes.Name("IndependentLibraries");
        dirsCreatedByThisJVM = Collections.synchronizedSet(new HashSet());
        String rootDirName = System.getProperty("java.io.tmpdir") + File.separator + ".java_jnlp_applet_nativelib_cache." + System.getProperty("user.name");
        rootDir = new File(rootDirName);
        if (!rootDir.exists()) {
            NativeLibraryBundle.makeDir(rootDir);
        }
        Thread t = SafeThreadFactory.createThread(new Runnable(){

            @Override
            public void run() {
                NativeLibraryBundle.deleteOldDirs();
            }
        });
        t.setName("Native Library Cache Cleaner Thread");
        t.setDaemon(true);
        t.start();
        originFileLocks = new HashMap<String, NativeLibraryBundle>();
    }

    static class FileLockWrapper {
        private FileChannel chan;
        private FileLock lock;

        private FileLockWrapper(FileChannel chan, FileLock lock) {
            this.chan = chan;
            this.lock = lock;
        }

        public void release() {
            try {
                this.lock.release();
            }
            catch (IOException e) {
                Trace.ignoredException(e);
            }
            try {
                this.chan.close();
            }
            catch (IOException e) {
                Trace.ignoredException(e);
            }
        }

        public static FileLockWrapper lockFile(File file) throws IOException {
            FileOutputStream str = new FileOutputStream(file);
            FileChannel chan = str.getChannel();
            FileLock lock = chan.lock();
            if (lock == null) {
                chan.close();
                return null;
            }
            return new FileLockWrapper(chan, lock);
        }

        public static FileLockWrapper tryLockFile(File file) throws IOException {
            FileOutputStream str = new FileOutputStream(file);
            FileChannel chan = str.getChannel();
            FileLock lock = chan.tryLock();
            if (lock == null) {
                chan.close();
                return null;
            }
            return new FileLockWrapper(chan, lock);
        }
    }
}

