/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.Environment;
import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.ClientConfig;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.VersionID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SecurityBaseline {
    private static String baseline_131 = BuiltInProperties.getProperty("BASELINE_VERSION_131");
    private static String baseline_142 = BuiltInProperties.getProperty("BASELINE_VERSION_142");
    private static String baseline_150 = BuiltInProperties.getProperty("BASELINE_VERSION_150");
    private static String baseline_160 = BuiltInProperties.getProperty("BASELINE_VERSION_160");
    private static String baseline_170 = BuiltInProperties.getProperty("BASELINE_VERSION_170");
    private static String baseline_180 = BuiltInProperties.getProperty("BASELINE_VERSION_180");
    private static String baseline_190 = BuiltInProperties.getProperty("BASELINE_VERSION_190");
    private static String baseline_10 = BuiltInProperties.getProperty("BASELINE_VERSION_10");
    private static String baseline_11 = BuiltInProperties.getProperty("BASELINE_VERSION_11");
    private static volatile boolean baselines_initialized = false;
    private static final boolean DEBUG = Config.getBooleanProperty("deployment.baseline.debug");
    private static final long UPDATE_INTERVAL = DEBUG ? 10000 : 86400000;
    private static final long THREAD_SLEEP_INTERVAL = DEBUG ? 1000 : 30000;
    private static final String BASELINE_FILENAME = "baseline.versions";
    private static final String SECURITY_PACK_FILENAME = "securitypack.jar";
    private static final String DYNAMIC_BLACKLIST_FILENAME = "blacklist.dynamic";
    private static final String BLACKLIST_CERT_FILENAME = "blacklisted.certs";
    private static final String UPDATE_TIMESTAMP = "update.securitypack.timestamp";
    private static final File securityDir = new File(Config.getLocalOrRoamingUserHome(), "security");
    private static final File securityPackFile = new File(securityDir, "securitypack.jar");
    private static final File baselineFile = new File(securityDir, "baseline.versions");
    private static final File blacklistFile = new File(Config.getDynamicBlacklistFile());
    private static final File blacklistCertsFile = new File(Config.getDynamicBlacklistCertsFile());
    private static final File updateTimestampFile = new File(securityDir, "update.securitypack.timestamp");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize_baselines() {
        if (!baselines_initialized && baselineFile.exists()) {
            BufferedReader br = null;
            try {
                long now = System.currentTimeMillis();
                br = new BufferedReader(new FileReader(baselineFile));
                boolean done = false;
                while (!done) {
                    String line = br.readLine();
                    if (line == null) {
                        done = true;
                        continue;
                    }
                    if (line.startsWith("11.")) {
                        baseline_11 = line;
                        Platform.get().cacheSecurityBaseline("11.0", baseline_11);
                        continue;
                    }
                    if (line.startsWith("10.")) {
                        baseline_10 = line;
                        Platform.get().cacheSecurityBaseline("10.0", baseline_10);
                        continue;
                    }
                    if (line.startsWith("9.")) {
                        baseline_190 = line;
                        Platform.get().cacheSecurityBaseline("9.0", baseline_190);
                        continue;
                    }
                    if (line.startsWith("1.8")) {
                        baseline_180 = line;
                        Platform.get().cacheSecurityBaseline("1.8.0", baseline_180);
                        continue;
                    }
                    if (line.startsWith("1.7")) {
                        baseline_170 = line;
                        Platform.get().cacheSecurityBaseline("1.7.0", baseline_170);
                        continue;
                    }
                    if (line.startsWith("1.6")) {
                        baseline_160 = line;
                        Platform.get().cacheSecurityBaseline("1.6.0", baseline_160);
                        continue;
                    }
                    if (line.startsWith("1.5")) {
                        baseline_150 = line;
                        Platform.get().cacheSecurityBaseline("1.5.0", baseline_150);
                        continue;
                    }
                    if (line.startsWith("1.4.2")) {
                        baseline_142 = line;
                        Platform.get().cacheSecurityBaseline("1.4.2", baseline_142);
                        continue;
                    }
                    if (!line.startsWith("1.3.1")) continue;
                    baseline_131 = line;
                    Platform.get().cacheSecurityBaseline("1.3.1", baseline_131);
                }
                if (DEBUG) {
                    Trace.println("It took " + (System.currentTimeMillis() - now) + " Ms. to read baseline file", TraceLevel.BASIC);
                }
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ioe) {
                    Trace.ignored(ioe);
                }
            }
        }
        baselines_initialized = true;
    }

    public static String getBaselineVersion(String requestedVersion) {
        if (!baselines_initialized) {
            SecurityBaseline.initialize_baselines();
        }
        String baseline = requestedVersion.startsWith("11") ? baseline_11 : (requestedVersion.startsWith("10") ? baseline_10 : (requestedVersion.startsWith("9") ? baseline_190 : (requestedVersion.startsWith("1.8") ? baseline_180 : (requestedVersion.startsWith("1.7") ? baseline_170 : (requestedVersion.startsWith("1.6") ? baseline_160 : (requestedVersion.startsWith("1.5") ? baseline_150 : (requestedVersion.startsWith("1.4.2") ? baseline_142 : (requestedVersion.startsWith("1.3.1") ? baseline_131 : BuiltInProperties.getProperty("CURRENT_VERSION")))))))));
        if (DEBUG) {
            Trace.println("for requested version: " + requestedVersion + "baseline version is: " + baseline, TraceLevel.SECURITY);
        }
        return baseline;
    }

    public static boolean satisfiesSecurityBaseline(String version) {
        if (!Config.isExpirationCheckEnabled()) {
            return true;
        }
        VersionID vid = new VersionID(version);
        VersionID baselineVid = new VersionID(SecurityBaseline.getBaselineVersion(version));
        if (vid.isGreaterThanOrEqual(baselineVid)) {
            return true;
        }
        return vid.equals(JREInfo.getLatestVersion(true));
    }

    public static boolean satisfiesBaselineStrictly(String version) {
        String baselineVersion = SecurityBaseline.getBaselineVersion(version);
        if (!Config.isExpirationCheckEnabled()) {
            return true;
        }
        int index = (version = version.replace(".ea", "-ea")).indexOf("-");
        String ver = index > 0 ? version.substring(0, index) : version;
        index = ver.indexOf("+");
        ver = index > 0 ? ver.substring(0, index) : ver;
        VersionID vid = new VersionID(ver);
        VersionID baselineVid = new VersionID(baselineVersion);
        boolean ret = vid.isGreaterThanOrEqual(baselineVid);
        if (DEBUG) {
            Trace.println("strictly satisfied=" + ret + "  for version: " + version + "  baseline is: " + SecurityBaseline.getBaselineVersion(version));
        }
        return ret;
    }

    public static String getDeployVersion() {
        return BuiltInProperties.getProperty("DEPLOY_VERSION");
    }

    public static String getCurrentVersion() {
        return BuiltInProperties.getProperty("CURRENT_VERSION");
    }

    private static synchronized void checkForUpdates(boolean explicit) {
        UpdateThread updateThread = new UpdateThread(new Runnable(){

            @Override
            public void run() {
                UpdateCheckStatus checkStatus = SecurityBaseline.checkForUpdate(Config.getStringProperty("deployment.baseline.url"), securityPackFile);
                if (checkStatus == UpdateCheckStatus.NEW_UPDATE_DOWNLOADED) {
                    Config cfg;
                    SecurityBaseline.verifyJar(securityPackFile);
                    SecurityBaseline.extractManifests();
                    baselines_initialized = false;
                    SecurityBaseline.initialize_baselines();
                    if (SecurityBaseline.isExpired() && (cfg = Config.get()) instanceof ClientConfig) {
                        ((ClientConfig)cfg).storeConfig();
                    }
                }
                if (checkStatus != UpdateCheckStatus.UPDATE_CHECK_FAILED && checkStatus != UpdateCheckStatus.UPDATE_CHECK_SKIPPED) {
                    SecurityBaseline.setLastChecked(new Date().getTime());
                }
            }
        });
        updateThread.setDaemon(!explicit);
        updateThread.start();
        try {
            updateThread.join();
        }
        catch (InterruptedException ie) {
            Trace.ignored(ie);
        }
    }

    private static void extractManifests() {
        JarFile jf = null;
        try {
            jf = JarUtil.createJarFile(securityPackFile, false);
            SecurityBaseline.extractManifest(jf, BASELINE_FILENAME, baselineFile);
            SecurityBaseline.extractManifest(jf, BLACKLIST_CERT_FILENAME, blacklistCertsFile);
            SecurityBaseline.extractManifest(jf, DYNAMIC_BLACKLIST_FILENAME, blacklistFile);
        }
        catch (IOException e) {
            String msg = "Manifest extractions failed for signed security pack file " + securityPackFile;
            Trace.println(msg, TraceLevel.SECURITY);
            throw new SecurityException(msg, e);
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException e) {
                    Trace.ignored(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyJar(File file) {
        HashSet<CodeSigner> codesigners = new HashSet<CodeSigner>();
        JarFile jf = null;
        String[] entries = new String[]{BASELINE_FILENAME, BLACKLIST_CERT_FILENAME, DYNAMIC_BLACKLIST_FILENAME};
        String msgKey = null;
        Exception exception = null;
        try {
            jf = JarUtil.createJarFile(file, true);
            for (String entryName : entries) {
                InputStream in = null;
                try {
                    int read;
                    JarEntry entry = jf.getJarEntry(entryName);
                    if (entry == null) {
                        String msg = "Verification failed for signed security pack file " + file + ", missing entry " + entryName;
                        Trace.println(msg, TraceLevel.SECURITY);
                        throw new SecurityException(msg, null);
                    }
                    in = jf.getInputStream(entry);
                    byte[] buffer = new byte[1024];
                    while ((read = in.read(buffer)) != -1) {
                    }
                    if (entry.getCodeSigners() == null) continue;
                    for (CodeSigner cs : entry.getCodeSigners()) {
                        codesigners.add(cs);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            Trace.ignored(e);
                        }
                    }
                }
            }
            CodeSigner[] signers = new ArrayList(codesigners).toArray(new CodeSigner[codesigners.size()]);
            URL location = file.toURI().toURL();
            CodeSource cs = new CodeSource(location, signers);
            ValidationState state = TrustDecider.getJarValidationState(cs, null, null);
            if (state.trustDecision == 0L) {
                msgKey = "deployment.securitypack.cannot.validate";
            } else if (state.certValidity != 0) {
                msgKey = "deployment.securitypack.cannot.validate";
            } else if (!state.rootCAValid) {
                msgKey = "deployment.securitypack.cannot.validate.selfsigned";
            } else if (!state.timeValid) {
                msgKey = "deployment.securitypack.cannot.validate.expired";
                exception = state.certExpiredException != null ? state.certExpiredException : state.certNotYetValidException;
            }
        }
        catch (IOException e) {
            msgKey = "deployment.securitypack.cannot.validate.exception";
            exception = e;
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException e) {
                    Trace.ignored(e);
                }
            }
        }
        if (msgKey != null) {
            Trace.println("Verification failed for signed security pack file " + file, TraceLevel.SECURITY);
            throw new SecurityException(ResourceManager.getString(msgKey), exception);
        }
        Trace.println("Verification succeeded for signed security pack file " + file, TraceLevel.SECURITY);
    }

    private static void extractManifest(JarFile jf, String entryName, File outputFile) {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            int read;
            JarEntry entry = jf.getJarEntry(entryName);
            if (entry == null) {
                String msg = "Missing  entry " + entryName;
                Trace.println(msg, TraceLevel.SECURITY);
                throw new SecurityException(msg, null);
            }
            if (outputFile.exists() && outputFile.isDirectory()) {
                SystemUtils.deleteRecursive(outputFile);
            }
            in = jf.getInputStream(entry);
            out = new FileOutputStream(outputFile);
            byte[] buffer = new byte[1024];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            String msg = "Failed to extract " + entryName;
            Trace.println(msg, TraceLevel.SECURITY);
            throw new SecurityException(msg, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    Trace.ignored(e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Trace.ignored(e);
                }
            }
        }
    }

    private static UpdateCheckStatus checkForUpdate(final String urlString, final File file) {
        if (Platform.get().isScreenLocked()) {
            return UpdateCheckStatus.UPDATE_CHECK_SKIPPED;
        }
        UpdateCheckStatus result = AccessController.doPrivileged(new PrivilegedAction<UpdateCheckStatus>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UpdateCheckStatus run() {
                UpdateCheckStatus result = UpdateCheckStatus.UPDATE_NOT_REQUIRED;
                if (urlString != null && urlString.length() > 0) {
                    long fileTimeStamp = 0L;
                    long serverTimeStamp = 0L;
                    if (file.exists() && file.isDirectory()) {
                        try {
                            SystemUtils.deleteRecursive(file);
                        }
                        catch (FileNotFoundException ex) {
                            Trace.ignored(ex);
                        }
                    } else if (file.exists()) {
                        fileTimeStamp = file.lastModified();
                    }
                    InputStream in = null;
                    FileOutputStream out = null;
                    try {
                        Trace.println("Checking for update at: " + urlString, TraceLevel.NETWORK);
                        URL url = new URL(urlString);
                        URLConnection connection = url.openConnection();
                        connection.setUseCaches(false);
                        serverTimeStamp = connection.getLastModified();
                        if (serverTimeStamp >= fileTimeStamp) {
                            int read;
                            Trace.println("Updating file at: " + file + " from url: " + urlString, TraceLevel.NETWORK);
                            in = connection.getInputStream();
                            out = new FileOutputStream(file);
                            byte[] buffer = new byte[8192];
                            while ((read = in.read(buffer)) != -1) {
                                out.write(buffer, 0, read);
                            }
                            result = UpdateCheckStatus.NEW_UPDATE_DOWNLOADED;
                        }
                    }
                    catch (Exception e) {
                        result = UpdateCheckStatus.UPDATE_CHECK_FAILED;
                        Trace.ignored(e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception ee) {
                                Trace.ignored(ee);
                            }
                            if (serverTimeStamp > 0L) {
                                file.setLastModified(serverTimeStamp);
                            }
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception ee) {
                                Trace.ignored(ee);
                            }
                        }
                    }
                }
                return result;
            }
        });
        return result;
    }

    private static long getLastChecked() {
        if (updateTimestampFile.isFile() && updateTimestampFile.exists()) {
            return updateTimestampFile.lastModified();
        }
        return 0L;
    }

    private static void setLastChecked(long time) {
        try {
            if (updateTimestampFile.exists() && updateTimestampFile.isDirectory()) {
                SystemUtils.deleteRecursive(updateTimestampFile);
            }
            FileOutputStream os = new FileOutputStream(updateTimestampFile);
            ((OutputStream)os).write(46);
            ((OutputStream)os).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void backgroundUpdate() {
        if (Platform.get().isNativeSandbox()) {
            return;
        }
        UpdateThread t = new UpdateThread(new Runnable(){

            @Override
            public void run() {
                long now = new Date().getTime();
                if (now > SecurityBaseline.getLastChecked() + UPDATE_INTERVAL) {
                    try {
                        Thread.sleep(THREAD_SLEEP_INTERVAL);
                        SecurityBaseline.checkForUpdates(false);
                    }
                    catch (Exception e) {
                        Trace.ignored(e);
                    }
                }
                if (DEBUG) {
                    Trace.println("Baseline/Blacklist thread exiting time: " + (new Date().getTime() - now), TraceLevel.BASIC);
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public static void forceBaselineUpdate() {
        SecurityBaseline.checkForUpdates(true);
        SecurityBaseline.initialize_baselines();
    }

    public static boolean isExpired() {
        if (!Config.isExpirationCheckEnabled()) {
            return false;
        }
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (Environment.getenv("JRE_NOTEXPIRED") != null) {
                    return Boolean.FALSE;
                }
                if (Environment.getenv("JRE_EXPIRED") != null) {
                    return Boolean.TRUE;
                }
                return null;
            }
        });
        if (result != null) {
            return result;
        }
        Date expirationDate = new Date(BuiltInProperties.getExpirationTime());
        if (expirationDate.before(new Date())) {
            return true;
        }
        return !SecurityBaseline.satisfiesBaselineStrictly(JREInfo.getLatest());
    }

    public static boolean isUpdateThread() {
        return Thread.currentThread() instanceof UpdateThread;
    }

    static {
        if (Config.get() instanceof DefaultConfig) {
            Trace.ignored(new RuntimeException("Default config is used for security baseline initialization."));
        }
        securityDir.mkdirs();
        SecurityBaseline.backgroundUpdate();
    }

    private static class UpdateThread
    extends Thread {
        UpdateThread(Runnable r) {
            super(r);
        }
    }

    static enum UpdateCheckStatus {
        NEW_UPDATE_DOWNLOADED,
        UPDATE_NOT_REQUIRED,
        UPDATE_CHECK_FAILED,
        UPDATE_CHECK_SKIPPED;

    }
}

