/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.javascript;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;

public final class JSClassLoader
extends SecureClassLoader {
    private static final String JS_PROXY_PKG = "sun.plugin.javascript.";
    private static final String TRAMPOLINE = "sun.plugin.javascript.Trampoline";
    private static Method bounce = JSClassLoader.bounce();
    private static Method bounceForNewInstance = JSClassLoader.bounceForNewInstance();

    private JSClassLoader() {
    }

    public static Object invoke(Method m, Object obj, Object[] params) throws InvocationTargetException, IllegalAccessException {
        try {
            return bounce.invoke(null, m, obj, params);
        }
        catch (InvocationTargetException ie) {
            Throwable t = ie.getCause();
            if (t instanceof InvocationTargetException) {
                throw (InvocationTargetException)t;
            }
            if (t instanceof IllegalAccessException) {
                throw (IllegalAccessException)t;
            }
            throw new Error("Unexpected invocation error", t);
        }
        catch (IllegalAccessException iae) {
            throw new Error("Unexpected invocation error", iae);
        }
    }

    public static Object newInstance(Constructor<?> c, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        try {
            return bounceForNewInstance.invoke(null, c, params);
        }
        catch (InvocationTargetException ie) {
            Throwable t = ie.getCause();
            if (t instanceof InvocationTargetException) {
                throw (InvocationTargetException)t;
            }
            if (t instanceof IllegalAccessException) {
                throw (IllegalAccessException)t;
            }
            if (t instanceof InstantiationException) {
                throw (InstantiationException)t;
            }
            throw new Error("Unexpected invocation error", t);
        }
        catch (IllegalAccessException iae) {
            throw new Error("Unexpected invocation error", iae);
        }
    }

    public static void checkPackageAccess(Class<?> clazz) {
        String clsname = clazz.getName();
        int index = clsname.lastIndexOf(".");
        if (index != -1) {
            String pkgname = clsname.substring(0, index);
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                s.checkPackageAccess(pkgname);
            }
        }
    }

    public static boolean isPackageAccessible(Class<?> clazz) {
        try {
            JSClassLoader.checkPackageAccess(clazz);
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    private static Method bounce() {
        if (bounce == null) {
            try {
                bounce = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws Exception {
                        Class t = JSClassLoader.getTrampolineClass();
                        Class[] types = new Class[]{Method.class, Object.class, Object[].class};
                        Method b = t.getDeclaredMethod("invoke", types);
                        b.setAccessible(true);
                        return b;
                    }
                });
            }
            catch (Exception e) {
                throw new InternalError("No trampoline to bounce on");
            }
        }
        return bounce;
    }

    private static Method bounceForNewInstance() {
        if (bounceForNewInstance == null) {
            try {
                bounceForNewInstance = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws Exception {
                        Class t = JSClassLoader.getTrampolineClass();
                        Class[] types = new Class[]{Constructor.class, Object[].class};
                        Method b = t.getDeclaredMethod("newInstance", types);
                        b.setAccessible(true);
                        return b;
                    }
                });
            }
            catch (Exception e) {
                throw new InternalError("No trampoline to bounce on");
            }
        }
        return bounceForNewInstance;
    }

    private static Class<?> getTrampolineClass() {
        try {
            return Class.forName(TRAMPOLINE, true, new JSClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            int i;
            int b;
            String cname = name.replace('/', '.');
            if (cname.startsWith("[") && (b = cname.lastIndexOf(91) + 2) > 1 && b < cname.length()) {
                cname = cname.substring(b);
            }
            if ((i = cname.lastIndexOf(46)) != -1) {
                s.checkPackageAccess(cname.substring(0, i));
            }
        }
        if ((c = this.findLoadedClass(name)) == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c == null) {
                c = this.getParent().loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!name.startsWith(JS_PROXY_PKG)) {
            throw new ClassNotFoundException(name);
        }
        String path = "/" + name.replace('.', '/').concat(".class");
        try {
            byte[] b = JSClassLoader.getBytes(this.getClass().getResource(path));
            if (b != null) {
                return this.defineClass(name, b);
            }
        }
        catch (Exception e) {
            throw new ClassNotFoundException(name, e);
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> defineClass(String name, byte[] b) throws IOException {
        CodeSource cs = new CodeSource(null, (Certificate[])null);
        if (!name.equals(TRAMPOLINE)) {
            throw new IOException("JSClassLoader: bad name " + name);
        }
        return this.defineClass(name, b, 0, b.length, cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(URL url) throws IOException {
        HttpURLConnection huc;
        int code;
        if (url == null) {
            return null;
        }
        URLConnection uc = url.openConnection();
        if (uc instanceof HttpURLConnection && (code = (huc = (HttpURLConnection)uc).getResponseCode()) >= 400) {
            throw new IOException("open HTTP connection failed.");
        }
        try (BufferedInputStream in = new BufferedInputStream(uc.getInputStream());){
            int len;
            if (len != -1) {
                int n2;
                byte[] b = new byte[len];
                for (len = uc.getContentLength(); len > 0; len -= n2) {
                    n2 = ((InputStream)in).read(b, b.length - len, len);
                    if (n2 != -1) continue;
                    throw new IOException("unexpected EOF");
                }
                byte[] n2 = b;
                return n2;
            }
            byte[] temp = new byte[8192];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            do {
                if ((len = ((InputStream)in).read(temp)) <= 0) continue;
                baos.write(temp, 0, len);
            } while (len > -1);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection perms = super.getPermissions(codesource);
        perms.add(new AllPermission());
        return perms;
    }
}

