/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.liveconnect;

import java.io.IOException;
import sun.plugin2.liveconnect.BrowserSideObject;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.message.Serializer;

public final class ArgumentHelper {
    private static final int NULL_TAG = 0;
    private static final int STRING_TAG = 1;
    private static final int BOOLEAN_TAG = 2;
    private static final int BYTE_TAG = 3;
    private static final int CHARACTER_TAG = 4;
    private static final int SHORT_TAG = 5;
    private static final int INTEGER_TAG = 6;
    private static final int LONG_TAG = 7;
    private static final int FLOAT_TAG = 8;
    private static final int DOUBLE_TAG = 9;
    private static final int BROWSER_SIDE_OBJECT_TAG = 10;
    private static final int REMOTE_JAVA_OBJECT_TAG = 11;

    private ArgumentHelper() {
    }

    public static boolean isPrimitiveOrString(Object obj) {
        if (obj instanceof String) {
            return true;
        }
        return ArgumentHelper.isPrimitive(obj);
    }

    public static boolean isPrimitive(Object obj) {
        return obj instanceof Boolean || obj instanceof Byte || obj instanceof Character || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double;
    }

    public static void validate(Object[] argArray) throws IllegalArgumentException {
        if (argArray != null) {
            for (Object argArray1 : argArray) {
                ArgumentHelper.validate(argArray1);
            }
        }
    }

    public static void writeObject(Serializer ser, Object obj) throws IOException {
        if (obj == null) {
            ser.writeByte((byte)0);
            return;
        }
        if (obj instanceof String) {
            ser.writeByte((byte)1);
            ser.writeUTF((String)obj);
        } else if (obj instanceof Boolean) {
            ser.writeByte((byte)2);
            ser.writeBoolean((Boolean)obj);
        } else if (obj instanceof Byte) {
            ser.writeByte((byte)3);
            ser.writeByte((Byte)obj);
        } else if (obj instanceof Character) {
            ser.writeByte((byte)4);
            ser.writeChar(((Character)obj).charValue());
        } else if (obj instanceof Short) {
            ser.writeByte((byte)5);
            ser.writeShort((Short)obj);
        } else if (obj instanceof Integer) {
            ser.writeByte((byte)6);
            ser.writeInt((Integer)obj);
        } else if (obj instanceof Long) {
            ser.writeByte((byte)7);
            ser.writeLong((Long)obj);
        } else if (obj instanceof Float) {
            ser.writeByte((byte)8);
            ser.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Double) {
            ser.writeByte((byte)9);
            ser.writeDouble((Double)obj);
        } else if (obj instanceof BrowserSideObject) {
            ser.writeByte((byte)10);
            ser.writeLong(((BrowserSideObject)obj).getNativeObjectReference());
        } else if (obj instanceof RemoteJavaObject) {
            ser.writeByte((byte)11);
            RemoteJavaObject.write(ser, (RemoteJavaObject)obj);
        } else {
            throw new RuntimeException("Can't serialize objects of type " + obj.getClass().getName());
        }
    }

    public static Object readObject(Serializer ser) throws IOException {
        int tag = ser.readByte() & 0xFF;
        switch (tag) {
            case 0: {
                return null;
            }
            case 1: {
                return ser.readUTF();
            }
            case 2: {
                return ser.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return ser.readByte();
            }
            case 4: {
                return Character.valueOf(ser.readChar());
            }
            case 5: {
                return ser.readShort();
            }
            case 6: {
                return ser.readInt();
            }
            case 7: {
                return ser.readLong();
            }
            case 8: {
                return Float.valueOf(ser.readFloat());
            }
            case 9: {
                return ser.readDouble();
            }
            case 10: {
                return new BrowserSideObject(ser.readLong());
            }
            case 11: {
                return RemoteJavaObject.read(ser);
            }
        }
        throw new RuntimeException("Unexpected object tag " + tag);
    }

    public static void writeObjectArray(Serializer ser, Object[] argumentArray) throws IOException {
        if (argumentArray == null) {
            ser.writeBoolean(false);
            return;
        }
        ser.writeBoolean(true);
        ser.writeInt(argumentArray.length);
        for (Object argumentArray1 : argumentArray) {
            ArgumentHelper.writeObject(ser, argumentArray1);
        }
    }

    public static Object[] readObjectArray(Serializer ser) throws IOException {
        if (!ser.readBoolean()) {
            return null;
        }
        int length = ser.readInt();
        Object[] res = new Object[length];
        for (int i = 0; i < length; ++i) {
            res[i] = ArgumentHelper.readObject(ser);
        }
        return res;
    }

    private static void validate(Object obj) throws IllegalArgumentException {
        if (obj == null) {
            return;
        }
        if (ArgumentHelper.isPrimitiveOrString(obj)) {
            return;
        }
        if (obj instanceof BrowserSideObject) {
            return;
        }
        if (obj instanceof RemoteJavaObject) {
            return;
        }
        throw new IllegalArgumentException("Can't pass instances of class " + obj.getClass().getName() + " between JVMs");
    }
}

