/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.deploy.uitoolkit.impl.awt.ui.AWTDialog;
import com.sun.deploy.uitoolkit.ui.AbstractDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.windows.WEmbeddedFrame;
import sun.plugin.util.UIUtil;
import sun.plugin2.main.client.ModalityInterface;
import sun.plugin2.main.client.PrintBandDescriptor;
import sun.plugin2.main.client.WDonatePrivilege;
import sun.plugin2.message.EventMessage;
import sun.plugin2.message.Pipe;

public class PluginEmbeddedFrame
extends WEmbeddedFrame {
    private static final long serialVersionUID = 5028464123283596513L;
    private ModalityInterface modality;
    private int bandWidth = 0;
    private int bandHeight = 0;
    private int imgWid = 0;
    private int imgHgt = 0;
    private static final int MAX_BAND_SIZE = 30720;

    public PluginEmbeddedFrame(long handle, String caRenderServerName, boolean supportsXEmbed, ModalityInterface modality, Pipe pipe, int appletID) {
        super(handle);
        this.modality = modality;
    }

    public void addNotify() {
        UIUtil.disableBackgroundErase((Component)((Object)this));
        super.addNotify();
    }

    public void notifyModalBlocked(Dialog blocker, boolean blocked) {
        if (this.modality != null) {
            if (blocked) {
                this.modality.modalityPushed((AbstractDialog)AWTDialog.getAWTDialog((Dialog)blocker));
            } else {
                this.modality.modalityPopped((AbstractDialog)AWTDialog.getAWTDialog((Dialog)blocker));
            }
        }
    }

    public PrintBandDescriptor printPlugin(PrintBandDescriptor bandInfo, boolean isPrinterDC) {
        int currBandHeight;
        PrintBandDescriptor retBandInfo = null;
        BufferedImage bandImage = null;
        Graphics2D g2d = null;
        int bandTop = 0;
        int xscale = 1;
        int yscale = 1;
        int frameHeight = this.getHeight();
        boolean isLastBand = false;
        if (isPrinterDC) {
            // empty if block
        }
        if (bandInfo == null) {
            if (bandImage == null) {
                this.bandWidth = this.getWidth();
                if (this.bandWidth % 4 != 0) {
                    this.bandWidth += 4 - this.bandWidth % 4;
                }
                if (this.bandWidth <= 0) {
                    return null;
                }
                this.bandHeight = Math.min(30720 / this.bandWidth, frameHeight);
                this.imgWid = this.bandWidth * xscale;
                this.imgHgt = this.bandHeight * yscale;
                bandImage = new BufferedImage(this.imgWid, this.imgHgt, 5);
            }
            g2d = (Graphics2D)bandImage.getGraphics();
            g2d.translate(0, this.imgHgt);
            g2d.scale(xscale, -yscale);
        } else {
            retBandInfo = bandInfo;
            bandImage = bandInfo.getBandImage();
            g2d = bandInfo.getG2D();
            bandTop = bandInfo.getNextBandTop();
            isLastBand = bandInfo.isLastBand();
            if (bandImage == null || g2d == null) {
                return null;
            }
        }
        if (bandTop < frameHeight && !isLastBand) {
            ByteInterleavedRaster ras = (ByteInterleavedRaster)bandImage.getRaster();
            byte[] data = ras.getDataStorage();
            Graphics clearGraphics = bandImage.getGraphics();
            clearGraphics.setColor(Color.white);
            clearGraphics.fillRect(0, 0, this.bandWidth, this.bandHeight);
            this.printComponents(g2d);
            int imageOffset = 0;
            currBandHeight = this.bandHeight;
            int currImgHeight = this.imgHgt;
            if (bandTop + this.bandHeight > frameHeight) {
                currBandHeight = frameHeight - bandTop;
                currImgHeight = currBandHeight * yscale;
                imageOffset = this.imgWid * (this.imgHgt - currImgHeight) * 3;
                isLastBand = true;
            }
            int nextBandTop = bandTop + currBandHeight;
            if (retBandInfo == null) {
                retBandInfo = new PrintBandDescriptor(bandImage, g2d, nextBandTop, isLastBand, data, imageOffset, 0, 0, this.imgWid, currImgHeight, 0, bandTop, this.bandWidth, currBandHeight);
            } else {
                retBandInfo.updateBandInfo(nextBandTop, isLastBand, data, imageOffset, 0, 0, this.imgWid, currImgHeight, 0, bandTop, this.bandWidth, currBandHeight);
            }
        } else {
            return null;
        }
        g2d.translate(0, -currBandHeight);
        return retBandInfo;
    }

    protected boolean traverseOut(boolean direction) {
        WDonatePrivilege.transferFocus((int)this.getEmbedderHandle(), direction);
        return true;
    }

    public void synthesizeEvent(EventMessage msg) {
    }

    public int getLayerID() {
        return -1;
    }
}

