/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import java.io.IOException;
import java.net.URL;
import sun.plugin2.message.AppletMessage;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Serializer;
import sun.plugin2.message.helper.URLHelper;

public class CookieOpMessage
extends AppletMessage {
    public static final int ID = 45;
    public static final int GET_COOKIE = 1;
    public static final int SET_COOKIE = 2;
    private int operationKind;
    private URL url;
    private String cookie;

    public CookieOpMessage(Conversation c) {
        super(45, c);
    }

    public CookieOpMessage(Conversation c, int appletID, int operationKind, URL url, String cookie) throws IllegalArgumentException {
        super(45, c, appletID);
        if (operationKind != 1 && operationKind != 2) {
            throw new IllegalArgumentException("Illegal operationKind");
        }
        if (url == null) {
            throw new IllegalArgumentException("Null URL");
        }
        this.operationKind = operationKind;
        this.url = url;
        this.cookie = cookie;
    }

    public int getOperationKind() {
        return this.operationKind;
    }

    public URL getURL() {
        return this.url;
    }

    public String getCookie() {
        return this.cookie;
    }

    @Override
    public void writeFields(Serializer ser) throws IOException {
        super.writeFields(ser);
        ser.writeInt(this.operationKind);
        URLHelper.write(ser, this.url);
        ser.writeUTF(this.cookie);
    }

    @Override
    public void readFields(Serializer ser) throws IOException {
        super.readFields(ser);
        this.operationKind = ser.readInt();
        this.url = URLHelper.read(ser);
        this.cookie = ser.readUTF();
    }
}

