/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message.transport;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Message;
import sun.plugin2.message.Serializer;
import sun.plugin2.message.transport.Transport;

public abstract class SerializingTransport
implements Transport {
    private Map<Integer, Constructor<?>> messageIDMap = new HashMap();
    private final Object writeLock = new Object();

    protected SerializingTransport() {
    }

    public void registerMessageID(int id, Class<?> messageClass) throws IllegalArgumentException {
        Integer i = id;
        if (this.messageIDMap.get(i) != null) {
            throw new IllegalArgumentException("Message ID " + id + " already registered");
        }
        try {
            Constructor<?> c = messageClass.getConstructor(Conversation.class);
            this.messageIDMap.put(i, c);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Message msg) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            Serializer ser = this.getSerializer();
            ser.writeInt(msg.getID());
            ser.writeConversation(msg.getConversation());
            msg.writeFields(ser);
            this.signalDataWritten();
        }
    }

    @Override
    public Message read() throws IOException {
        if (!this.isDataAvailable()) {
            return null;
        }
        Serializer ser = this.getSerializer();
        int id = ser.readInt();
        Constructor<?> ctor = this.messageIDMap.get(id);
        if (ctor == null) {
            throw new IOException("Unregistered message ID " + id);
        }
        Conversation conv = ser.readConversation();
        Message msg = null;
        try {
            msg = (Message)ctor.newInstance(conv);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
        msg.readFields(ser);
        this.signalDataRead();
        return msg;
    }

    @Override
    public abstract void waitForData(long var1) throws IOException;

    protected abstract void signalDataWritten() throws IOException;

    protected abstract void signalDataRead();

    protected abstract boolean isDataAvailable() throws IOException;

    protected abstract Serializer getSerializer();
}

