/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.uitoolkit.impl.awt;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SafeThreadFactory;
import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import sun.plugin.util.UIUtil;

public class AWTAnimationPanel2
extends Canvas
implements Runnable {
    private static final long serialVersionUID = -7353646551641515484L;
    private static final int ANIMATION_CYCLE_TIME = 2000;
    private static final int ZIPPY_PULSE_TIME = 300;
    private static final long[] stateStops = new long[]{0L, 300L, 99999999L, 750L, 950L, 300L, 1000L};
    private static final String JAVA_LOGO_IMAGE = "JavaCupLogo-161.png";
    private static final String JAVA_COM_IMAGE = "javacom300.png";
    private Color bgColor;
    private Color fgColor = Color.BLACK;
    private Image javaLogoImage;
    private Image javaComImage;
    private boolean preloadedAll = false;
    private boolean errorDuringPreloading = false;
    private Image backbuffer = null;
    private float loadingProgress;
    private float spinnerProgress;
    private static final int NUM_SPINNER_STOPS = 16;
    private static final int SPINNER_R = 84;
    private static final int SPINNER_G = 130;
    private static final int SPINNER_B = 161;
    private long startTime;
    private long initialStartTime;
    private int currentState = 1;
    private float stateProgress;
    private boolean showLogoAndText;
    private float zippyProgress;
    private float zippyStartProgress;
    private long zippyStartTime;
    private boolean fadeAway;
    private boolean animationThreadRunning = false;

    public AWTAnimationPanel2() {
        UIUtil.disableBackgroundErase(this);
        this.setBoxBGColor(Color.WHITE);
    }

    public void setBoxBGColor(Color bgColor) {
        this.setBackground(bgColor);
        this.bgColor = bgColor;
    }

    public void setBoxFGColor(Color fgColor) {
        this.fgColor = fgColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnimation() {
        AWTAnimationPanel2 aWTAnimationPanel2 = this;
        synchronized (aWTAnimationPanel2) {
            if (this.animationThreadRunning) {
                return;
            }
            this.animationThreadRunning = true;
        }
        Thread t = SafeThreadFactory.createThread((Runnable)this);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation() {
        AWTAnimationPanel2 aWTAnimationPanel2 = this;
        synchronized (aWTAnimationPanel2) {
            this.animationThreadRunning = false;
        }
    }

    public float getProgressValue() {
        return this.loadingProgress;
    }

    public void setProgressValue(float value) {
        this.zippyStartTime = 0L;
        this.zippyStartProgress = this.zippyProgress;
        this.loadingProgress = value;
    }

    public void fadeAway() {
        if (this.currentState == 2 && !this.fadeAway) {
            this.setProgressValue(1.0f);
            this.fadeAway = true;
        }
    }

    private void preloadResources() {
        if (this.preloadedAll || this.errorDuringPreloading) {
            return;
        }
        MediaTracker mt = new MediaTracker(this);
        this.javaLogoImage = ResourceManager.getImageResource((String)JAVA_LOGO_IMAGE);
        mt.addImage(this.javaLogoImage, 0);
        this.javaComImage = ResourceManager.getImageResource((String)JAVA_COM_IMAGE);
        mt.addImage(this.javaComImage, 1);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            this.errorDuringPreloading = true;
            return;
        }
        this.preloadedAll = true;
    }

    private void allocateBackBuffer(int width, int height) {
        if (this.backbuffer != null && (this.backbuffer.getWidth(null) != width || this.backbuffer.getHeight(null) != height)) {
            this.backbuffer.flush();
            this.backbuffer = null;
        }
        if (this.backbuffer == null) {
            this.backbuffer = this.createImage(width, height);
            if (this.backbuffer == null) {
                this.backbuffer = new BufferedImage(width, height, 2);
            }
        }
    }

    private Dimension getImageBoundsWithinSize(int imageWidth, int imageHeight, int containerSize, float scaleFactor) {
        float sf = scaleFactor * (float)containerSize / (float)Math.sqrt(imageWidth * imageWidth + imageHeight * imageHeight);
        return new Dimension((int)((float)imageWidth * sf), (int)((float)imageHeight * sf));
    }

    private static float bias(float val, float bias) {
        return bias + val * (1.0f - bias);
    }

    private void renderSpinner(Graphics2D g2d, int w, int h, int size) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int spinnerInnerSize = (int)Math.max(1.0f, 0.04f * (float)size);
        int spinnerOuterSize = (int)Math.max(1.0f, 0.05f * (float)size);
        int spinnerRadius = (int)Math.max(1.0f, 0.35f * (float)size);
        int centerX = w / 2;
        int centerY = h / 2;
        AffineTransform oldxform = g2d.getTransform();
        g2d.translate((double)centerX, (float)centerY - 0.05f * (float)size);
        if (this.showLogoAndText) {
            Dimension imageSize = this.getImageBoundsWithinSize(this.javaLogoImage.getWidth(null), this.javaLogoImage.getHeight(null), size, 0.6f);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.drawImage(this.javaLogoImage, -imageSize.width / 2, -imageSize.height / 2, imageSize.width, imageSize.height, null);
        }
        double incr = 0.39269908169872414;
        int vertScale = this.showLogoAndText ? 1 : 5;
        int[] xPoints = new int[]{-spinnerOuterSize, spinnerOuterSize, spinnerInnerSize, -spinnerInnerSize};
        int[] yPoints = new int[]{-spinnerOuterSize, -spinnerOuterSize, vertScale * spinnerInnerSize, vertScale * spinnerInnerSize};
        g2d.rotate(-incr / 2.0);
        g2d.translate(0, -spinnerRadius);
        float bias = 0.1f;
        float gradientOffset = this.spinnerProgress;
        float gradientIncr = 0.0625f;
        for (int i = 0; i < 16; ++i) {
            float lowAlpha;
            g2d.translate(0, spinnerRadius);
            g2d.rotate(-incr);
            g2d.translate(0, -spinnerRadius);
            float highAlpha = lowAlpha + gradientIncr;
            boolean boundary = false;
            for (lowAlpha = (float)i * gradientIncr + gradientOffset; lowAlpha > 1.0f; lowAlpha -= 1.0f) {
            }
            while (highAlpha > 1.0f) {
                highAlpha -= 1.0f;
            }
            if (lowAlpha > highAlpha) {
                boundary = true;
            }
            if (!boundary) {
                GradientPaint paint = new GradientPaint(-spinnerOuterSize, 0.0f, new Color(84, 130, 161, (int)(255.0f * AWTAnimationPanel2.bias(1.0f - lowAlpha, bias))), spinnerOuterSize, 0.0f, new Color(84, 130, 161, (int)(255.0f * AWTAnimationPanel2.bias(1.0f - highAlpha, bias))));
                g2d.setPaint(paint);
                g2d.fillPolygon(xPoints, yPoints, xPoints.length);
                continue;
            }
            float frac = highAlpha / gradientIncr;
            int outerSplit = (int)(frac * 2.0f * (float)spinnerOuterSize);
            int innerSplit = (int)(frac * 2.0f * (float)spinnerInnerSize);
            GradientPaint paint = new GradientPaint(-spinnerOuterSize + outerSplit, 0.0f, new Color(84, 130, 161, (int)(255.0f * AWTAnimationPanel2.bias(0.0f, bias))), spinnerOuterSize, 0.0f, new Color(84, 130, 161, (int)(255.0f * AWTAnimationPanel2.bias(highAlpha, bias))));
            g2d.setPaint(paint);
            g2d.fillPolygon(new int[]{-spinnerOuterSize + outerSplit, spinnerOuterSize, spinnerInnerSize, -spinnerInnerSize + innerSplit}, yPoints, yPoints.length);
            paint = new GradientPaint(-spinnerOuterSize, 0.0f, new Color(84, 130, 161, (int)(255.0f * AWTAnimationPanel2.bias(lowAlpha, bias))), -spinnerOuterSize + outerSplit, 0.0f, new Color(84, 130, 161, (int)(255.0f * AWTAnimationPanel2.bias(1.0f, bias))));
            g2d.setPaint(paint);
            g2d.fillPolygon(new int[]{-spinnerOuterSize, -spinnerOuterSize + outerSplit, -spinnerInnerSize + innerSplit, -spinnerInnerSize}, yPoints, yPoints.length);
        }
        g2d.setTransform(oldxform);
    }

    private void renderProgress(Graphics2D g2d, int w, int h, int size) {
        int progressWidth = (int)((float)size * 0.7f);
        int progressHeight = (int)Math.max(4.0f, (float)size * 0.05f);
        progressHeight = Math.min(8, progressHeight);
        int progressX = (w - progressWidth) / 2;
        int progressY = (int)(((float)h + 0.9f * (float)size) / 2.0f) - progressHeight;
        g2d.setColor(this.fgColor);
        g2d.drawRect(progressX, progressY, progressWidth, progressHeight);
        int progW = (int)((float)progressWidth * this.zippyProgress);
        g2d.fillRect(progressX + 2, progressY + 2, progW - 3, progressHeight - 3);
    }

    private void renderJavaCom(Graphics2D g2d, int w, int h, int size) {
        if (this.showLogoAndText) {
            int centerX = w / 2;
            int centerY = h / 2;
            AffineTransform oldxform = g2d.getTransform();
            g2d.translate((double)centerX, (float)centerY - 0.05f * (float)size);
            Dimension imageSize = this.getImageBoundsWithinSize(this.javaComImage.getWidth(null), this.javaComImage.getHeight(null), size, 0.6f);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.drawImage(this.javaComImage, -imageSize.width / 2, -imageSize.height / 2, imageSize.width, imageSize.height, null);
        }
    }

    private void renderState1(Graphics2D g2d, int w, int h, int size) {
        Composite oldcomp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, this.stateProgress));
        this.renderSpinner(g2d, w, h, size);
        this.renderProgress(g2d, w, h, size);
    }

    private void renderState2(Graphics2D g2d, int w, int h, int size) {
        this.renderSpinner(g2d, w, h, size);
        this.renderProgress(g2d, w, h, size);
    }

    private void renderState3(Graphics2D g2d, int w, int h, int size) {
        Composite oldcomp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f - this.stateProgress));
        this.renderSpinner(g2d, w, h, size);
        this.renderProgress(g2d, w, h, size);
        g2d.setComposite(AlphaComposite.getInstance(3, this.stateProgress));
        this.renderJavaCom(g2d, w, h, size);
        g2d.setComposite(oldcomp);
    }

    private void renderState4(Graphics2D g2d, int w, int h, int size) {
        if (this.showLogoAndText) {
            this.renderJavaCom(g2d, w, h, size);
        } else {
            ++this.currentState;
        }
    }

    private void renderState5(Graphics2D g2d, int w, int h, int size) {
        if (this.showLogoAndText) {
            Composite oldcomp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f - this.stateProgress));
            this.renderJavaCom(g2d, w, h, size);
            g2d.setComposite(oldcomp);
        } else {
            ++this.currentState;
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.animationThreadRunning) {
            try {
                this.doPaint(g);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void doPaint(Graphics g) {
        int h;
        int w = this.getWidth();
        int size = AWTAnimationPanel2.getBoxSize(w, h = this.getHeight());
        if (size <= 0) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, w, h);
            return;
        }
        this.preloadResources();
        if (!this.preloadedAll) {
            return;
        }
        this.allocateBackBuffer(w, h);
        this.showLogoAndText = size >= 50;
        Graphics2D g2d = (Graphics2D)this.backbuffer.getGraphics();
        g2d.setColor(this.bgColor);
        g2d.fillRect(0, 0, w, h);
        switch (this.currentState) {
            case 1: {
                this.renderState1(g2d, w, h, size);
                break;
            }
            case 2: {
                this.renderState2(g2d, w, h, size);
                break;
            }
            case 3: {
                this.renderState3(g2d, w, h, size);
                break;
            }
            case 4: {
                this.renderState4(g2d, w, h, size);
                break;
            }
            case 5: {
                this.renderState5(g2d, w, h, size);
                break;
            }
        }
        g2d.dispose();
        g.drawImage(this.backbuffer, 0, 0, null);
    }

    private static int getBoxSize(int w, int h) {
        int mindim;
        int n = mindim = w > h ? h : w;
        if (mindim < 25) {
            return 0;
        }
        if (mindim < 200) {
            return (int)(0.75f * (float)mindim);
        }
        if (mindim < 300) {
            return 150;
        }
        if (mindim > 600) {
            return 300;
        }
        return mindim / 2;
    }

    private static float convertToNonLinear(float fraction, float accel, float decel) {
        float runRate = 1.0f / (1.0f - accel / 2.0f - decel / 2.0f);
        if (fraction < accel) {
            float averageRunRate = runRate * (fraction / accel) / 2.0f;
            fraction *= averageRunRate;
        } else if (fraction > 1.0f - decel) {
            float tdec = fraction - (1.0f - decel);
            float pdec = tdec / decel;
            fraction = runRate * (1.0f - accel / 2.0f - decel + tdec * (2.0f - pdec) / 2.0f);
        } else {
            fraction = runRate * (fraction - accel / 2.0f);
        }
        return fraction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
            AWTAnimationPanel2 aWTAnimationPanel2 = this;
            synchronized (aWTAnimationPanel2) {
                if (!this.animationThreadRunning) {
                    break;
                }
            }
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            long currentTime = System.currentTimeMillis();
            if (this.isShowing()) {
                try {
                    this.doPaint(this.getGraphics());
                }
                catch (RuntimeException e) {
                    Trace.ignoredException((Exception)e);
                }
            }
            long elapsed = currentTime - this.startTime;
            if (this.initialStartTime == 0L) {
                this.initialStartTime = this.startTime;
            }
            long totalElapsed = currentTime - this.initialStartTime;
            if (this.currentState < stateStops.length) {
                if (elapsed >= stateStops[this.currentState]) {
                    this.startTime = currentTime;
                    this.stateProgress = 0.0f;
                    elapsed = 0L;
                    ++this.currentState;
                } else {
                    this.stateProgress = (float)elapsed / (float)stateStops[this.currentState];
                }
            }
            if (this.currentState < 6) {
                long zippyElapsed;
                this.spinnerProgress = (float)(totalElapsed % 2000L) / 2000.0f;
                if (this.zippyStartTime == 0L) {
                    this.zippyStartTime = currentTime;
                }
                if ((zippyElapsed = currentTime - this.zippyStartTime) > 300L) {
                    this.zippyProgress = this.loadingProgress;
                } else {
                    float fraction = (float)zippyElapsed / 300.0f;
                    fraction = AWTAnimationPanel2.convertToNonLinear(fraction, 0.5f, 0.1f);
                    this.zippyProgress = this.zippyStartProgress + (this.loadingProgress - this.zippyStartProgress) * fraction;
                }
                if (!this.fadeAway || !(this.zippyProgress >= 1.0f)) continue;
                this.fadeAway = false;
                this.zippyProgress = 1.0f;
                this.loadingProgress = 1.0f;
                this.startTime = currentTime;
                ++this.currentState;
                continue;
            }
            AWTAnimationPanel2 aWTAnimationPanel22 = this;
            synchronized (aWTAnimationPanel22) {
                this.animationThreadRunning = false;
            }
        }
    }
}

