/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.ui.ApplicationIconGenerator;
import com.sun.javaws.ui.SplashScreen;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public class CacheUtil {
    public static void fixShortcut() {
        ArrayList al = Cache.getJnlpCacheEntries((boolean)Environment.isSystemCacheMode());
        for (File jnlpFile : al) {
            LaunchDesc ld = null;
            try {
                ld = LaunchDescFactory.buildDescriptor(jnlpFile, null, null, null);
            }
            catch (Exception e) {
                Trace.println((String)"Cached jnlp file has no codebase", (TraceLevel)TraceLevel.CACHE);
                try {
                    ld = LaunchDescFactory.buildDescriptor(jnlpFile);
                }
                catch (Exception innerExceptione) {
                    Trace.ignoredException((Exception)e);
                }
            }
            if (ld == null) continue;
            CacheEntry ce = null;
            File idxFile = new File(jnlpFile.getPath() + ".idx");
            ce = idxFile.exists() ? Cache.getCacheEntryFromFile((File)idxFile) : Cache.getCacheEntry((URL)ld.getCanonicalHome(), null);
            if (ce == null) continue;
            LocalApplicationProperties lap = Cache.getLocalApplicationProperties((CacheEntry)ce);
            InformationDesc id = ld.getInformation();
            LocalInstallHandler lih = LocalInstallHandler.getInstance();
            if (lih != null) {
                lih.updateShortcutToLatestJRE(ld, lap);
                continue;
            }
            return;
        }
    }

    public static void remove(boolean includeInstalled) {
        ArrayList al = Cache.getJnlpCacheEntries((boolean)Environment.isSystemCacheMode());
        ArrayList<Object> excludeList = includeInstalled ? new ArrayList() : CacheUtil.getExcludedCacheEntries(al.iterator());
        for (File jnlpFile : al) {
            LaunchDesc ld = null;
            try {
                ld = LaunchDescFactory.buildDescriptor(jnlpFile, null, null, null);
            }
            catch (Exception e) {
                Trace.println((String)"Cached jnlp file has no codebase", (TraceLevel)TraceLevel.CACHE);
                try {
                    ld = LaunchDescFactory.buildDescriptor(jnlpFile);
                }
                catch (Exception innerExceptione) {
                    Trace.ignoredException((Exception)e);
                }
            }
            if (ld == null) continue;
            CacheUtil.remove(jnlpFile, ld, excludeList);
        }
        if (Globals.isShortcutMode()) {
            return;
        }
        File[] files = Cache.getCacheEntries((boolean)Environment.isSystemCacheMode());
        for (int i = 0; i < files.length; ++i) {
            CacheEntry ce = Cache.getCacheEntryFromFile((File)files[i]);
            if (ce != null) {
                if (excludeList.contains(ce.getIndexFile())) continue;
                Cache.removeCacheEntry((CacheEntry)ce);
                continue;
            }
            files[i].delete();
        }
        if (includeInstalled) {
            try {
                Cache.removeAllMuffins();
                Cache.removeAllLapFiles();
                CacheUtil.deleteRecursive(new File(Cache.getExtensionInstallDir()));
                new File(Config.getSplashIndex()).delete();
            }
            catch (Exception e) {
                Trace.ignored((Throwable)e);
            }
        }
    }

    public static ArrayList<File> getInstalledResources(boolean system) {
        return CacheUtil.getExcludedCacheEntries(Cache.getJnlpCacheEntries((boolean)system).iterator());
    }

    public static ArrayList<File> getExcludedCacheEntries(Iterator<File> it) {
        ArrayList<File> installed = new ArrayList<File>(){

            @Override
            public boolean add(File o) {
                if (!this.contains(o)) {
                    super.add(o);
                }
                return true;
            }
        };
        while (it.hasNext()) {
            LocalApplicationProperties lap;
            File jnlpFile = it.next();
            File idxFile = new File(jnlpFile.getPath() + ".idx");
            LaunchDesc ld = null;
            if (!idxFile.exists()) continue;
            try {
                ld = LaunchDescFactory.buildDescriptor(jnlpFile, null, null, null);
            }
            catch (BadFieldException bfe) {
                try {
                    CacheEntry ce = Cache.getCacheEntryFromFile((File)idxFile);
                    ld = LaunchDescFactory.buildDescriptor(ce.getDataFile(), URLUtil.getBase((URL)new URL(ce.getURL())), null, new URL(ce.getURL()));
                }
                catch (Exception ee) {
                    Trace.ignoredException((Exception)ee);
                }
            }
            catch (Exception e) {
                Trace.ignoredException((Exception)e);
            }
            CacheEntry ce = Cache.getCacheEntryFromFile((File)idxFile);
            if (ld == null || ce == null || (lap = Cache.getLocalApplicationProperties((CacheEntry)ce)) == null || !lap.isJnlpInstalled()) continue;
            CacheUtil.markResourcesInstalled(idxFile, ld, ce, installed);
        }
        return installed;
    }

    private static void markResourcesInstalled(File idxFile, LaunchDesc ld, CacheEntry ce, ArrayList<File> installed) {
        InformationDesc id;
        installed.add(idxFile);
        ResourcesDesc cbd = ld.getResources();
        if (cbd != null) {
            ExtensionDesc[] eds;
            JARDesc[] cps = cbd.getLocalJarDescs();
            if (cps != null) {
                for (int counter = cps.length - 1; counter >= 0; --counter) {
                    String version;
                    URL location = cps[counter].getLocation();
                    CacheEntry rce = Cache.getCacheEntry((URL)location, (String)(version = cps[counter].getVersion()));
                    if (rce == null) continue;
                    installed.add(rce.getIndexFile());
                }
            }
            if ((eds = cbd.getExtensionDescs()) != null) {
                for (int counter = eds.length - 1; counter >= 0; --counter) {
                    ExtensionDesc ed = eds[counter];
                    CacheEntry ece = Cache.getCacheEntry((URL)ed.getLocation(), (String)ed.getVersion());
                    if (ece == null) continue;
                    try {
                        LaunchDesc eld = LaunchDescFactory.buildDescriptor(ece.getDataFile(), null, null, null);
                        if (eld == null) continue;
                        CacheUtil.markResourcesInstalled(ece.getIndexFile(), eld, ece, installed);
                        continue;
                    }
                    catch (Exception e) {
                        Trace.ignored((Throwable)e);
                    }
                }
            }
        }
        if ((id = ld.getInformation()) != null) {
            RContentDesc[] rc;
            CacheEntry ice;
            IconDesc[] icons = id.getIcons();
            if (icons != null) {
                for (IconDesc icon : icons) {
                    String version;
                    URL url = icon.getLocation();
                    if (url == null || (ice = Cache.getCacheEntry((URL)url, (String)(version = icon.getVersion()))) == null) continue;
                    installed.add(ice.getIndexFile());
                }
            }
            if ((rc = id.getRelatedContent()) != null) {
                for (RContentDesc rc1 : rc) {
                    URL url = rc1.getIcon();
                    if (url == null || (ice = Cache.getCacheEntry((URL)url, null)) == null) continue;
                    installed.add(ice.getIndexFile());
                }
            }
        }
    }

    public static void remove(CacheEntry ce) {
        try {
            LaunchDesc ld = LaunchDescFactory.buildDescriptor(ce.getDataFile(), null, null, null);
            CacheUtil.remove(ce, ld);
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
        }
    }

    public static void remove(File jnlpFile, LaunchDesc ld, ArrayList<File> excludeList) {
        File idxFile = new File(jnlpFile.getPath() + ".idx");
        if (idxFile.exists()) {
            CacheEntry ce = Cache.getCacheEntryFromFile((File)idxFile);
            if (ce != null) {
                if (!excludeList.contains(idxFile)) {
                    CacheUtil.remove(ce, ld);
                }
            } else {
                idxFile.delete();
                jnlpFile.delete();
            }
        } else if (jnlpFile.exists() && ResourceProvider.get().getCacheDir().equals(jnlpFile.getParentFile())) {
            jnlpFile.delete();
        } else {
            CacheEntry ce = Cache.getCacheEntry((URL)ld.getCanonicalHome(), null);
            if (ce != null && !excludeList.contains(ce.getIndexFile())) {
                CacheUtil.remove(ce, ld);
            }
        }
    }

    public static void remove(CacheEntry ce, LaunchDesc ld) {
        ResourcesDesc cbd;
        LocalApplicationProperties lap = Cache.getLocalApplicationProperties((CacheEntry)ce);
        InformationDesc id = ld.getInformation();
        LocalInstallHandler lih = LocalInstallHandler.getInstance();
        if (lih != null && ld.isApplicationDescriptor()) {
            lih.uninstall(ld, lap, true);
        }
        if (Globals.isShortcutMode()) {
            return;
        }
        if (ld.isApplicationDescriptor() && ld.getLocation() != null) {
            Cache.saveRemovedApp((URL)ld.getLocation(), (String)id.getTitle());
        }
        lap.refresh();
        if (lap.isExtensionInstalled() && ld.isInstaller()) {
            ArrayList<File> list = new ArrayList<File>();
            list.add(ce.getDataFile());
            try {
                String path = lap.getInstallDirectory();
                JnlpxArgs.executeUninstallers(list);
                JREInfo.removeJREsIn((String)path);
                CacheUtil.deleteRecursive(new File(path));
            }
            catch (Exception e) {
                Trace.ignoredException((Exception)e);
            }
        }
        SplashScreen.removeCustomSplash(ld);
        ApplicationIconGenerator.removeCustomIcon(ld);
        if (id != null) {
            RContentDesc[] rc;
            IconDesc[] icons = id.getIcons();
            if (icons != null) {
                for (IconDesc icon : icons) {
                    URL url = icon.getLocation();
                    String version = icon.getVersion();
                    CacheUtil.removeEntries(url, version);
                }
            }
            if ((rc = id.getRelatedContent()) != null) {
                for (RContentDesc rc1 : rc) {
                    URL url = rc1.getIcon();
                    if (url == null) continue;
                    CacheUtil.removeEntries(url, null);
                }
            }
        }
        if ((cbd = ld.getResources()) != null) {
            ExtensionDesc[] eds;
            JARDesc[] cps = cbd.getLocalJarDescs();
            if (cps != null) {
                for (int counter = cps.length - 1; counter >= 0; --counter) {
                    URL location = cps[counter].getLocation();
                    String version = cps[counter].getVersion();
                    CacheUtil.removeEntries(location, version);
                }
            }
            if ((eds = cbd.getExtensionDescs()) != null) {
                for (int counter = eds.length - 1; counter >= 0; --counter) {
                    ExtensionDesc ed = eds[counter];
                    CacheEntry insCe = Cache.getCacheEntry((URL)ed.getLocation(), (String)ed.getVersion());
                    if (insCe == null) continue;
                    try {
                        LaunchDesc eld = LaunchDescFactory.buildDescriptor(insCe.getDataFile(), null, null, null);
                        if (eld == null || !eld.isInstaller()) continue;
                        CacheUtil.remove(insCe, eld);
                        continue;
                    }
                    catch (Exception e) {
                        Trace.ignored((Throwable)e);
                    }
                }
            }
        }
        String urlString = ce.getURL();
        String version = ce.getVersion();
        try {
            URL location = new URL(urlString);
            if (location != null) {
                CacheUtil.removeEntries(location, version);
            }
        }
        catch (MalformedURLException mue) {
            Trace.ignored((Throwable)mue);
        }
        Cache.removeLoadedProperties((String)urlString);
    }

    private static void removeEntries(URL location, String version) {
        if (location != null) {
            CacheEntry ce = Cache.getCacheEntry((URL)location, (String)version);
            Cache.removeAllCacheEntries((CacheEntry)ce);
        }
    }

    static File getCachedFileNative(URL url) {
        if (url.getProtocol().equals("jar")) {
            String path = url.getPath();
            int bang = path.indexOf("!/");
            if (bang > 0) {
                try {
                    String entry = path.substring(bang + 2);
                    URL lib = new URL(path.substring(0, bang));
                    String dir = ResourceProvider.get().getLibraryDirForJar(entry, lib, null);
                    if (dir != null) {
                        return new File(dir, entry);
                    }
                }
                catch (MalformedURLException mue) {
                    Trace.ignored((Throwable)mue);
                }
                catch (IOException ioe) {
                    Trace.ignored((Throwable)ioe);
                }
            }
            return null;
        }
        Resource r = ResourceProvider.get().getCachedResource(url, null);
        return r != null ? r.getDataFile() : null;
    }

    private static void deleteRecursive(File f) {
        if (f.isDirectory()) {
            File[] children;
            for (File child : children = f.listFiles()) {
                CacheUtil.deleteRecursive(child);
            }
        }
        f.delete();
    }
}

