/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppUtility;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Platform;
import com.sun.deploy.config.WinPlatform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.WinRegistry;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.IconUtil;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;

public class WinInstallHandler
extends LocalInstallHandler {
    private static final String INSTALLED_DESKTOP_SHORTCUT_KEY = "installed.desktop";
    private static final String INSTALLED_START_MENU_KEY = "installed.menu";
    private static final String UNINSTALLED_START_MENU_KEY = "installed.uninstalled";
    private static final String RCONTENT_START_MENU_KEY = "installed.rc";
    public static final int TYPE_DESKTOP = 1;
    public static final int TYPE_START_MENU = 2;
    private static final String REG_SHORTCUT_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    private static final String REG_DESKTOP_PATH_KEY = "Desktop";
    private static final String REG_START_MENU_PATH_KEY = "Programs";
    private static final int MAX_PATH = 260;
    private static final String SHORTCUT_EXTENSION = ".lnk";
    private static final int MAX_SHORTCUT = 260 - (".lnk".length() + 1);
    private boolean _loadedPaths = false;
    private String _desktopPath;
    private String _startMenuPath;
    private final String nameBadChars = "\"\\/|:?*<>";
    private final String dirBadChars = "\"|:?*<>";
    private static final char[] WHITESPACE_PAD;
    private static final String ELLIPSIS = "...";
    private static final int MAX_INSTALL_DESCRIPTION_LENGTH = 80;

    @Override
    public boolean isShortcutExists(LocalApplicationProperties lap) {
        String desktopPath = lap.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        String menuPath = lap.get(INSTALLED_START_MENU_KEY);
        boolean desktopExists = false;
        boolean menuExists = false;
        if (desktopPath != null) {
            desktopExists = new File(desktopPath).exists();
        }
        if (menuPath != null) {
            menuExists = new File(menuPath).exists();
        }
        if (desktopPath != null && menuPath != null) {
            return desktopExists && menuExists;
        }
        return desktopExists || menuExists;
    }

    @Override
    public boolean[] whichShortcutsExist(LocalApplicationProperties lap) {
        boolean[] which = new boolean[2];
        String desktopPath = lap.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        which[0] = desktopPath != null && new File(desktopPath).exists();
        String menuPath = lap.get(INSTALLED_START_MENU_KEY);
        which[1] = menuPath != null && new File(menuPath).exists();
        return which;
    }

    @Override
    public String getDefaultIconPath() {
        return Platform.get().getSystemJavawsPath();
    }

    @Override
    public String getAssociationOpenCommand(String jnlpLocation) {
        return "\"" + Platform.get().getSystemJavawsPath() + "\" \"-localfile\" \"-open\" \"%1\" \"" + jnlpLocation + "\"";
    }

    @Override
    public String getAssociationPrintCommand(String jnlpLocation) {
        return "\"" + Platform.get().getSystemJavawsPath() + "\" \"-localfile\" \"-print\" \"%1\" \"" + jnlpLocation + "\"";
    }

    @Override
    public void registerAssociationInternal(LaunchDesc ld, LocalApplicationProperties lap, Association assoc) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        AssociationService assocService = new AssociationService(lap);
        if (Environment.isSystemCacheMode()) {
            assocService.registerSystemAssociation(assoc);
        } else {
            assocService.registerUserAssociation(assoc);
        }
    }

    @Override
    public void unregisterAssociationInternal(LaunchDesc ld, LocalApplicationProperties lap, Association assoc) throws AssociationNotRegisteredException, RegisterFailedException {
        AssociationService assocService = new AssociationService(lap);
        if (Environment.isSystemCacheMode()) {
            assocService.unregisterSystemAssociation(assoc);
        } else {
            assocService.unregisterUserAssociation(assoc);
        }
    }

    @Override
    public boolean hasAssociation(LaunchDesc ld, LocalApplicationProperties lap, Association assoc) {
        AssociationService assocService = new AssociationService(lap);
        return assocService.hasAssociation(assoc);
    }

    @Override
    public boolean isLocalInstallSupported() {
        return true;
    }

    @Override
    public boolean isAssociationSupported() {
        return true;
    }

    @Override
    protected boolean isAssociationFileExtSupported(String extension) {
        if (extension == null) {
            return false;
        }
        String ext = AppUtility.removeDotFromFileExtension((String)extension.toLowerCase());
        return !ext.equals("exe") && !ext.equals("com") && !ext.equals("bat");
    }

    @Override
    public boolean removePathShortcut(String path) {
        File f = new File(path);
        if (f.exists()) {
            return f.delete();
        }
        return false;
    }

    @Override
    public boolean updateShortcutToLatestJRE(LaunchDesc ld, LocalApplicationProperties lap) {
        if (!(Platform.get() instanceof WinPlatform)) {
            return false;
        }
        WinPlatform winPlatform = (WinPlatform)Platform.get();
        String target = winPlatform.getSystemJavawsPath();
        if (target == null) {
            return false;
        }
        String path = lap.get(INSTALLED_START_MENU_KEY);
        if (path != null) {
            winPlatform.updateShortcut(path, target);
        }
        if ((path = lap.get(INSTALLED_DESKTOP_SHORTCUT_KEY)) != null) {
            winPlatform.updateShortcut(path, target);
        }
        if (lap.isJnlpInstalled()) {
            this.removeFromInstallPanel(ld, lap, false);
            this.registerWithInstallPanel(ld, lap);
        }
        return true;
    }

    private void deleteClonedShortcutIcon(LaunchDesc ld, boolean isDesktop) {
        String iconPath = this.getIconPath(ld, isDesktop);
        File icoFileToDelete = new File(this.getNewIconFilePath(iconPath) + File.separator + this.getIconFileName(iconPath));
        Cache.ensureFileDeleted((File)icoFileToDelete);
    }

    @Override
    protected boolean removeShortcuts(LaunchDesc ld, LocalApplicationProperties lap, boolean desktop) {
        String paths;
        String path;
        if (lap == null) {
            Trace.println((String)"No LAP for uninstall, bailing!", (TraceLevel)TraceLevel.TEMP);
            return false;
        }
        String toEmpty = null;
        boolean failed = false;
        WinPlatform winPlatform = null;
        if (Platform.get() instanceof WinPlatform) {
            winPlatform = (WinPlatform)Platform.get();
        }
        if ((path = lap.get(INSTALLED_START_MENU_KEY)) != null) {
            if (!this.deleteShortcut(path)) {
                failed = true;
            } else {
                lap.put(INSTALLED_START_MENU_KEY, null);
            }
            toEmpty = path;
            if (winPlatform != null && winPlatform.isPlatformWindows8orLater()) {
                this.deleteClonedShortcutIcon(ld, false);
            }
        }
        if ((path = lap.get(UNINSTALLED_START_MENU_KEY)) != null) {
            if (!this.deleteShortcut(path)) {
                failed = true;
            } else {
                lap.put(UNINSTALLED_START_MENU_KEY, null);
            }
            toEmpty = path;
        }
        if ((paths = lap.get(RCONTENT_START_MENU_KEY)) != null) {
            StringTokenizer st = new StringTokenizer(paths, File.pathSeparator);
            while (st.hasMoreElements()) {
                path = st.nextToken();
                if (path == null) continue;
                if (!this.deleteShortcut(path)) {
                    failed = true;
                }
                toEmpty = path;
            }
            lap.put(RCONTENT_START_MENU_KEY, null);
        }
        if (toEmpty != null) {
            this.checkEmpty(toEmpty);
        }
        if (desktop) {
            path = lap.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
            if (path != null) {
                if (!this.deleteShortcut(path)) {
                    failed = true;
                } else {
                    lap.put(INSTALLED_DESKTOP_SHORTCUT_KEY, null);
                }
            }
            if (winPlatform != null && winPlatform.isPlatformWindows8orLater()) {
                this.deleteClonedShortcutIcon(ld, true);
            }
        }
        if (failed) {
            Trace.println((String)"uninstall shortcut failed", (TraceLevel)TraceLevel.TEMP);
        }
        lap.setShortcutInstalled(false);
        WinInstallHandler.save(lap);
        return !failed;
    }

    private void checkEmpty(String path) {
        try {
            for (File parent = new File(path).getParentFile(); parent != null && parent.isDirectory() && parent.list().length == 0; parent = parent.getParentFile()) {
                parent.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean hasValidTitle(LaunchDesc desc) {
        if (desc == null) {
            return false;
        }
        InformationDesc iDesc = desc.getInformation();
        if (iDesc == null || this.nameFilter(iDesc.getTitle()) == null) {
            Trace.println((String)"Invalid: No title!", (TraceLevel)TraceLevel.TEMP);
            return false;
        }
        return true;
    }

    @Override
    protected boolean createShortcuts(LaunchDesc desc, LocalApplicationProperties lap, boolean[] which) {
        boolean doMenu;
        if (!this.hasValidTitle(desc)) {
            return false;
        }
        if (this.isShortcutExists(lap) && !WinInstallHandler.shouldInstallOverExisting(desc)) {
            return false;
        }
        String cachedJNLP = null;
        File cachedFile = ResourceProvider.get().getCachedJNLPFile(desc.getCanonicalHome(), null);
        if (cachedFile != null) {
            cachedJNLP = cachedFile.getPath();
        }
        if (cachedJNLP == null) {
            this.installFailed(desc);
            return false;
        }
        ShortcutDesc sd = desc.getInformation().getShortcut();
        boolean doDesktop = sd == null ? true : sd.getDesktop();
        boolean bl = doMenu = sd == null ? true : sd.getMenu();
        if (which != null) {
            doDesktop = doDesktop && which[0];
            boolean bl2 = doMenu = doMenu && which[1];
        }
        if (doDesktop && !this.handleInstall(desc, sd, lap, cachedJNLP, 1)) {
            this.installFailed(desc);
            return false;
        }
        if (doMenu && !this.handleInstall(desc, sd, lap, cachedJNLP, 2)) {
            this.removeShortcuts(desc, lap, doDesktop);
            this.installFailed(desc);
            return false;
        }
        if (doMenu || doDesktop) {
            lap.setShortcutInstalled(true);
            WinInstallHandler.save(lap);
        }
        return true;
    }

    @Override
    protected void registerWithInstallPanel(LaunchDesc ld, LocalApplicationProperties lap) {
        InformationDesc id = ld.getInformation();
        String jnlpURL = Platform.get().toExecArg(ld.getCanonicalHome().toString());
        String title = this.nameFilter(id.getTitle());
        if (jnlpURL != null && jnlpURL.length() != 0 && title != null && title.length() != 0) {
            String iconPath = this.getIconPath(ld, false);
            String vendor = id.getVendor();
            String description = this.getBestFitDescription(id);
            URL homeURL = id.getHome();
            String homepage = null;
            boolean sysCache = Environment.isSystemCacheMode();
            if (homeURL != null) {
                homepage = id.getHome().toExternalForm();
            }
            if (vendor == null) {
                vendor = homepage;
            }
            if (vendor == null && description.trim().length() == 0) {
                vendor = null;
                description = null;
                homepage = null;
            }
            lap.setRegisteredTitle(title);
            Platform.get().addRemoveProgramsAdd(jnlpURL, title, iconPath, vendor, description, homepage, sysCache);
        }
    }

    @Override
    protected void removeFromInstallPanel(LaunchDesc ld, LocalApplicationProperties lap, boolean force) {
        boolean sysCache = Environment.isSystemCacheMode();
        String title = lap.getRegisteredTitle();
        if (force && title == null) {
            title = this.nameFilter(ld.getInformation().getTitle());
        }
        if (title != null && title.length() != 0) {
            Platform.get().addRemoveProgramsRemove(title, sysCache);
        }
    }

    private String getBestFitDescription(InformationDesc id) {
        String result = id.getDescription(2);
        if (result == null && (result = id.getDescription(0)) == null && (result = id.getDescription(1)) == null) {
            result = id.getDescription(3);
        }
        if (result != null) {
            int length = result.length();
            if (length < WHITESPACE_PAD.length) {
                result = new StringBuffer(result).append(WHITESPACE_PAD, 0, WHITESPACE_PAD.length - length).toString();
            } else if (length > 80) {
                int eLen = ELLIPSIS.length();
                result = new StringBuffer(result).delete(80 - eLen, length).append(ELLIPSIS).toString();
            }
        } else {
            result = new String(WHITESPACE_PAD);
        }
        return result;
    }

    private void installFailed(final LaunchDesc desc) {
        Runnable jOptionPaneRunnable = new Runnable(){

            @Override
            public void run() {
                String okBtn = ResourceManager.getString((String)"common.ok_btn");
                String detailBtn = ResourceManager.getString((String)"common.detail.button");
                ToolkitStore.getUI().showMessageDialog(null, null, 0, ResourceManager.getString((String)"install.installFailedTitle"), ResourceManager.getString((String)"install.installFailed", (Object[])new Object[]{WinInstallHandler.this.getInstallName(desc)}), null, null, okBtn, detailBtn, null);
            }
        };
        WinInstallHandler.invokeRunnable(jOptionPaneRunnable);
    }

    private void uninstallFailed(final LaunchDesc desc) {
        Runnable jOptionPaneRunnable = new Runnable(){

            @Override
            public void run() {
                String okBtn = ResourceManager.getString((String)"common.ok_btn");
                String detailBtn = ResourceManager.getString((String)"common.detail.button");
                ToolkitStore.getUI().showMessageDialog(null, null, 0, ResourceManager.getString((String)"install.uninstallFailedTitle"), ResourceManager.getString((String)"install.uninstallFailed", (Object[])new Object[]{WinInstallHandler.this.getInstallName(desc)}), null, null, okBtn, detailBtn, null);
            }
        };
        WinInstallHandler.invokeRunnable(jOptionPaneRunnable);
    }

    private String getIconFileName(String iconPath) {
        return iconPath.substring(iconPath.lastIndexOf(File.separator) + 1);
    }

    private String getNewIconFilePath(String iconPath) {
        int endIdx = iconPath.lastIndexOf(File.separator);
        if (endIdx < 0) {
            return iconPath;
        }
        if (!(Platform.get() instanceof WinPlatform)) {
            return iconPath;
        }
        WinPlatform winPlatform = (WinPlatform)Platform.get();
        String userPath = winPlatform.getPlatformUserHome().toLowerCase();
        if (iconPath.toLowerCase().contains(userPath)) {
            int startIdx = userPath.length();
            String localDirPath = winPlatform.getPlatformUserLocalDir();
            return localDirPath != null ? localDirPath + iconPath.substring(startIdx, endIdx) : iconPath;
        }
        return iconPath;
    }

    private String copyIconFileForWindows8(String iconPath) {
        if (!(Platform.get() instanceof WinPlatform)) {
            return iconPath;
        }
        Object newIconPath = iconPath;
        WinPlatform winPlatform = (WinPlatform)Platform.get();
        String userPath = winPlatform.getPlatformUserHome().toLowerCase();
        if (iconPath.toLowerCase().contains(userPath)) {
            newIconPath = this.getNewIconFilePath(iconPath);
            String iconFileName = this.getIconFileName(iconPath);
            try {
                File newIconDir = new File((String)newIconPath);
                newIconDir.mkdirs();
                Cache.copyFile((File)new File(iconPath), (File)new File(newIconDir, iconFileName));
                newIconPath = (String)newIconPath + File.separator + iconFileName;
            }
            catch (IOException ioe) {
                return iconPath;
            }
        }
        return newIconPath;
    }

    private boolean handleInstall(LaunchDesc ld, ShortcutDesc sd, LocalApplicationProperties lap, String cachedJNLP, int type) {
        InformationDesc id = ld.getInformation();
        String name = null;
        String iconPath = this.getIconPath(ld, true);
        String menuIconPath = this.getIconPath(ld, false);
        String startCommand = Platform.get().getSystemJavawsPath();
        String default_desc = id.getDescription(0);
        String tooltip_desc = id.getDescription(3);
        String description = tooltip_desc == null ? default_desc : tooltip_desc;
        boolean result = true;
        String home = ld.getLocation() != null ? ld.getLocation().toString() : null;
        String homeString = home == null || home.endsWith(".jarjnlp") ? "" : "-J-Djnlp.application.href=" + home + " ";
        boolean online = !id.supportsOfflineOperation() || sd == null || sd.getOnline();
        String onlineString = online ? "" : "-offline ";
        Object launchArgs = "-localfile " + onlineString + homeString + "\"" + cachedJNLP + "\"";
        if (((String)launchArgs).length() >= 255) {
            launchArgs = "-localfile " + onlineString + "\"" + cachedJNLP + "\"";
        }
        WinPlatform winPlatform = null;
        if (Platform.get() instanceof WinPlatform) {
            winPlatform = (WinPlatform)Platform.get();
        }
        if (type == 1) {
            int ret;
            String path = this.getDesktopPath(ld);
            name = this.getInstallName(ld);
            if (winPlatform != null && winPlatform.isPlatformWindows8orLater()) {
                iconPath = this.copyIconFileForWindows8(iconPath);
            }
            if ((ret = this.installWrapper(path, name, description, startCommand, (String)launchArgs, null, iconPath)) == 0) {
                lap.put(INSTALLED_DESKTOP_SHORTCUT_KEY, path);
                Trace.println((String)("Installed desktop shortcut for: " + name + "."), (TraceLevel)TraceLevel.TEMP);
            } else {
                result = false;
                Trace.println((String)("Installed desktop shortcut for: " + name + " failed (" + ret + ")!!!"), (TraceLevel)TraceLevel.TEMP);
            }
        } else {
            File startMenuDir = new File(this.getSubMenuPath(ld));
            if (startMenuDir.exists() || startMenuDir.mkdirs()) {
                int ret;
                String path = this.getStartMenuPath(ld);
                name = this.getInstallName(ld);
                if (winPlatform != null && winPlatform.isPlatformWindows8orLater()) {
                    menuIconPath = this.copyIconFileForWindows8(menuIconPath);
                }
                if ((ret = this.installWrapper(path, name, description, startCommand, (String)launchArgs, null, menuIconPath)) == 0) {
                    lap.put(INSTALLED_START_MENU_KEY, path);
                    Trace.println((String)("Installed menu shortcut for: " + name + "."), (TraceLevel)TraceLevel.TEMP);
                } else {
                    result = false;
                    Trace.println((String)("Installed menu shortcut for: " + name + " failed (" + ret + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                }
                String submenu = this.getSubMenuDir(ld);
                if ((submenu == null || !submenu.equals("Startup")) && this.addUninstallShortcut()) {
                    launchArgs = "-uninstall \"" + cachedJNLP + "\"";
                    path = this.getUninstallPath(ld);
                    ret = this.installWrapper(path, name = this.getUninstallMenuName(ld), description, startCommand, (String)launchArgs, null, menuIconPath);
                    if (ret == 0) {
                        lap.put(UNINSTALLED_START_MENU_KEY, path);
                        Trace.println((String)("Installed menu shortcut for: " + name + "."), (TraceLevel)TraceLevel.TEMP);
                    } else {
                        result = false;
                        Trace.println((String)("Installed menu shortcut for: " + name + " failed (" + ret + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                    }
                }
                RContentDesc[] rc = id.getRelatedContent();
                StringBuilder rcValue = new StringBuilder();
                if (rc != null) {
                    for (RContentDesc rcDesc : rc) {
                        name = this.nameFilter(rcDesc.getTitle());
                        URL url = rcDesc.getHref();
                        if (url.toString().endsWith("jnlp")) continue;
                        description = rcDesc.getDescription();
                        URL iconUrl = rcDesc.getIcon();
                        String rciconPath = null;
                        if (iconUrl != null) {
                            rciconPath = IconUtil.getIconPath(iconUrl, null);
                        }
                        if (rciconPath == null) {
                            rciconPath = iconPath;
                        }
                        path = this.getRCPath(ld, name);
                        File f = CacheUtil.getCachedFileNative(url);
                        startCommand = Platform.get().getBrowserPath();
                        if (f != null) {
                            launchArgs = "\"file:" + f.getAbsolutePath() + "\"";
                            ret = this.installWrapper(path, name, description, startCommand, (String)launchArgs, null, rciconPath);
                            if (ret == 0) {
                                rcValue.append(path);
                                rcValue.append(File.pathSeparator);
                                Trace.println((String)("Installed menu shortcut for: " + name + "."), (TraceLevel)TraceLevel.TEMP);
                                continue;
                            }
                            result = false;
                            Trace.println((String)("Installed menu shortcut for: " + name + " failed (" + ret + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                            continue;
                        }
                        launchArgs = url.toString();
                        ret = this.installWrapper(path, name, description, startCommand, (String)launchArgs, null, rciconPath);
                        if (ret == 0) {
                            rcValue.append(path);
                            rcValue.append(File.pathSeparator);
                            Trace.println((String)("Installed menu shortcut for: " + name + "."), (TraceLevel)TraceLevel.TEMP);
                            continue;
                        }
                        result = false;
                        Trace.println((String)("Installed menu shortcut for: " + name + " failed (" + ret + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                    }
                }
                if (rcValue.length() > 0) {
                    lap.put(RCONTENT_START_MENU_KEY, rcValue.toString());
                } else {
                    lap.put(RCONTENT_START_MENU_KEY, null);
                }
            } else {
                result = false;
                Trace.println((String)("Installed menu shortcut for: " + name + " failed (can't create directory \"" + startMenuDir.getAbsolutePath() + "\")!!!"), (TraceLevel)TraceLevel.TEMP);
            }
        }
        return result;
    }

    private String getInstallName(LaunchDesc ld) {
        return this.nameFilter(ld.getInformation().getTitle());
    }

    private String getUninstallMenuName(LaunchDesc ld) {
        String name = ResourceManager.getString((String)"install.startMenuUninstallShortcutName", (Object[])new Object[]{this.getInstallName(ld)});
        return name;
    }

    private String getDesktopPath(LaunchDesc ld) {
        return this.getShortcutPath(this.getDesktopPath(), this.getInstallName(ld));
    }

    private String getStartMenuPath(LaunchDesc ld) {
        return this.getShortcutPath(this.getSubMenuPath(ld), this.getInstallName(ld));
    }

    private String getRCPath(LaunchDesc ld, String title) {
        return this.getShortcutPath(this.getSubMenuPath(ld), title);
    }

    private String getUninstallPath(LaunchDesc ld) {
        return this.getShortcutPath(this.getSubMenuPath(ld), this.getUninstallMenuName(ld));
    }

    private String getSubMenuPath(LaunchDesc ld) {
        String dir;
        Object path = this.getStartMenuPath();
        if (path != null && (dir = this.getSubMenuDir(ld)) != null) {
            path = (String)path + dir + File.separator;
        }
        return path;
    }

    private String getSubMenuDir(LaunchDesc ld) {
        String submenu;
        String dir = this.getInstallName(ld);
        ShortcutDesc sd = ld.getInformation().getShortcut();
        if (sd != null && (submenu = sd.getSubmenu()) != null) {
            dir = this.dirFilter(submenu);
        }
        if (dir != null && dir.equalsIgnoreCase("startup")) {
            dir = "Startup";
        }
        return dir;
    }

    private String getDesktopPath() {
        this.loadPathsIfNecessary();
        return this._desktopPath;
    }

    private String getStartMenuPath() {
        this.loadPathsIfNecessary();
        return this._startMenuPath;
    }

    private void loadPathsIfNecessary() {
        int regKey = -2147483647;
        String prefix = "";
        if (Environment.isSystemCacheMode()) {
            regKey = -2147483646;
            prefix = "Common ";
        }
        if (!this._loadedPaths) {
            this._desktopPath = WinRegistry.getString((int)regKey, (String)REG_SHORTCUT_PATH, (String)(prefix + REG_DESKTOP_PATH_KEY));
            if (this._desktopPath != null && this._desktopPath.length() > 0 && this._desktopPath.charAt(this._desktopPath.length() - 1) != '\\') {
                this._desktopPath = this._desktopPath + "\\";
            }
            this._startMenuPath = WinRegistry.getString((int)regKey, (String)REG_SHORTCUT_PATH, (String)(prefix + REG_START_MENU_PATH_KEY));
            if (this._startMenuPath != null && this._startMenuPath.length() > 0 && this._startMenuPath.charAt(this._startMenuPath.length() - 1) != '\\') {
                this._startMenuPath = this._startMenuPath + "\\";
            }
            this._loadedPaths = true;
            Trace.println((String)("Start path: " + this._startMenuPath + " desktop " + this._desktopPath), (TraceLevel)TraceLevel.TEMP);
        }
    }

    private String nameFilter(String name) {
        return this.Filter(name, "\"\\/|:?*<>", '-');
    }

    private String dirFilter(String name) {
        String dir = this.Filter(name, "\"|:?*<>", '-');
        return this.Filter(dir, "\\/", File.separatorChar);
    }

    private String Filter(String name, String badChars, char replacement) {
        if (name == null) {
            return null;
        }
        if (name.equalsIgnoreCase("nul")) {
            return "-nul-";
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        return this.checkTitleString(name, badChars, replacement);
    }

    private boolean deleteShortcut(String path) {
        File f = new File(path);
        if (f.exists()) {
            boolean retValue = f.delete();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                Trace.ignoredException((Exception)ie);
            }
            return retValue;
        }
        return true;
    }

    private String getIconPath(LaunchDesc ld, boolean forDesktop) {
        String appIcon;
        String result = this.getDefaultIconPath();
        if (ld != null && (appIcon = IconUtil.getIconPath(ld, forDesktop)) != null) {
            result = appIcon;
        }
        return result;
    }

    private String getShortcutPath(String location, String name) {
        String result = null;
        if (location != null && location.length() < MAX_SHORTCUT - 1 && name != null) {
            StringBuilder shortcutPath = new StringBuilder(324);
            shortcutPath.append(location).append(name);
            if (shortcutPath.length() > MAX_SHORTCUT) {
                shortcutPath.delete(MAX_SHORTCUT, shortcutPath.length());
            }
            shortcutPath.append(SHORTCUT_EXTENSION);
            result = shortcutPath.toString();
        }
        return result;
    }

    private int installWrapper(String path, String appName, String description, String appPath, String args, String directory, String iconPath) {
        Trace.println((String)"installshortcut with args:", (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    path: " + path), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    name: " + appName), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    desc: " + description), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    appP: " + appPath), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    args: " + args), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    dir : " + directory), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    icon: " + iconPath), (TraceLevel)TraceLevel.TEMP);
        Trace.flush();
        return Platform.get().installShortcut(path, appName, description, appPath, args, directory, iconPath);
    }

    static {
        String string = System.getProperty("os.name");
        WHITESPACE_PAD = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    }
}

