/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import java.util.ArrayList;

class Filter {
    String[] secureParams;
    String[] insecureParams;
    String[] secureArgs;
    String[] insecureArgs;

    public Filter(ArrayList<String> secureParamList, ArrayList<String> insecureParamList, ArrayList<String> secureArgList, ArrayList<String> insecureArgList) {
        this.secureParams = secureParamList == null ? null : secureParamList.toArray(new String[0]);
        this.insecureParams = insecureParamList == null ? null : insecureParamList.toArray(new String[0]);
        this.secureArgs = secureArgList == null ? null : secureArgList.toArray(new String[0]);
        this.insecureArgs = insecureArgList == null ? null : insecureArgList.toArray(new String[0]);
    }

    public boolean isFilteredParam(String name) {
        if (this.secureParams != null) {
            for (String s : this.insecureParams) {
                if (!this.matchParam(name, s)) continue;
                return false;
            }
            for (String s : this.secureParams) {
                if (!this.matchParam(name, s)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchParam(String name, String s) {
        if (s.equals(name)) {
            return true;
        }
        if (s.endsWith("*")) {
            if (s.equals("*")) {
                return true;
            }
            if (name.startsWith(s.substring(0, s.length() - 1))) {
                return true;
            }
        }
        return false;
    }

    public boolean isFilteredArg(int index) {
        if (this.secureArgs != null) {
            for (String s : this.insecureArgs) {
                if (!this.matchArg(index, s)) continue;
                return false;
            }
            for (String s : this.secureArgs) {
                if (!this.matchArg(index, s)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchArg(int index, String s) {
        if (s.equals("*")) {
            return true;
        }
        return String.valueOf(index).equals(s);
    }
}

