/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.Base64Wrapper;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.XMLFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.zip.GZIPInputStream;

public class LaunchDescFactory {
    private static final boolean DEBUG = false;
    private static final int BUFFER_SIZE = 8192;
    private static URL derivedCodebase = null;
    private static URL docbase = null;

    public static void setDocBase(URL u) {
        docbase = u;
    }

    public static URL getDocBase() {
        return docbase;
    }

    public static URL getDerivedCodebase() {
        if (docbase != null && derivedCodebase == null) {
            try {
                derivedCodebase = new URL(docbase.toString().substring(0, docbase.toString().lastIndexOf("/") + 1));
            }
            catch (MalformedURLException mue) {
                Trace.ignoredException((Exception)mue);
            }
        }
        return derivedCodebase;
    }

    public static LaunchDesc buildDescriptor(byte[] bits, URL codebase, URL documentbase, URL originalRequest) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return XMLFormat.parse(bits, codebase, documentbase, originalRequest);
    }

    public static LaunchDesc buildDescriptor(byte[] bits, URL codebase, URL documentbase) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return LaunchDescFactory.buildDescriptor(bits, codebase, documentbase, null);
    }

    public static LaunchDesc buildDescriptor(File f, URL codebase, URL documentbase, URL originalRequest) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        URL originalURL = originalRequest != null ? originalRequest : LaunchDescFactory.getOriginalURL();
        try {
            return LaunchDescFactory.buildDescriptor(SystemUtils.readBytes((InputStream)new FileInputStream(f), (long)f.length()), codebase, documentbase, originalURL);
        }
        catch (FileNotFoundException fnfe) {
            if (originalURL == null) {
                throw fnfe;
            }
            return LaunchDescFactory.buildDescriptor(originalURL, documentbase);
        }
    }

    private static LaunchDesc buildDescriptor(File f, LocalApplicationProperties lap, URL codebase, URL documentbase) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        String docbaseStr = lap.getDocumentBase();
        String codebaseStr = lap.getCodebase();
        String originalURLStr = lap.getOriginalURL();
        if (codebaseStr != null) {
            try {
                codebase = new URL(codebaseStr);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (docbaseStr != null) {
            try {
                documentbase = new URL(docbaseStr);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URL originalURL = null;
        if (originalURLStr != null) {
            try {
                originalURL = new URL(originalURLStr);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return LaunchDescFactory.buildDescriptor(f, codebase, documentbase, originalURL);
    }

    public static LaunchDesc buildDescriptor(File f) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        LocalApplicationProperties lap = null;
        if (Cache.isFileWithinCache((File)f)) {
            lap = Cache.getLocalApplicationProperties((String)f.getPath());
        }
        if (lap != null) {
            return LaunchDescFactory.buildDescriptor(f, lap, null, null);
        }
        String origFilename = LaunchDescFactory.getOriginalFilename();
        if (origFilename != null) {
            File origFile = new File(origFilename);
            URL codebase = null;
            try {
                String filepath = origFile.getAbsoluteFile().getParent();
                if (filepath.startsWith(File.separator)) {
                    filepath = filepath.substring(1, filepath.length());
                }
                codebase = new URL("file:/" + filepath + File.separator);
            }
            catch (MalformedURLException e) {
                Trace.ignoredException((Exception)e);
            }
            if (codebase != null) {
                URL originalRequestURL = new URL(codebase.toString() + origFile.getName());
                LaunchDesc ld = LaunchDescFactory.buildDescriptor(f, codebase, null, originalRequestURL);
                derivedCodebase = codebase;
                return ld;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LaunchDesc buildDescriptor(URL url, URL documentbase) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        int current = ResourceProvider.get().incrementInternalUse();
        try {
            LaunchDesc launchDesc = LaunchDescFactory._buildDescriptor(url, documentbase);
            return launchDesc;
        }
        finally {
            ResourceProvider.get().decrementInternalUse(current);
        }
    }

    private static LaunchDesc _buildDescriptor(URL url, URL documentbase) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        File jnlpFile;
        Resource jnlp = null;
        IOException networkException = null;
        try {
            jnlpFile = ResourceProvider.get().getResource(url, null).getDataFile();
        }
        catch (IOException ioe) {
            if (ioe instanceof UnknownHostException || ioe instanceof FailedDownloadException || ioe instanceof ConnectException || ioe instanceof SocketException) {
                Trace.ignoredException((Exception)ioe);
                networkException = ioe;
                jnlpFile = ResourceProvider.get().getCachedJNLPFile(url, null);
                if (jnlpFile == null && DeployOfflineManager.isForcedOffline()) {
                    throw ioe;
                }
            }
            throw ioe;
        }
        URL codebase = URLUtil.asPathURL((URL)URLUtil.getBase((URL)url));
        if (jnlpFile != null && jnlpFile.exists()) {
            URL realURL;
            LaunchDesc ld;
            if (Environment.getImportModeCodebaseOverride() != null) {
                codebase = new URL(Environment.getImportModeCodebaseOverride());
            }
            if ((ld = LaunchDescFactory.buildDescriptor(jnlpFile, codebase, documentbase, (realURL = DownloadEngine.getKnownRedirectFinalURL((URL)url)) != null ? realURL : url)) == null) {
                return null;
            }
            if (ld.getLaunchType() == 5) {
                ResourceProvider.get().markRetired(jnlp, false);
            }
            if (networkException != null && !ld.getInformation().supportsOfflineOperation()) {
                throw networkException;
            }
            derivedCodebase = codebase;
            return ld;
        }
        HttpRequest httpreq = DownloadEngine.getHttpRequestImpl();
        HttpResponse response = httpreq.doGetRequest(url);
        FilterInputStream is = response.getInputStream();
        int size = response.getContentLength();
        String encoding = response.getContentEncoding();
        if (encoding != null && encoding.indexOf("gzip") >= 0) {
            is = new GZIPInputStream((InputStream)is, 8192);
        }
        URL realURL = HttpUtils.getFinalRedirectedURL((HttpResponse)response);
        LaunchDesc ld = LaunchDescFactory.buildDescriptor(SystemUtils.readBytes((InputStream)is, (long)size), codebase, documentbase, realURL != null ? realURL : url);
        ((InputStream)is).close();
        return ld;
    }

    private static LaunchDesc buildDescriptorFromCache(URL url, URL documentbase) throws BadFieldException, MissingFieldException, JNLParseException {
        try {
            File f = ResourceProvider.get().getCachedJNLPFile(url, null);
            if (f != null) {
                URL codebase = URLUtil.asPathURL((URL)URLUtil.getBase((URL)url));
                return LaunchDescFactory.buildDescriptor(f, codebase, documentbase, url);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static LaunchDesc buildDescriptorFromCache(String jnlpHRef, URL codebase, URL documentbase) throws BadFieldException, MissingFieldException, JNLParseException {
        URL url;
        LaunchDesc ld = null;
        try {
            File jnlpFile = new File(jnlpHRef);
            if (jnlpFile.isFile()) {
                ld = LaunchDescFactory.buildDescriptor(jnlpFile, codebase, documentbase, LaunchDescFactory.getOriginalURL());
            }
            if (ld != null) {
                return ld;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            url = new URL(jnlpHRef);
            ld = jnlpHRef.endsWith(".jarjnlp") ? LaunchDescFactory.buildNoHrefDescriptorFromCache(url, codebase, documentbase) : LaunchDescFactory.buildDescriptorFromCache(url, documentbase);
            if (ld != null) {
                return ld;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (codebase != null) {
            try {
                url = new URL(codebase, jnlpHRef);
                ld = LaunchDescFactory.buildDescriptorFromCache(url, documentbase);
                if (ld != null) {
                    return ld;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (codebase == null && documentbase != null) {
            try {
                url = new URL(URLUtil.getBase((URL)documentbase), jnlpHRef);
                ld = LaunchDescFactory.buildDescriptorFromCache(url, documentbase);
                if (ld != null) {
                    return ld;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static LaunchDesc buildNoHrefDescriptorFromCache(URL url, URL codebase, URL documentbase) throws BadFieldException, MissingFieldException, JNLParseException {
        try {
            CacheEntry r;
            if (codebase == null) {
                codebase = URLUtil.asPathURL((URL)URLUtil.getBase((URL)url));
            }
            if ((r = (CacheEntry)ResourceProvider.get().getCachedResource(url, null)) == null) {
                return null;
            }
            LocalApplicationProperties lap = Cache.getLocalApplicationProperties((CacheEntry)r);
            if (lap != null) {
                return LaunchDescFactory.buildDescriptor(r.getDataFile(), lap, codebase, documentbase);
            }
            return LaunchDescFactory.buildDescriptor(r.getDataFile(), codebase, documentbase, url);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static LaunchDesc buildDescriptor(String jnlpHRef, URL codebase, URL documentbase, boolean verbose) throws BadFieldException, MissingFieldException, JNLParseException {
        block32: {
            LaunchDesc ld;
            URL url;
            block31: {
                block30: {
                    url = null;
                    try {
                        url = new URL(jnlpHRef);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (url != null) {
                        try {
                            LaunchDesc ld2 = LaunchDescFactory.buildDescriptor(url, documentbase);
                            if (verbose) {
                                Trace.println((String)("   JNLP Ref (absolute): " + url));
                            }
                            return ld2;
                        }
                        catch (BadFieldException e) {
                            throw e;
                        }
                        catch (MissingFieldException e) {
                            throw e;
                        }
                        catch (JNLParseException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            if (!verbose) break block30;
                            Trace.ignored((Throwable)e);
                        }
                    }
                }
                if (codebase != null) {
                    try {
                        url = new URL(codebase, jnlpHRef);
                    }
                    catch (MalformedURLException e) {
                        url = null;
                    }
                    if (url != null) {
                        try {
                            ld = LaunchDescFactory.buildDescriptor(url, documentbase);
                            if (verbose) {
                                Trace.println((String)(" JNLP Ref (codebase + ref): " + url));
                            }
                            return ld;
                        }
                        catch (BadFieldException e) {
                            throw e;
                        }
                        catch (MissingFieldException e) {
                            throw e;
                        }
                        catch (JNLParseException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            if (!verbose) break block31;
                            Trace.ignored((Throwable)e);
                        }
                    }
                }
            }
            if (codebase == null && documentbase != null) {
                try {
                    url = new URL(URLUtil.getBase((URL)documentbase), jnlpHRef);
                }
                catch (MalformedURLException e) {
                    url = null;
                }
                if (url != null) {
                    try {
                        ld = LaunchDescFactory.buildDescriptor(url, documentbase);
                        if (verbose) {
                            Trace.println((String)("   JNLP Ref (documentbase + ref): " + url));
                        }
                        return ld;
                    }
                    catch (BadFieldException e) {
                        throw e;
                    }
                    catch (MissingFieldException e) {
                        throw e;
                    }
                    catch (JNLParseException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (!verbose) break block32;
                        Trace.ignored((Throwable)e);
                    }
                }
            }
        }
        if (verbose) {
            Trace.println((String)"   JNLP Ref (...): NULL !");
        }
        return null;
    }

    public static LaunchDesc buildDescriptor(String urlfile) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        try {
            String filteredURLString = URLUtil.filterProtocols((String)urlfile);
            int commaIndex = filteredURLString.indexOf(",");
            if (filteredURLString.startsWith("data:") && commaIndex > 0 && commaIndex < filteredURLString.length() - 1) {
                Trace.println((String)("Embedded data: URI:" + urlfile), (TraceLevel)TraceLevel.BASIC);
                return LaunchDescFactory.buildDescriptor(Base64Wrapper.decodeFromString((String)filteredURLString.substring(commaIndex)), null, null);
            }
            URL url = new URL(filteredURLString);
            try {
                LaunchDesc cached = LaunchDescFactory.buildDescriptorFromCache(url, null);
                if (cached == null) {
                    CacheEntry ce = Cache.findMatchingJNLPEntry((String)urlfile);
                    if (ce != null) {
                        return LaunchDescFactory.buildDescriptor(ce.getDataFile(), URLUtil.getBase((URL)url), null, url);
                    }
                } else {
                    if (cached.getLocation() != null) {
                        return cached;
                    }
                    Resource ce = ResourceProvider.get().getCachedResource(url, null);
                    if (ce != null) {
                        ResourceProvider.get().markRetired(ce, true);
                    }
                }
            }
            catch (Exception cached) {
                // empty catch block
            }
            if (DeployOfflineManager.isForcedOffline()) {
                throw new IOException(ResourceManager.getString((String)"launch.error.offlinemissingresource"));
            }
            return LaunchDescFactory.buildDescriptor(url, null);
        }
        catch (MalformedURLException e) {
            File f = new File(urlfile);
            try {
                FileInputStream is = new FileInputStream(urlfile);
                long lsize = f.length();
                if (lsize > 0x100000L) {
                    throw new IOException("File too large");
                }
                if (Environment.isImportMode()) {
                    String dir = f.getParent();
                    if (Environment.getImportModeCodebaseOverride() == null && dir != null) {
                        try {
                            URL altCodebase = new URL("file", null, URLUtil.encodePath((String)dir));
                            Environment.setImportModeCodebaseOverride((String)altCodebase.toString());
                        }
                        catch (MalformedURLException mue) {
                            Trace.ignoredException((Exception)mue);
                        }
                    }
                }
                return LaunchDescFactory.buildDescriptor(SystemUtils.readBytes((InputStream)is, (long)((int)lsize)), null, null, f.toURI().toURL());
            }
            catch (FileNotFoundException fnfe) {
                URL origURL = LaunchDescFactory.getOriginalURL();
                if (origURL == null) {
                    throw fnfe;
                }
                return LaunchDescFactory.buildDescriptor(origURL, null);
            }
        }
    }

    private static String getOriginalFilename() {
        String value = System.getProperty("jnlpx.origFilenameArg");
        return value != null ? value : null;
    }

    private static URL getOriginalURL() {
        String s = LaunchDescFactory.getOriginalFilename();
        if (s != null) {
            try {
                return new URL(s);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static LaunchDesc buildInternalLaunchDesc(XMLNode xml, String tab) {
        return new LaunchDesc("0.1", null, null, null, null, 1, null, null, null, 5, null, null, null, null, null, tab == null ? xml.getName() : tab, xml, null);
    }

    public static LaunchDesc tryUpdateDescriptor(LaunchDesc ld) {
        URL originalURL = ld.getSourceURL();
        try {
            if (originalURL != null) {
                return LaunchDescFactory.buildDescriptor(originalURL, null);
            }
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
        }
        return ld;
    }
}

