/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.net.URL;
import java.util.ArrayList;

public class LaunchSelection {
    private static final String ANY_JRE_VERSION = "0+";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JREInfo selectJRE(LaunchDesc ld, JREMatcher matcher) {
        JREMatcher jREMatcher = matcher;
        synchronized (jREMatcher) {
            if (!matcher.hasBeenRun()) {
                matcher.beginTraversal(ld);
                ResourcesDesc rdescs = ld.getRawResources();
                if (rdescs != null) {
                    ResourcesDesc rd = new ResourcesDesc();
                    rd.addNested(rdescs);
                    LaunchSelection.selectJREDescHelper(ld, matcher);
                    JREDesc bestJreDesc = matcher.getSelectedJREDesc();
                    if (bestJreDesc != null) {
                        rd.addNested(bestJreDesc.getNestedResources());
                    }
                    if (!ld.isInstaller()) {
                        LaunchSelection.collectJVMProperties(rd, matcher);
                    }
                }
                matcher.endTraversal(ld);
            }
            return matcher.getSelectedJREInfo();
        }
    }

    protected static boolean addNestedResourcesForRunningJRE(LaunchDesc ld) {
        boolean result = false;
        ResourcesDesc rdescs = ld.getResources();
        if (rdescs != null) {
            JREMatcher matcher = new JREMatcher();
            matcher.beginTraversal(ld);
            LaunchSelection.selectJREDescHelper(ld, matcher);
            JREDesc running = matcher.getRunningJREDesc();
            if (running != null) {
                rdescs.addNested(running.getNestedResources());
                result = true;
            }
            matcher.endTraversal(ld);
        }
        return result;
    }

    private static void selectJREDescHelper(final LaunchDesc ld, JREMatcher matcher) {
        ResourcesDesc rd = ld.getResources();
        if (rd == null) {
            return;
        }
        final ArrayList listJREDesc = new ArrayList();
        rd.visit(new ResourceVisitor(){

            @Override
            public void visitJREDesc(JREDesc jre) {
                if (ld.isLibrary()) {
                    Trace.println((String)("JNLP JREDesc in Component ignored: " + ld.getLocation()), (TraceLevel)TraceLevel.BASIC);
                } else {
                    listJREDesc.add(jre);
                }
            }
        });
        JREDesc foundJreDesc = null;
        JREInfo foundJreInfo = null;
        boolean homeJreDescFound = false;
        for (JREDesc jreDesc : listJREDesc) {
            JREInfo jreInfo;
            if (!(foundJreInfo != null && homeJreDescFound || (jreInfo = LaunchSelection.selectJRE(jreDesc, matcher, ld.needFX())) == null)) {
                foundJreInfo = jreInfo;
                foundJreDesc = jreDesc;
            }
            if (matcher.getRunningJREDesc() != null || !matcher.isVersionMatch(JREInfo.getHomeJRE(), jreDesc)) continue;
            matcher.setRunningJREDesc(jreDesc);
            homeJreDescFound = true;
        }
        if (foundJreInfo == null) {
            if (listJREDesc.isEmpty()) {
                foundJreDesc = new JREDesc(ANY_JRE_VERSION, -1L, -1L, null, null, new ResourcesDesc(), null);
                foundJreInfo = LaunchSelection.selectJRE(foundJreDesc, matcher, ld.needFX());
            } else {
                foundJreDesc = (JREDesc)listJREDesc.get(0);
            }
        }
        matcher.digest(foundJreDesc, foundJreInfo);
    }

    private static void collectJVMProperties(ResourcesDesc rd, JREMatcher matcher) {
        if (rd == null) {
            return;
        }
        matcher.digest(rd);
        final ArrayList listExtDesc = new ArrayList();
        rd.visit(new ResourceVisitor(){

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                listExtDesc.add(ed);
            }
        });
        for (ExtensionDesc ed : listExtDesc) {
            LaunchDesc extensionLd = ed.getExtensionDesc();
            if (extensionLd == null || extensionLd.isInstaller()) continue;
            LaunchSelection.collectJVMProperties(extensionLd.getResources(), matcher);
        }
    }

    public static JREInfo selectJRE(URL location, String version) {
        JREDesc desc = new JREDesc(version, -1L, -1L, null, location, new ResourcesDesc(), null);
        return LaunchSelection.selectJRE(desc, new JREMatcher(), false);
    }

    public static JREInfo selectJRE(JREDesc jreDesc, JREMatcher matcher, boolean needFX) {
        JREInfo[] jres = JREInfo.getValidSorted();
        if (jres == null) {
            return null;
        }
        for (int i = 0; i < jres.length; ++i) {
            if (!jres[i].isEnabled() || !matcher.isVersionMatch(jres[i], jreDesc) || needFX && jres[i].getJfxRuntime() == null) continue;
            return jres[i];
        }
        JREInfo homeJRE = JREInfo.getHomeJRE();
        if (matcher.isVersionMatch(homeJRE, jreDesc) && (!needFX || homeJRE.getJfxRuntime() != null)) {
            return homeJRE;
        }
        return null;
    }
}

