/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CachedCertificatesHelper;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.TrustRecorder;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.JarUtil;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JNLPSigningException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.UnsignedAccessViolationException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.SigningInfo;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class JNLPSignedResourcesHelper {
    static final String SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING = "Signed jnlp file removed after signing.";
    static final boolean DEBUG = Config.getDebug();
    LaunchDesc mainDesc = null;
    private Thread warmupValidationThread = null;
    private boolean warmupOk = true;
    private static final String SIGNED_JNLP_ENTRY = "JNLP-INF/APPLICATION.JNLP";
    private static final String SIGNED_JNLP_TEMPLATE = "JNLP-INF/APPLICATION_TEMPLATE.JNLP";

    public JNLPSignedResourcesHelper(LaunchDesc main) {
        this.mainDesc = main;
        AppPolicy.createInstance(this.mainDesc.getCanonicalHome().getHost());
    }

    public synchronized void warmup() {
        if (this.warmupOk) {
            WarmupValidator v = new WarmupValidator();
            this.warmupValidationThread = new Thread(v);
            this.warmupValidationThread.setDaemon(true);
            this.warmupValidationThread.start();
        }
    }

    public void checkSignedLaunchDesc() throws IOException, JNLPException {
        this.checkSignedLaunchDesc(null, null);
    }

    public void checkSignedLaunchDesc(URL codebase, URL docbase) throws IOException, JNLPException {
        ArrayList<LaunchDesc> list = new ArrayList<LaunchDesc>();
        JNLPSignedResourcesHelper.addExtensions(list, this.mainDesc);
        for (LaunchDesc cur : list) {
            this.checkSignedLaunchDescHelper(cur, codebase, docbase);
        }
    }

    synchronized void ensureWarmupFinished() {
        if (this.warmupValidationThread != null) {
            try {
                this.warmupValidationThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.warmupValidationThread = null;
            this.warmupOk = false;
        }
    }

    public boolean checkSignedResources(Preloader p, boolean progressOnly) throws IOException, JNLPException, ExitException {
        if (TrustRecorder.isAllSigned((URL)this.mainDesc.getCanonicalHome())) {
            Config.getHooks().trackUsage(this.mainDesc.getAppInfo(), this.mainDesc.getMainDeploymentRuleSet());
            return true;
        }
        if (TrustRecorder.isNotAllSigned((URL)this.mainDesc.getCanonicalHome())) {
            return false;
        }
        this.ensureWarmupFinished();
        boolean allSigned = true;
        ArrayList<LaunchDesc> list = new ArrayList<LaunchDesc>();
        JNLPSignedResourcesHelper.addExtensions(list, this.mainDesc);
        for (LaunchDesc cur : list) {
            cur.setParentURL(this.mainDesc.getParentURL());
            allSigned = JNLPSignedResourcesHelper.checkSignedResourcesHelper(cur, p, progressOnly) && allSigned;
        }
        if (!progressOnly) {
            TrustRecorder.recordAllSigned((URL)this.mainDesc.getCanonicalHome(), (boolean)allSigned);
        }
        return allSigned;
    }

    public static void addExtensions(final ArrayList<LaunchDesc> list, LaunchDesc ld) {
        if (ld == null) {
            return;
        }
        list.add(ld);
        ResourcesDesc rd = ld.getResources();
        if (rd != null) {
            rd.visit(new ResourceVisitor(){

                @Override
                public void visitExtensionDesc(ExtensionDesc ed) {
                    if (!ed.isInstaller()) {
                        JNLPSignedResourcesHelper.addExtensions(list, ed.getExtensionDesc());
                    }
                }
            });
        }
    }

    private void checkSignedLaunchDescHelper(LaunchDesc ld, URL codebase, URL docbase) throws IOException, JNLPException {
        block14: {
            byte[] signedJnlpFile = null;
            byte[] signedJnlpTemplate = null;
            JNLPSigningException savedException = null;
            try {
                signedJnlpTemplate = JNLPSignedResourcesHelper.getSignedJNLPFile(ld, true);
                if (signedJnlpTemplate != null) {
                    try {
                        ld.checkSigningTemplate(signedJnlpTemplate);
                        if (DEBUG) {
                            Trace.println((String)"Signed JNLP Template matches LaunchDesc", (TraceLevel)TraceLevel.SECURITY);
                        }
                        return;
                    }
                    catch (JNLPSigningException se) {
                        if (DEBUG) {
                            Trace.println((String)"Signed JNLP Template fails to match ld", (TraceLevel)TraceLevel.SECURITY);
                        }
                        savedException = se;
                    }
                }
                if ((signedJnlpFile = JNLPSignedResourcesHelper.getSignedJNLPFile(ld, false)) == null) {
                    if (savedException != null) {
                        throw savedException;
                    }
                    break block14;
                }
                if (Arrays.equals(SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING.getBytes(), signedJnlpFile)) {
                    throw new JNLPSigningException(ld, SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING);
                }
                LaunchDesc signedLd = LaunchDescFactory.buildDescriptor(signedJnlpFile, codebase, docbase, ld.getLocation());
                if (Trace.isEnabled((TraceLevel)TraceLevel.SECURITY)) {
                    Trace.println((String)"Downloaded JNLP file: ", (TraceLevel)TraceLevel.SECURITY);
                    Trace.println((String)ld.toString(), (TraceLevel)TraceLevel.SECURITY);
                    Trace.println((String)"Signed JNLP file: ", (TraceLevel)TraceLevel.SECURITY);
                    Trace.println((String)signedLd.toString(), (TraceLevel)TraceLevel.SECURITY);
                }
                ld.checkSigning(signedLd);
                return;
            }
            catch (LaunchDescException jse) {
                jse.setIsSignedLaunchDesc();
                throw jse;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (JNLPException je) {
                throw je;
            }
        }
        if (ld.getCachedCertificates() != null && ld.getCachedCertificates()[0].isSignedJNLP()) {
            throw new JNLPSigningException(ld, null);
        }
    }

    private static boolean hasProgressResources(ResourcesDesc rd) {
        JARDesc[] jds;
        for (JARDesc jd : jds = rd.getLocalJarDescs()) {
            if (!jd.isProgressJar()) continue;
            return true;
        }
        return false;
    }

    private static boolean performSecurityCheckForSandbox(LaunchDesc ld, Preloader p, CodeSource mainJarCodesource, boolean progressOnly) throws ExitException {
        AppInfo ainfo = ld.getAppInfo();
        try {
            if (progressOnly) {
                ainfo.setPermissionAttrOverride();
            }
            SandboxSecurity.isPermissionGranted((CodeSource)mainJarCodesource, (AppInfo)ainfo, (DeploymentRuleSet)ld.getMainDeploymentRuleSet(), (Preloader)p, null);
        }
        catch (SecurityException se) {
            boolean isCertificateRevocationException = false;
            if (se instanceof BlockedException && se.getCause() instanceof CertificateRevokedException) {
                isCertificateRevocationException = true;
            }
            throw new ExitException(se.getMessage(), se, isCertificateRevocationException ? 3 : 0);
        }
        finally {
            ainfo.unsetPermissionAttrOverride();
        }
        return ld.isSecureJVMArgs();
    }

    private static boolean checkSignedResourcesHelper(LaunchDesc ld, Preloader p, boolean progressOnly) throws IOException, JNLPException, ExitException {
        ResourcesDesc rd = ld.getResources();
        if (rd == null) {
            return true;
        }
        if (progressOnly && !JNLPSignedResourcesHelper.hasProgressResources(rd)) {
            return true;
        }
        CodeSource mainJarCodesource = null;
        if (ld.isSecure() && ((mainJarCodesource = JNLPSignedResourcesHelper.getMainJarCodeSource(ld, progressOnly)) == null || mainJarCodesource.getCertificates() == null)) {
            return JNLPSignedResourcesHelper.performSecurityCheckForSandbox(ld, p, mainJarCodesource, progressOnly);
        }
        JARDesc[] jds = rd.getLocalJarDescs();
        final AtomicBoolean sameCertRef = new AtomicBoolean(true);
        final AtomicBoolean isMainJarEmpty = new AtomicBoolean(false);
        final AtomicBoolean nonEmptyJarFoundRef = new AtomicBoolean(true);
        final AtomicReference<Object> certChainsRef = new AtomicReference<Object>(null);
        final AtomicReference<Object> signersRef = new AtomicReference<Object>(null);
        URL home = ld.getCanonicalHome();
        final AtomicInteger jarsCachedRef = new AtomicInteger(0);
        final AtomicReference<Object> unsignedRef = new AtomicReference<Object>(null);
        SigningInfo sJNLP = null;
        if (DEBUG) {
            Trace.println((String)("Validating signatures for " + ld.getLocation() + " " + ld.getSourceURL()), (TraceLevel)TraceLevel.SECURITY);
        }
        if (ld.getLocation() != null) {
            URL u = ld.getSourceURL();
            if (u == null) {
                u = ld.getLocation();
            }
            sJNLP = new SigningInfo(u, ld.getVersion());
        }
        nonEmptyJarFoundRef.set(false);
        final AtomicReference<Object> exceptionRef = new AtomicReference<Object>(null);
        final AtomicReference<LaunchDesc> ldRef = new AtomicReference<LaunchDesc>(ld);
        ArrayList<2> tasks = new ArrayList<2>();
        int count = jds.length;
        if (Environment.isJavaWebStart() && !ld.isSecure() && ((count = Config.getIntProperty((String)"deployment.security.preverify.count")) < 1 || count > jds.length)) {
            count = jds.length;
        }
        for (int i = 0; i < count; ++i) {
            final AtomicReference<JARDesc> jdsRef = new AtomicReference<JARDesc>(jds[i]);
            Callable<Object> c = new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() {
                    if (exceptionRef.get() != null || unsignedRef.get() != null || !sameCertRef.get()) {
                        return null;
                    }
                    JARDesc jd = (JARDesc)jdsRef.get();
                    SigningInfo sInfo = new SigningInfo(jd.getLocation(), jd.getVersion());
                    if (sInfo.isFileKnownToBeNotCached()) {
                        if (DEBUG) {
                            Trace.println((String)("    Skip " + jd.getLocationString()), (TraceLevel)TraceLevel.SECURITY);
                        }
                        return null;
                    }
                    List<SigningInfo.CertChain> jarCertChains = null;
                    try {
                        List<CodeSigner> jarSigners = sInfo.check();
                        if (jarSigners != null) {
                            jarCertChains = sInfo.signersToCertChains(jarSigners);
                            signersRef.set(jarSigners);
                        }
                    }
                    catch (Exception e) {
                        exceptionRef.compareAndSet(null, e);
                        return null;
                    }
                    if (sInfo.isJarKnownToBeEmpty()) {
                        if (jd.isMainJarFile()) {
                            isMainJarEmpty.set(true);
                        }
                        return null;
                    }
                    nonEmptyJarFoundRef.set(true);
                    if (jarCertChains == null || jarCertChains.size() == 0) {
                        AtomicReference e = unsignedRef;
                        synchronized (e) {
                            if (unsignedRef.get() == null) {
                                unsignedRef.set(jd.getLocation());
                            }
                        }
                        if (((LaunchDesc)ldRef.get()).getSecurityModel() != 0) {
                            Resource r = ResourceProvider.get().getCachedResource(jd.getLocation(), jd.getVersion());
                            ResourceProvider.get().markRetired(r, true);
                        }
                        return null;
                    }
                    if (!certChainsRef.compareAndSet(null, jarCertChains)) {
                        List localCertChain;
                        AtomicReference atomicReference = certChainsRef;
                        synchronized (atomicReference) {
                            certChainsRef.set(SigningInfo.overlapChainLists(jarCertChains, (List)certChainsRef.get()));
                            localCertChain = (List)certChainsRef.get();
                        }
                        if (DEBUG) {
                            Trace.println((String)("Have " + (localCertChain == null ? 0 : localCertChain.size()) + " common certificates after processing " + jd.getLocationString()), (TraceLevel)TraceLevel.SECURITY);
                        }
                        if (localCertChain == null) {
                            sameCertRef.set(false);
                            if (((LaunchDesc)ldRef.get()).getSecurityModel() != 0) {
                                Resource r = ResourceProvider.get().getCachedResource(jd.getLocation(), jd.getVersion());
                                ResourceProvider.get().markRetired(r, true);
                            }
                        }
                    }
                    jarsCachedRef.incrementAndGet();
                    return null;
                }
            };
            tasks.add(c);
        }
        if (tasks.size() > 0) {
            ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            try {
                executor.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                throw new RuntimeException(e);
            }
            executor.shutdown();
        }
        if (isMainJarEmpty.get()) {
            throw new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.main.jar.empty"), null);
        }
        if (!sameCertRef.get()) {
            throw new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.singlecertviolation"), null);
        }
        if (exceptionRef.get() != null) {
            throw new RuntimeException(exceptionRef.get());
        }
        if (!ld.isSecure()) {
            if (unsignedRef.get() != null) {
                String weakJarMessage = JarVerifier.getWeakAlgorithmMessage();
                throw new UnsignedAccessViolationException(ld, unsignedRef.get(), true, weakJarMessage);
            }
            List certChains = certChainsRef.get();
            List<Certificate> certList = JNLPSignedResourcesHelper.normalizeCertificateList(certChains);
            if (ld.getCachedCertificates() != null) {
                CachedCertificatesHelper[] certs;
                for (CachedCertificatesHelper cert : certs = ld.getCachedCertificates()) {
                    JNLPSignedResourcesHelper.checkCachedChain(ld, certList, cert.getCertPath());
                }
            }
            if (jarsCachedRef.get() > 0) {
                JARDesc jarDescriptor = ld.getMainJar();
                URL location = jarDescriptor != null ? jarDescriptor.getLocation() : ld.getCanonicalHome();
                List signersList = signersRef.get();
                CodeSigner[] signers = signersList.toArray(new CodeSigner[signersList.size()]);
                String version = jarDescriptor != null ? jarDescriptor.getVersion() : null;
                Resource r = ResourceProvider.get().getCachedResource(location, version);
                try {
                    if (r != null && r.getURL() != null) {
                        location = new URL(r.getURL());
                    }
                }
                catch (MalformedURLException mue) {
                    Trace.ignored((Throwable)mue);
                }
                CodeSource cs = new CodeSource(location, signers);
                long l = AppPolicy.getInstance().grantAllPermissions(ld, ld.getMainDeploymentRuleSet(), cs, p, progressOnly);
            }
        } else {
            return JNLPSignedResourcesHelper.performSecurityCheckForSandbox(ld, p, mainJarCodesource, progressOnly);
        }
        if (DEBUG) {
            Trace.println((String)("LD - All JAR files signed: " + home), (TraceLevel)TraceLevel.BASIC);
        }
        return unsignedRef.get() == null;
    }

    static byte[] getSignedJNLPFile(LaunchDesc ld, boolean getTemplate) throws IOException, JNLPException {
        if (ld.getResources() == null || ld.isLibrary()) {
            return null;
        }
        JARDesc mainJar = ld.getMainJar();
        if (mainJar == null) {
            return null;
        }
        return JNLPSignedResourcesHelper.getSignedJNLPBits(mainJar.getLocation(), mainJar.getVersion(), getTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSignedJNLPBits(URL url, String version, boolean getTemplate) throws IOException {
        String filename = getTemplate ? SIGNED_JNLP_TEMPLATE : SIGNED_JNLP_ENTRY;
        try (ZipFile jarf = null;){
            Object allnames;
            jarf = JarUtil.createJarFile((File)new File(ResourceProvider.get().getCachedResourceFilePath(url, version)), (boolean)false);
            JarEntry sjfe = ((JarFile)jarf).getJarEntry(filename);
            if (sjfe == null) {
                allnames = ((JarFile)jarf).entries();
                while (allnames.hasMoreElements() && sjfe == null) {
                    JarEntry jfe = allnames.nextElement();
                    if (!jfe.getName().equalsIgnoreCase(filename)) continue;
                    sjfe = jfe;
                }
            }
            if (sjfe == null) {
                if (JNLPSignedResourcesHelper.hasSigningEntryForFile((JarFile)jarf, filename)) {
                    Trace.println((String)("Signed jnlp file: " + filename + " was removed from jar file: " + url), (TraceLevel)TraceLevel.SECURITY);
                    allnames = SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING.getBytes();
                    return allnames;
                }
                allnames = null;
                return allnames;
            }
            byte[] signedJnlp = new byte[(int)sjfe.getSize()];
            DataInputStream is = new DataInputStream(((JarFile)jarf).getInputStream(sjfe));
            is.readFully(signedJnlp, 0, (int)sjfe.getSize());
            is.close();
            byte[] byArray = signedJnlp;
            return byArray;
        }
    }

    private static boolean hasSigningEntryForFile(JarFile jf, String filename) {
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            String name = je.getName().toUpperCase(Locale.ENGLISH);
            if (!name.startsWith("META-INF/") || !name.endsWith(".SF")) continue;
            try {
                Manifest m = new Manifest(jf.getInputStream(je));
                for (String signed : m.getEntries().keySet()) {
                    if (!filename.equalsIgnoreCase(signed)) continue;
                    return true;
                }
            }
            catch (IOException ex) {
                Trace.ignored((Throwable)ex);
            }
        }
        return false;
    }

    static void checkCachedChain(LaunchDesc ld, List<? extends Certificate> certs, CertPath certPath) throws LaunchDescException {
        if (certs == null) {
            return;
        }
        List<? extends Certificate> cachedCerts = certPath.getCertificates();
        for (int i = 0; i < cachedCerts.size(); ++i) {
            Certificate cachedCert = cachedCerts.get(i);
            if (certs.contains(cachedCert)) continue;
            throw new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.unmatched.embedded.cert"), null);
        }
    }

    static List<Certificate> normalizeCertificateList(List<?> certs) {
        ArrayList<? extends Certificate> justCerts = new ArrayList<Certificate>();
        if (certs != null) {
            for (int i = 0; i < certs.size(); ++i) {
                if (certs.get(i) instanceof CodeSigner) {
                    CodeSigner signer = (CodeSigner)certs.get(i);
                    CertPath cp = signer.getSignerCertPath();
                    if (cp == null) continue;
                    justCerts.addAll(cp.getCertificates());
                    continue;
                }
                if (!(certs.get(i) instanceof SigningInfo.CertChain)) continue;
                SigningInfo.CertChain cc = (SigningInfo.CertChain)certs.get(i);
                justCerts.addAll(Arrays.asList(cc.getCertificates()));
            }
        }
        return Collections.unmodifiableList(justCerts);
    }

    private static CodeSource getMainJarCodeSource(LaunchDesc ld, boolean progressOnly) {
        Object certs = null;
        CodeSigner[] signers = null;
        JARDesc jd = null;
        jd = progressOnly ? ld.getResources().getProgressJar() : ld.getMainJar();
        if (jd != null) {
            try {
                SigningInfo sInfo = new SigningInfo(jd.getLocation(), jd.getVersion());
                List<CodeSigner> signerList = sInfo.check();
                if (signerList == null) {
                    throw new JARSigningException(jd.getLocation(), jd.getVersion(), 3);
                }
                signers = signerList.toArray(new CodeSigner[signerList.size()]);
            }
            catch (SecurityException ex) {
                throw ex;
            }
            catch (Exception e) {
                Trace.println((String)("Treat jar as unsigned due to exception: " + e), (TraceLevel)TraceLevel.SECURITY);
            }
        }
        return new CodeSource(jd != null ? jd.getLocation() : ld.getCanonicalHome(), signers);
    }

    class WarmupValidator
    implements Runnable {
        WarmupValidator() {
        }

        @Override
        public void run() {
            if (DEBUG) {
                Trace.println((String)"Staring warmup validation", (TraceLevel)TraceLevel.SECURITY);
            }
            ArrayList<LaunchDesc> list = new ArrayList<LaunchDesc>();
            JNLPSignedResourcesHelper.addExtensions(list, JNLPSignedResourcesHelper.this.mainDesc);
            Iterator<LaunchDesc> iterator = list.iterator();
            while (iterator.hasNext()) {
                LaunchDesc list1;
                LaunchDesc cur = list1 = iterator.next();
                try {
                    this.processSingleDesc(cur);
                }
                catch (Exception e) {
                    Trace.ignored((Throwable)e);
                }
            }
        }

        private void processSingleDesc(LaunchDesc ld) throws GeneralSecurityException, IOException {
            CachedCertificatesHelper[] certs = ld.getCachedCertificates();
            if (certs != null) {
                for (int i = 0; i < certs.length; ++i) {
                    Certificate[] certArr = certs[i].getCertPath().getCertificates().toArray(new X509Certificate[0]);
                    CodeSource cs = new CodeSource(ld.getCanonicalHome(), certArr);
                    TrustDecider.validateChainForWarmup((X509Certificate[])certArr, (CodeSource)cs, (int)i, (AppInfo)ld.getAppInfo(), (DeploymentRuleSet)ld.getMainDeploymentRuleSet());
                }
            }
        }
    }
}

