/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Date;
import javax.jnlp.ExtensionInstallerService;

public final class ExtensionInstallerServiceImpl
implements ExtensionInstallerService {
    private LocalApplicationProperties _lap;
    private Preloader _progress;
    private String _target;
    private String _installPath;
    private boolean _failedJREInstall = false;
    private static final AccessControlContext ACC_INSTALLER_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            FilePermission perm1 = new FilePermission("<<ALL FILES>>", "read,write,delete");
            ((PermissionCollection)perms).add(perm1);
            RuntimePermission perm2 = new RuntimePermission("exitVM");
            ((PermissionCollection)perms).add(perm2);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });
    static ExtensionInstallerServiceImpl _sharedInstance = null;

    private ExtensionInstallerServiceImpl(String installPath, LocalApplicationProperties lap, Preloader progress) {
        this._lap = lap;
        this._progress = progress;
        this._installPath = installPath;
    }

    public static synchronized ExtensionInstallerServiceImpl getInstance() {
        return _sharedInstance;
    }

    public static synchronized void initialize(String installPath, LocalApplicationProperties lap, Preloader progress) {
        if (_sharedInstance == null) {
            _sharedInstance = new ExtensionInstallerServiceImpl(installPath, lap, progress);
        }
    }

    public String getInstallPath() {
        return this._installPath;
    }

    public String getExtensionVersion() {
        return this._lap.getVersionId();
    }

    public URL getExtensionLocation() {
        return this._lap.getLocation();
    }

    public String getInstalledJRE(URL location, String version) {
        JREInfo jre = LaunchSelection.selectJRE(location, version);
        return jre != null ? jre.getPath() : null;
    }

    public void setHeading(String heading) {
        try {
            this._progress.handleEvent((PreloaderEvent)new ConfigEvent(2, heading));
        }
        catch (CancelException ce) {
            throw new RuntimeException(ce);
        }
    }

    public void setStatus(String status) {
        try {
            this._progress.handleEvent((PreloaderEvent)new ConfigEvent(1, status));
        }
        catch (CancelException ce) {
            throw new RuntimeException(ce);
        }
    }

    public void updateProgress(int value) {
        try {
            DownloadEvent de = new DownloadEvent(0, null, null, null, 100L, 100L, value);
            de.sendExplicitEvent(true);
            this._progress.handleEvent((PreloaderEvent)de);
        }
        catch (CancelException ce) {
            ce.printStackTrace();
            throw new RuntimeException(ce);
        }
    }

    public void hideProgressBar() {
        try {
            this._progress.handleEvent((PreloaderEvent)new ConfigEvent(5));
        }
        catch (CancelException ce) {
            throw new RuntimeException(ce);
        }
    }

    public void hideStatusWindow() {
        try {
            this._progress.handleEvent((PreloaderEvent)new ConfigEvent(6));
        }
        catch (CancelException ce) {
            throw new RuntimeException(ce);
        }
    }

    public void setJREInfo(String platformVersion, String jrePath) {
        int model = JNLPClassLoaderUtil.getInstance().getDefaultSecurityModel();
        if (model != 1 && model != 2) {
            throw new SecurityException("Unsigned extension installer attempting to call setJREInfo.");
        }
        Trace.println((String)("setJREInfo: " + jrePath), (TraceLevel)TraceLevel.EXTENSIONS);
        if (jrePath != null && new File(jrePath).exists()) {
            JREInfo.removeJREsIn((String)jrePath);
            JREInfo.addJRE((JREInfo)new JREInfo(platformVersion, this.getExtensionVersion(), this.getExtensionLocation().toString(), jrePath, null, Config.getOSName(), Config.getOSArch(), true, false));
        } else {
            Trace.println((String)"jre install failed: jrePath invalid", (TraceLevel)TraceLevel.EXTENSIONS);
            this._failedJREInstall = true;
        }
    }

    public void setNativeLibraryInfo(String path) {
        Trace.println((String)("setNativeLibInfo: " + path), (TraceLevel)TraceLevel.EXTENSIONS);
        this._lap.setNativeLibDirectory(path);
    }

    public void installFailed() {
        Trace.println((String)"installFailed", (TraceLevel)TraceLevel.EXTENSIONS);
        try {
            Main.systemExit(1);
        }
        catch (ExitException ee) {
            Trace.println((String)("systemExit: " + ee), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)ee);
        }
    }

    public void installSucceeded(boolean needsReboot) {
        if (this._failedJREInstall) {
            return;
        }
        Trace.println((String)"installSucceded", (TraceLevel)TraceLevel.EXTENSIONS);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Config.get().storeIfNeeded();
                return null;
            }
        });
        this._lap.setInstallDirectory(this._installPath);
        this._lap.setLastAccessed(new Date());
        if (needsReboot) {
            this._lap.setRebootNeeded(true);
        } else {
            this._lap.setExtensionInstalled(true);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    ExtensionInstallerServiceImpl.this._lap.store();
                    return null;
                }
            }, ACC_INSTALLER_INSTANCE);
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof IOException) {
                LaunchErrorDialog.show(this._progress.getOwner(), (IOException)pae.getException(), false);
            }
            Trace.ignoredException((Exception)pae.getException());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    ExtensionInstallerServiceImpl.this._progress.handleEvent((PreloaderEvent)new InitEvent(3));
                    Main.systemExit(0);
                }
                catch (CancelException ce) {
                    throw new RuntimeException(ce);
                }
                catch (ExitException ee) {
                    Trace.println((String)("systemExit: " + ee), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)ee);
                }
                return null;
            }
        }, ACC_INSTALLER_INSTANCE);
    }
}

