/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.resources.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.jnlp.FileContents;
import javax.jnlp.JNLPRandomAccessFile;

public final class JNLPRandomAccessFileImpl
implements JNLPRandomAccessFile {
    private RandomAccessFile _raf = null;
    private FileContents _contents = null;
    private long _length = 0L;
    private String _message = null;

    JNLPRandomAccessFileImpl(File file, String mode, FileContents callback) throws IOException {
        this._raf = new RandomAccessFile(file, mode);
        this._length = this._raf.length();
        this._contents = callback;
        if (this._contents == null) {
            throw new IllegalArgumentException("FileContents can not be null");
        }
        if (this._message == null) {
            this._message = ResourceManager.getString((String)"api.persistence.filesizemessage");
        }
    }

    public void close() throws IOException {
        this._raf.close();
    }

    public long length() throws IOException {
        return this._raf.length();
    }

    public long getFilePointer() throws IOException {
        return this._raf.getFilePointer();
    }

    public int read() throws IOException {
        return this._raf.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this._raf.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this._raf.read(b);
    }

    public void readFully(byte[] b) throws IOException {
        this._raf.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this._raf.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this._raf.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this._raf.readBoolean();
    }

    public byte readByte() throws IOException {
        return this._raf.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this._raf.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this._raf.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this._raf.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this._raf.readChar();
    }

    public int readInt() throws IOException {
        return this._raf.readInt();
    }

    public long readLong() throws IOException {
        return this._raf.readLong();
    }

    public float readFloat() throws IOException {
        return this._raf.readFloat();
    }

    public double readDouble() throws IOException {
        return this._raf.readDouble();
    }

    public String readLine() throws IOException {
        return this._raf.readLine();
    }

    public String readUTF() throws IOException {
        return this._raf.readUTF();
    }

    public void seek(long pos) throws IOException {
        this._raf.seek(pos);
    }

    public void setLength(long newLength) throws IOException {
        if (newLength > this._contents.getMaxLength()) {
            throw new IOException(this._message);
        }
        this._raf.setLength(newLength);
    }

    public void write(int b) throws IOException {
        this.checkWrite(1);
        this._raf.write(b);
    }

    public void write(byte[] b) throws IOException {
        if (b != null) {
            this.checkWrite(b.length);
        }
        this._raf.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkWrite(len);
        this._raf.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.checkWrite(1);
        this._raf.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.checkWrite(1);
        this._raf.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.checkWrite(2);
        this._raf.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.checkWrite(2);
        this._raf.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.checkWrite(4);
        this._raf.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.checkWrite(8);
        this._raf.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.checkWrite(4);
        this._raf.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.checkWrite(8);
        this._raf.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        if (s != null) {
            this.checkWrite(s.length());
        }
        this._raf.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        if (s != null) {
            this.checkWrite(s.length() * 2);
        }
        this._raf.writeChars(s);
    }

    public void writeUTF(String s) throws IOException {
        if (s != null) {
            this.checkWrite(this.getUTFLen(s));
        }
        this._raf.writeUTF(s);
    }

    private int getUTFLen(String str) {
        int strlen = str.length();
        char[] charr = new char[strlen];
        str.getChars(0, strlen, charr, 0);
        int count = 2;
        for (int i = 0; i < strlen; ++i) {
            char c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++count;
                continue;
            }
            if (c > '\u07ff') {
                count += 3;
                continue;
            }
            count += 2;
        }
        return count;
    }

    private void checkWrite(int len) throws IOException {
        if (len < 0 || this._contents.getMaxLength() - this._raf.getFilePointer() < (long)len) {
            throw new IOException(this._message);
        }
    }
}

