/*
 * Decompiled with CFR 0.152.
 */
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import org.bouncycastle.pqc.jcajce.interfaces.XMSSPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.pqc.jcajce.spec.XMSSParameterSpec;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class XMSSKeyShardExample {
    public static void main(String[] args) throws Exception {
        Security.addProvider(new BouncyCastlePQCProvider());
        XMSSKeyShardServer keyShardServer = new XMSSKeyShardServer();
        XMSSSignerTask task1 = new XMSSSignerTask("Task 1", keyShardServer);
        new Thread(task1).start();
    }

    private static class XMSSKeyShardServer {
        private PublicKey xmssPub;
        private XMSSPrivateKey xmssPriv;

        XMSSKeyShardServer() throws GeneralSecurityException {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("XMSS", "BCPQC");
            kpg.initialize(new XMSSParameterSpec(10, "SHA256"), new SecureRandom());
            KeyPair keyPair = kpg.generateKeyPair();
            this.xmssPriv = (XMSSPrivateKey)keyPair.getPrivate();
            this.xmssPub = keyPair.getPublic();
        }

        PublicKey getPublicKey() {
            return this.xmssPub;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PrivateKey getPrivateKeyShard() {
            XMSSPrivateKey xMSSPrivateKey = this.xmssPriv;
            synchronized (xMSSPrivateKey) {
                if (this.xmssPriv.getUsagesRemaining() > 0L) {
                    if (this.xmssPriv.getUsagesRemaining() > 10L) {
                        return this.xmssPriv.extractKeyShard(10);
                    }
                    return this.xmssPriv.extractKeyShard((int)this.xmssPriv.getUsagesRemaining());
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasUsagesRemaining() {
            XMSSPrivateKey xMSSPrivateKey = this.xmssPriv;
            synchronized (xMSSPrivateKey) {
                return this.xmssPriv.getUsagesRemaining() > 0L;
            }
        }
    }

    private static class XMSSSignerTask
    implements Runnable {
        private final String label;
        private final XMSSKeyShardServer keyShardServer;

        public XMSSSignerTask(String label, XMSSKeyShardServer keyShardServer) {
            this.label = label;
            this.keyShardServer = keyShardServer;
        }

        public void run() {
            try {
                XMSSPrivateKey sigKey;
                Signature sigGen = Signature.getInstance("XMSS-SHA256", "BCPQC");
                Signature sigVer = Signature.getInstance("XMSS-SHA256", "BCPQC");
                while ((sigKey = (XMSSPrivateKey)this.keyShardServer.getPrivateKeyShard()) != null) {
                    int count = 1;
                    do {
                        sigGen.initSign(sigKey);
                        sigGen.update(Strings.toByteArray("Hello, world!"));
                        byte[] sig = sigGen.sign();
                        System.out.println(this.label + ": " + count + ", " + Hex.toHexString(sig));
                        sigVer.initVerify(this.keyShardServer.getPublicKey());
                        sigVer.update(Strings.toByteArray("Hello, world!"));
                        System.out.println(this.label + ": " + count + ", " + Long.toHexString(sigKey.getIndex()) + ", " + sigVer.verify(sig));
                        ++count;
                    } while (sigKey.getUsagesRemaining() != 0L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

