/*
 * Decompiled with CFR 0.152.
 */
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import org.bouncycastle.pqc.jcajce.interfaces.XMSSMTPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.pqc.jcajce.spec.XMSSMTParameterSpec;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class XMSSMTKeyShardExample {
    public static void main(String[] args) throws Exception {
        Security.addProvider(new BouncyCastlePQCProvider());
        XMSSKeyShardServer keyShardServer = new XMSSKeyShardServer();
        XMSSSignerTask task1 = new XMSSSignerTask("Task 1", keyShardServer);
        XMSSSignerTask task2 = new XMSSSignerTask("Task 2", keyShardServer);
        XMSSSignerTask task3 = new XMSSSignerTask("Task 3", keyShardServer);
        new Thread(task1).start();
        new Thread(task2).start();
        new Thread(task3).start();
    }

    private static class XMSSKeyShardServer {
        private PublicKey xmssPub;
        private XMSSMTPrivateKey xmssPriv;

        XMSSKeyShardServer() throws GeneralSecurityException {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("XMSSMT", "BCPQC");
            kpg.initialize(new XMSSMTParameterSpec(12, 4, "SHA256"), new SecureRandom());
            KeyPair keyPair = kpg.generateKeyPair();
            this.xmssPriv = (XMSSMTPrivateKey)keyPair.getPrivate();
            this.xmssPub = keyPair.getPublic();
        }

        PublicKey getPublicKey() {
            return this.xmssPub;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PrivateKey getPrivateKeyShard() {
            XMSSMTPrivateKey xMSSMTPrivateKey = this.xmssPriv;
            synchronized (xMSSMTPrivateKey) {
                if (this.xmssPriv.getUsagesRemaining() > 0L) {
                    if (this.xmssPriv.getUsagesRemaining() > 10L) {
                        return this.xmssPriv.extractKeyShard(10);
                    }
                    return this.xmssPriv.extractKeyShard((int)this.xmssPriv.getUsagesRemaining());
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasUsagesRemaining() {
            XMSSMTPrivateKey xMSSMTPrivateKey = this.xmssPriv;
            synchronized (xMSSMTPrivateKey) {
                return this.xmssPriv.getUsagesRemaining() > 0L;
            }
        }
    }

    private static class XMSSSignerTask
    implements Runnable {
        private final String label;
        private final XMSSKeyShardServer keyShardServer;

        public XMSSSignerTask(String label, XMSSKeyShardServer keyShardServer) {
            this.label = label;
            this.keyShardServer = keyShardServer;
        }

        public void run() {
            try {
                XMSSMTPrivateKey sigKey;
                Signature sigGen = Signature.getInstance("SHA256withXMSSMT", "BCPQC");
                Signature sigVer = Signature.getInstance("SHA256withXMSSMT", "BCPQC");
                while ((sigKey = (XMSSMTPrivateKey)this.keyShardServer.getPrivateKeyShard()) != null) {
                    int count = 1;
                    do {
                        sigGen.initSign(sigKey);
                        sigGen.update(Strings.toByteArray("Hello, world!"));
                        byte[] sig = sigGen.sign();
                        System.out.println(this.label + ": " + count + ", " + Hex.toHexString(sig));
                        sigVer.initVerify(this.keyShardServer.getPublicKey());
                        sigVer.update(Strings.toByteArray("Hello, world!"));
                        boolean verify = sigVer.verify(sig);
                        System.out.println(this.label + ": " + count + ", " + sigKey.getIndex() + ", " + verify);
                        if (!verify) {
                            System.exit(1);
                        }
                        ++count;
                    } while (sigKey.getUsagesRemaining() != 0L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

