/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

class CleanupRunnable
implements Runnable {
    private ArrayList<String> nonJarItemRemovalList = new ArrayList();
    private ArrayList<String> jarItemRemovalList = new ArrayList();
    private ArrayList<String> loadedResourceList = new ArrayList();
    private static final double CACHE_THRESHOLD_PERCENT = 0.98;
    private final Object syncObject;
    private final long currentCacheMaxSize = Config.getCacheSizeMax();
    private volatile long currentCacheSize = 0L;
    private boolean initCacheSize = true;
    private static final long BUSY_STALE_LIMIT = 3600000L;

    CleanupRunnable(Object object) {
        this.syncObject = object;
    }

    synchronized void addToLoadedResourceList(String string) {
        this.loadedResourceList.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleanup() {
        CleanupRunnable cleanupRunnable = this;
        synchronized (cleanupRunnable) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentCacheSize() {
        long l = 0L;
        File[] fileArray = CleanupRunnable.getCacheResourceFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getPath();
            File file = null;
            if (fileArray[i].isDirectory()) {
                if (!fileArray[i].getName().toLowerCase().endsWith("-n")) {
                    CleanupRunnable.deleteFileOrDirectory(fileArray[i]);
                    continue;
                }
                file = new File(string.substring(0, string.length() - 2) + ".idx");
                if (file.exists()) continue;
                CleanupRunnable.deleteFileOrDirectory(fileArray[i]);
                continue;
            }
            file = new File(string + ".idx");
            if (file.exists()) {
                CacheEntry cacheEntry = Cache.getCacheEntryFromFile(file);
                if (cacheEntry != null) {
                    l += file.length();
                    l += fileArray[i].length();
                    l += CleanupRunnable.getFileOrDirectorySize(new File(cacheEntry.getNativeLibPath()));
                    boolean bl = true;
                    String string2 = cacheEntry.getURL().toLowerCase();
                    CleanupRunnable cleanupRunnable = this;
                    synchronized (cleanupRunnable) {
                        if (string2.endsWith(".jnlp") || string2.endsWith(".jarjnlp") || cacheEntry.getIsShortcutImage() == 1 || MemoryCache.contains(cacheEntry.getURL()) || this.loadedResourceList.contains(cacheEntry.getURL()) || cacheEntry.getBusy() == 1) {
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    if (string2.endsWith(".jar") || string2.endsWith(".jarjar") || string2.endsWith(".zip")) {
                        if (this.jarItemRemovalList.contains(fileArray[i].getPath())) continue;
                        this.jarItemRemovalList.add(fileArray[i].getPath());
                        continue;
                    }
                    if (this.nonJarItemRemovalList.contains(fileArray[i].getPath())) continue;
                    this.nonJarItemRemovalList.add(fileArray[i].getPath());
                    continue;
                }
                cacheEntry = new CacheEntry(file);
                if (CleanupRunnable.checkBusy(cacheEntry)) continue;
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                if (!fileArray[i].delete()) {
                    fileArray[i].deleteOnExit();
                }
                CleanupRunnable.deleteFileOrDirectory(new File(string + "-n"));
                continue;
            }
            if (fileArray[i].delete()) continue;
            fileArray[i].deleteOnExit();
        }
        return l;
    }

    private static File[] getCacheResourceFiles() {
        File file = Cache.getCacheDir();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < 64; ++i) {
            File file2 = new File(file.getPath() + File.separator + i);
            if (!file2.exists() || !file2.isDirectory()) continue;
            File[] fileArray = file2.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String string = file.getName().toLowerCase();
                    return !string.endsWith(".idx") && !string.endsWith(".lap") && !string.endsWith(".ico") && !string.endsWith("-temp");
                }
            });
            for (int j = 0; j < fileArray.length; ++j) {
                arrayList.add(fileArray[j]);
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static long getFileOrDirectorySize(File file) {
        long l = 0L;
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    l += CleanupRunnable.getFileOrDirectorySize(fileArray[i]);
                }
            } else {
                l += file.length();
            }
        }
        return l;
    }

    private static void deleteFileOrDirectory(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    CleanupRunnable.deleteFileOrDirectory(fileArray[i]);
                }
            }
            file.delete();
        }
    }

    private Object[] prepareRemovalList(ArrayList<String> arrayList) {
        ArrayList<CacheEntry> arrayList2 = new ArrayList<CacheEntry>();
        for (String objectArray2 : arrayList) {
            File file = new File(objectArray2 + ".idx");
            if (!file.exists()) continue;
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile(file);
            arrayList2.add(cacheEntry);
        }
        Object[] objectArray = (CacheEntry[])arrayList2.toArray();
        Arrays.sort(objectArray, new Comparator<CacheEntry>(){

            @Override
            public int compare(CacheEntry cacheEntry, CacheEntry cacheEntry2) {
                if (cacheEntry.removeBefore(cacheEntry2)) {
                    return -1;
                }
                if (cacheEntry2.removeBefore(cacheEntry)) {
                    return 1;
                }
                return 0;
            }
        });
        return objectArray;
    }

    private void removeResourceFromList(Object[] objectArray) {
        long l = (long)((double)this.currentCacheMaxSize * 0.98);
        for (int i = 0; i < objectArray.length && this.currentCacheSize >= l; ++i) {
            CacheEntry cacheEntry = (CacheEntry)objectArray[i];
            long l2 = cacheEntry.getIndexFile().length() + new File(cacheEntry.getResourceFilename()).length() + CleanupRunnable.getFileOrDirectorySize(new File(cacheEntry.getNativeLibPath()));
            Cache.removeCacheEntry(cacheEntry);
            this.currentCacheSize -= l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    CleanupRunnable cleanupRunnable = this;
                    synchronized (cleanupRunnable) {
                        this.wait();
                    }
                    long l = SystemUtils.microTime();
                    Object object = this.syncObject;
                    synchronized (object) {
                        if (this.initCacheSize) {
                            this.currentCacheSize = this.getCurrentCacheSize();
                            this.initCacheSize = false;
                        }
                        if (this.currentCacheMaxSize != -1L && this.currentCacheSize >= this.currentCacheMaxSize) {
                            Object[] objectArray = this.prepareRemovalList(this.nonJarItemRemovalList);
                            this.removeResourceFromList(objectArray);
                            objectArray = this.prepareRemovalList(this.jarItemRemovalList);
                            this.removeResourceFromList(objectArray);
                        }
                    }
                    long l2 = SystemUtils.microTime() - l;
                    Trace.println(ResourceManager.getString("console.trace.plugin.applet.cleanup") + l2 + " us", TraceLevel.NETWORK);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static boolean checkBusy(CacheEntry cacheEntry) {
        CacheEntry cacheEntry2;
        Object object = MemoryCache.getLoadedResource(cacheEntry.getURL());
        CacheEntry cacheEntry3 = cacheEntry2 = object instanceof CacheEntry ? (CacheEntry)object : null;
        if (cacheEntry.isSameEntry(cacheEntry2)) {
            return true;
        }
        if (cacheEntry.getBusy() == 1) {
            long l = cacheEntry.getIndexFile().lastModified();
            if (System.currentTimeMillis() - l < 3600000L) {
                return true;
            }
        }
        return false;
    }
}

