/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.DeployCacheRequest;
import com.sun.deploy.cache.DeployCacheResponse;
import com.sun.deploy.cache.DeploySecureCacheResponse;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.BasicHttpRequest;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeployCacheHandler
extends ResponseCache {
    private final HashMap<URI, Object> inProgress = new HashMap();
    private ThreadLocal<Boolean> inCacheHandler = new ThreadLocal();
    static final AccessControlContext ACC_FILE_INSTANCE;

    public static void reset() {
        ResponseCache.setDefault(new DeployCacheHandler());
        URLUtil.clearPack200Original();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfInternalLocksInUse() {
        HashMap<URI, Object> hashMap = this.inProgress;
        synchronized (hashMap) {
            return this.inProgress.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CacheResponse get(URI uRI, String string, final Map<String, List<String>> map) throws IOException {
        Object object;
        if (DownloadEngine.haveDownloadInProgress()) {
            return null;
        }
        CacheResponse cacheResponse = null;
        if (!Cache.isCacheEnabled()) return null;
        if (!string.equals("GET")) return null;
        if (this.inCacheHandler.get() != null) {
            return null;
        }
        Object object2 = this.inProgress;
        synchronized (object2) {
            if (!this.inProgress.containsKey(uRI)) {
                this.inProgress.put(uRI, new Object());
            }
            object = this.inProgress.get(uRI);
        }
        object2 = object;
        synchronized (object2) {
            try {
                Map<String, List<String>> map2;
                this.inCacheHandler.set(Boolean.TRUE);
                Serializable serializable = null;
                URL uRL = URLUtil.getPack200Original(uRI.toURL());
                final boolean bl = uRL != null;
                final URL uRL2 = bl ? uRL : uRI.toURL();
                final URL uRL3 = HttpUtils.removeQueryStringFromURL(uRL2);
                final String string2 = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL3);
                boolean bl2 = false;
                int n = 1;
                if (bl) {
                    n = 4352;
                }
                if (!DeployOfflineManager.isGlobalOffline() && UpdateTracker.isUpdateCheckNeeded(uRL2.toString())) {
                    bl2 = ResourceProvider.get().isUpdateAvailable(uRL2, string2, n, map);
                }
                if (!bl2) {
                    try {
                        serializable = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                            @Override
                            public File run() throws IOException {
                                URL uRL = string2 == null ? uRL2 : uRL3;
                                return DeployCacheHandler.this.getCacheFile(uRL, string2, map, bl);
                            }
                        }, ACC_FILE_INSTANCE);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Trace.ignoredException(privilegedActionException);
                    }
                }
                if (serializable == null) {
                    CacheResponse privilegedActionException = null;
                    return privilegedActionException;
                }
                InputStream cacheResponse2 = null;
                final File hashMap = serializable;
                if (hashMap == null) return cacheResponse;
                try {
                    cacheResponse2 = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            return new FileInputStream(hashMap);
                        }
                    }, ACC_FILE_INSTANCE);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Trace.ignoredException(privilegedActionException);
                }
                if (cacheResponse2 == null) return cacheResponse;
                Resource resource = ResourceProvider.get().getCachedResource(string2 == null ? uRL2 : uRL3, string2);
                Map<String, List<String>> map3 = map2 = resource != null ? resource.getHeaders() : null;
                cacheResponse = uRI.getScheme().equals("https") ? new DeploySecureCacheResponse(cacheResponse2, map2) : new DeployCacheResponse(cacheResponse2, map2);
            }
            finally {
                this.inCacheHandler.set(null);
                HashMap<URI, Object> hashMap = this.inProgress;
                synchronized (hashMap) {
                    this.inProgress.remove(uRI);
                }
            }
            return cacheResponse;
        }
    }

    private File getCacheFile(URL uRL, String string, Map<String, List<String>> map, boolean bl) {
        CacheEntry cacheEntry = Cache.getCacheEntry(uRL, string);
        boolean bl2 = ResourceProvider.get().isInternalUse();
        if (cacheEntry != null && cacheEntry.isJarFile()) {
            if (bl2 || bl) {
                if (cacheEntry.hasCompressEncoding()) {
                    cacheEntry = null;
                }
            } else if (cacheEntry.hasCompressEncoding()) {
                if (!HttpUtils.matchEncoding(null, map, cacheEntry.getHeaders())) {
                    cacheEntry = null;
                }
            } else if (!cacheEntry.hasCompressEncoding() && HttpUtils.refusesIdentityEncodings(map)) {
                cacheEntry = null;
            }
        }
        if (cacheEntry != null) {
            return new File(cacheEntry.getResourceFilename());
        }
        return null;
    }

    static boolean isResourceCacheable(String string, URLConnection uRLConnection) {
        if (!uRLConnection.getUseCaches() && !DownloadEngine.isAlwaysCached(string)) {
            return false;
        }
        if (uRLConnection instanceof HttpURLConnection && !((HttpURLConnection)uRLConnection).getRequestMethod().equals("GET")) {
            return false;
        }
        try {
            MessageHeader messageHeader = BasicHttpRequest.initializeHeaderFields(uRLConnection);
            return HttpUtils.isResourceCacheable(string, messageHeader, true);
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            return false;
        }
    }

    @Override
    public CacheRequest put(URI uRI, URLConnection uRLConnection) throws IOException {
        if (DownloadEngine.haveDownloadInProgress()) {
            return null;
        }
        if (!DeployCacheHandler.isResourceCacheable(uRI.toString(), uRLConnection)) {
            return null;
        }
        URL uRL = URLUtil.getPack200Original(uRI.toURL());
        boolean bl = false;
        if (uRL != null) {
            bl = true;
        }
        URL uRL2 = bl ? uRL : uRI.toURL();
        return new DeployCacheRequest(uRL2, uRLConnection, bl);
    }

    static {
        Permissions permissions = new Permissions();
        FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write,delete");
        ((PermissionCollection)permissions).add(new RuntimePermission("accessDeclaredMembers"));
        ((PermissionCollection)permissions).add(filePermission);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }
}

