/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.net.URL;

public class JfxRuntime {
    private final String version;
    private final VersionID versionId;
    private final String path;
    private final String home;
    private final boolean isFX2;
    private static final String RT_JAR = "jfxrt.jar";

    protected static JfxRuntime runtimeForJRE(File file, String string) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        if (string.startsWith("1.7")) {
            string2 = JfxRuntime.noDash(string.replaceFirst("1.7", "2.2"));
            string3 = file + File.separator + "lib" + File.separator;
            bl = true;
        } else if (string.startsWith("1.8")) {
            string2 = JfxRuntime.noDash(string);
            string3 = file + File.separator + "lib" + File.separator + "ext" + File.separator;
        } else if (string.startsWith("9") || string.startsWith("10")) {
            string2 = JfxRuntime.noDash(string);
            string3 = null;
        }
        if (string3 != null) {
            if (new File(string3 + RT_JAR).exists()) {
                return new JfxRuntime(string2, file.toString(), string3, bl);
            }
        } else if (string2 != null && new File(file + File.separator + "lib" + File.separator + "javafx.properties").exists()) {
            return new JfxRuntime(string2, file.toString(), null, false);
        }
        return null;
    }

    private static String noDash(String string) {
        int n = string.indexOf("-");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private JfxRuntime(String string, String string2, String string3, boolean bl) {
        this.version = string;
        String string4 = this.home = string2.endsWith(File.separator) ? string2 : string2 + File.separator;
        this.path = string3 == null ? null : (string3.endsWith(File.separator) ? string3 : string3 + File.separator);
        this.versionId = new VersionID(string);
        this.isFX2 = bl;
    }

    public String getJfxJarPath() {
        return this.path + RT_JAR;
    }

    public URL getFX2URL() {
        try {
            File file;
            if (this.isFX2 && (file = new File(this.path + RT_JAR)).exists()) {
                return file.getCanonicalFile().toURI().toURL();
            }
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        return null;
    }

    public File getHome() {
        return new File(this.home);
    }

    public VersionID getProductVersion() {
        return this.versionId;
    }

    public String toString() {
        return "JavaFX " + this.version + " at: " + this.path;
    }
}

