/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.association.utility.WinRegistryWrapper;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.nativesandbox.IntegrityProcess;
import com.sun.deploy.nativesandbox.NativeSandboxBroker;
import com.sun.deploy.nativesandbox.NativeSandboxBrokerImpl;
import com.sun.deploy.nativesandbox.NativeSandboxJNLPService;
import com.sun.deploy.net.proxy.NSPreferences;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemPropertyUtil;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.WinRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;

public final class WinPlatform
extends Platform {
    private static final String SYSTEM_CONFIG_FILE_NAME = "\\Oracle\\Java\\java.settings.cfg";
    private static final String SPONSORS_KEY = "SPONSORS";
    private static final String SPONSORS_DISABLED_VALUE = "0";
    private String _userHome;
    private String _userHomeLocal;
    private String _userHomeRoaming;
    private String _systemHome;
    private String _osHome;
    private String _systemExeHome;
    private final Object sandboxLock = new Object();
    private boolean runInNativeSandbox = false;
    private boolean runInNativeSandboxIsSet = false;
    private long sandboxNativeWindowHandle = 0L;
    private static boolean _loaded = false;
    public static final String JRE_SUBKEY = "SOFTWARE\\JavaSoft\\JRE";
    private static final String OLD_JRE_SUBKEY = "SOFTWARE\\JavaSoft\\Java Runtime Environment";
    private static final String DEPLOYMENT_SUBKEY = "SOFTWARE\\JavaSoft\\Java Web Start";
    private static final String DEPLOYMENT_CACHE_UPGRADE_SUBKEY = "SOFTWARE\\JavaSoft\\Java Web Start\\Cache Upgrade";
    private static final String JAVA_HOME = "JavaHome";
    private static final String DEPLOYMENT_PROP_SUBKEY = "SOFTWARE\\JavaSoft\\DeploymentProperties";
    private static String SUN_JAVA_DEPLOYMENT = "Sun" + File.separator + "Java" + File.separator + "Deployment";
    private Process nativeSandboxProcess = null;
    private static final int[] DEFAULT_SIZES = new int[]{32, 16, 48, 64};
    private static final String SECURITY_BASELINE_SUBKEY = "SOFTWARE\\JavaSoft\\JRE\\Security Baseline";
    private static final int MAX_NAME_LENGTH = 2048;
    private WinWebJavaSwitch javaSwitch = new WinWebJavaSwitch();

    public WinPlatform() {
        this.loadDeployNativeLib();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDeployNativeLib() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (_loaded) {
                return;
            }
            String string = Environment.getDeploymentHome() + File.separator + "bin" + File.separator;
            String string2 = string + BuiltInProperties.getProperty("MSVCR_DLL_NAME");
            try {
                if (new File(string2).exists()) {
                    String string3;
                    System.load(string2);
                    String string4 = BuiltInProperties.getProperty("MSVCP_DLL_NAME");
                    if (!string4.isEmpty() && new File(string3 = string + string4).exists()) {
                        System.load(string3);
                    }
                } else {
                    string2 = string + "msvcr71.dll";
                    System.load(string2);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Trace.ignored(unsatisfiedLinkError);
            }
            try {
                System.load(string + "deploy.dll");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Trace.ignored(unsatisfiedLinkError);
            }
            _loaded = true;
        }
    }

    @Override
    public String getNativeLibPath() {
        return "bin" + File.separator + "deploy.dll";
    }

    @Override
    public void resetJavaHome() {
        String string;
        String string2 = WinRegistry.getString(-2147483646, JRE_SUBKEY, "CurrentVersion");
        if (string2 != null && (string = WinRegistry.getString(-2147483646, "SOFTWARE\\JavaSoft\\JRE\\" + string2, JAVA_HOME)) != null) {
            Trace.println("_javaHome set to: " + string, TraceLevel.NETWORK);
            Environment.setJavaHome(string);
        }
    }

    @Override
    public String getSecureLauncherName() {
        return "jweblauncher.exe";
    }

    @Override
    void setDefaultConfigProperties(DefaultConfig defaultConfig) {
        defaultConfig.setProperty("deployment.system.tray.icon", "false");
    }

    public String escapeBackslashAndQuoteString(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    @Override
    public String getPlatformNativeEncoding() {
        return "UTF-16LE";
    }

    private String getPendingDeploymentPropSubKey() {
        return "SOFTWARE\\JavaSoft\\DeploymentProperties\\pending";
    }

    private String getDeploymentPropSubKey() {
        return DEPLOYMENT_PROP_SUBKEY;
    }

    @Override
    long getUserDeploymentPropCacheTimestamp() {
        String string = WinRegistryWrapper.WinRegQueryValueEx(-2147483647, this.getDeploymentPropSubKey(), "deployment.modified.timestamp");
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.ignored(numberFormatException);
            return -1L;
        }
    }

    @Override
    long getSysDeploymentPropCacheTimestamp() {
        String string = WinRegistryWrapper.WinRegQueryValueEx(-2147483646, "SOFTWARE\\Oracle\\JavaDeploy", "deployment.modified.timestamp");
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.ignored(numberFormatException);
            return -1L;
        }
    }

    @Override
    public synchronized String getUserHome() {
        if (this._userHome == null) {
            File file;
            Object object;
            Object object2 = SystemPropertyUtil.getProperty("javaplugin.user.profile");
            if (object2 == null || ((String)object2).trim().equals("")) {
                object = this.getPlatformUserHome();
                object2 = object != null ? object : SystemPropertyUtil.getProperty("user.home");
            }
            this._userHome = (String)object2 + (((String)object2).endsWith(File.separator) ? "" : File.separator) + SUN_JAVA_DEPLOYMENT;
            object = new File(this._userHome);
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            if (!(file = new File(this._userHome + File.separator + "log")).exists()) {
                file.mkdirs();
            }
            this.verifyPermissionsForFileSystem((File)object, file);
        }
        return this._userHome;
    }

    @Override
    public String getLocalStorageDir() {
        String string;
        String string2;
        if (this._userHomeLocal == null && (string2 = System.getProperty("os.name").toLowerCase()).startsWith("windows xp") && (string = WinRegistryWrapper.WinRegQueryValueEx(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Local AppData")) != null) {
            this._userHomeLocal = string + File.separator + SUN_JAVA_DEPLOYMENT;
        }
        if (this._userHomeLocal == null) {
            this._userHomeLocal = this.getUserHome();
        }
        return this._userHomeLocal;
    }

    @Override
    public String getRoamingUserHome() {
        String string;
        if (this._userHomeRoaming == null && (string = this.getPlatformRoamingUserDir()) != null) {
            String string2 = string + (string.endsWith(File.separator) ? "" : File.separator) + SUN_JAVA_DEPLOYMENT;
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (WinPlatform.isLowIntegrityPath(string2) && !WinPlatform.setMediumIntegrityLabel(string2)) {
                Trace.println("setMediumIntegrityLabel() for " + string2 + " failed", TraceLevel.BASIC);
            }
            this._userHomeRoaming = string2;
        }
        return this._userHomeRoaming;
    }

    @Override
    public String getDefaultSystemCache() {
        return this.getLocalStorageDir() + File.separator + "SystemCache";
    }

    @Override
    public String getSystemHome() {
        if (this._systemHome == null) {
            this._systemHome = this.getPlatformSystemHome() + File.separator + "Sun" + File.separator + "Java" + File.separator + "Deployment";
        }
        return this._systemHome;
    }

    @Override
    public String getOSHome() {
        if (this._osHome == null) {
            this._osHome = this.getPlatformSystemHome();
        }
        return this._osHome;
    }

    private static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    @Override
    public String getSystemJavawsPath() {
        String string;
        File file;
        if (this._systemExeHome == null) {
            this._systemExeHome = this.getSystemExecutableHome();
        }
        if ((file = new File(string = this._systemExeHome + File.separator + "javaws.exe")).exists()) {
            return file.getPath();
        }
        return Environment.getJavawsCommand();
    }

    public long getSysStartupTime() {
        return System.currentTimeMillis() - this.getSysTickCount();
    }

    @Override
    public String getPlatformExtension() {
        return ".exe";
    }

    @Override
    public String toExecArg(String string) {
        return "\"" + string + "\"";
    }

    @Override
    public String getLibraryPrefix() {
        return "";
    }

    @Override
    public String getLibrarySufix() {
        return ".dll";
    }

    @Override
    public boolean useAltFileSystemView() {
        return true;
    }

    @Override
    public boolean systemLookAndFeelDefault() {
        return true;
    }

    @Override
    public String getPlatformSpecificJavaName() {
        return "javaw.exe";
    }

    @Override
    public String getSessionSpecificString() {
        return "-" + System.getProperty("os.arch");
    }

    @Override
    public String getDebugJavaPath(String string) {
        return string.substring(0, string.lastIndexOf(".")).concat(".exe");
    }

    @Override
    public String getMozillaUserProfileDirectory() {
        String string = WinRegistry.getString(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "AppData");
        String string2 = null;
        if (string != null) {
            try {
                File file = new File(string + "\\Mozilla\\registry.dat");
                if (file.exists()) {
                    string2 = NSPreferences.getNS6UserProfileDirectory(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    private static native boolean isLowIntegrityPath(String var0);

    private static native boolean isMediumIntegrityPath(String var0);

    private static native boolean setLowIntegrityLabel(String var0);

    private static native boolean setMediumIntegrityLabel(String var0);

    public void verifyPermissionsForFileSystem(File file, File file2) {
        if (WinPlatform.isLowIntegrityPath(file.getAbsolutePath()) && !WinPlatform.setMediumIntegrityLabel(file.getAbsolutePath())) {
            Trace.println("setMediumIntegrityLabel() failed", TraceLevel.BASIC);
        }
        if (WinPlatform.isMediumIntegrityPath(file2.getAbsolutePath()) && !WinPlatform.setLowIntegrityLabel(file2.getAbsolutePath())) {
            Trace.println("setMediumIntegrityLabel() failed", TraceLevel.BASIC);
        }
    }

    private native long prepareWaitForProcessToValidateParent();

    private native void waitForProcessToValidateParent(long var1);

    @Override
    public Process startProcessBuilder(ProcessBuilder processBuilder) throws IOException {
        Process process;
        boolean bl = false;
        long l = 0L;
        List<String> list = processBuilder.command();
        if (this.runInNativeSandbox) {
            bl = true;
        } else {
            for (int i = 1; i < list.size(); ++i) {
                String string = list.get(i);
                if (!string.equals("-ta") && !string.equals("-javaws") && !string.equals("-checkParent")) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            l = this.prepareWaitForProcessToValidateParent();
        }
        if (this.runInNativeSandbox) {
            process = IntegrityProcess.getIntegrityProcess(list);
        } else {
            WinPlatform.validateProcessBuilder(processBuilder.command());
            process = processBuilder.start();
        }
        if (bl) {
            this.waitForProcessToValidateParent(l);
        }
        if (this.runInNativeSandbox) {
            this.nativeSandboxProcess = process;
        }
        return process;
    }

    @Override
    public void checkAndUpdateSandboxWindow(boolean bl) {
        if (bl || this.runInNativeSandboxIsSet && this.runInNativeSandbox && this.sandboxNativeWindowHandle != 0L) {
            this.UpdateSandboxWindow(this.sandboxNativeWindowHandle);
            this.runInNativeSandboxIsSet = false;
            this.sandboxNativeWindowHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRunInNativeSandbox(boolean bl) {
        Object object = this.sandboxLock;
        synchronized (object) {
            if (bl) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                IntegrityProcess.setClassLoader(classLoader);
            }
            this.runInNativeSandbox = bl;
            this.runInNativeSandboxIsSet = true;
            this.checkAndUpdateSandboxWindow(false);
        }
    }

    @Override
    public boolean getRunInNativeSandbox() {
        return this.runInNativeSandbox;
    }

    @Override
    public boolean isNativeSandbox() {
        return IntegrityProcess.getIntegrityLevel() == 1;
    }

    @Override
    public boolean getUseNativeSandboxWindow() {
        return Config.useNativeSandbox(null);
    }

    private native long CreateSandboxParentWindow0(long var1);

    private native void UpdateSandboxWindow(long var1);

    private native void RunSandboxWindowLoop();

    private long CreateSandboxParentWindow(final long l) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = WinPlatform.this.sandboxLock;
                synchronized (object) {
                    WinPlatform.this.sandboxNativeWindowHandle = WinPlatform.this.CreateSandboxParentWindow0(l);
                }
                countDownLatch.countDown();
                WinPlatform.this.RunSandboxWindowLoop();
            }
        };
        thread.setDaemon(true);
        thread.start();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Trace.ignored(interruptedException);
        }
        return this.sandboxNativeWindowHandle;
    }

    @Override
    public long createNativeWindowSandboxHandle(long l) {
        return this.CreateSandboxParentWindow(l);
    }

    private native void setNativeSandboxWindowSize0(long var1, int var3, int var4);

    @Override
    public void setNativeSandboxWindowSize(long l, int n, int n2) {
        this.setNativeSandboxWindowSize0(l, n, n2);
    }

    private synchronized boolean initNativeSandboxBroker() {
        if (this.sandboxBroker == null) {
            String string = SystemUtils.priviledgedGetSystemProperty("NSBRP");
            if (string == null) {
                return false;
            }
            long l = Long.parseLong(string);
            string = SystemUtils.priviledgedGetSystemProperty("NSBWP");
            if (string == null) {
                return false;
            }
            long l2 = Long.parseLong(string);
            this.sandboxBroker = new NativeSandboxBrokerImpl(l, l2);
        }
        return true;
    }

    @Override
    public NativeSandboxBroker getNativeSandboxBroker() {
        if (this.isNativeSandbox()) {
            if (this.initNativeSandboxBroker()) {
                return this.sandboxBroker;
            }
            return null;
        }
        return super.getNativeSandboxBroker();
    }

    @Override
    public void setNativeSandboxJNLPService(NativeSandboxJNLPService nativeSandboxJNLPService) {
        NativeSandboxBrokerImpl.setNativeSandboxJNLPService(nativeSandboxJNLPService);
    }

    @Override
    public void addParentWindow(int n, long l) {
        NativeSandboxBrokerImpl.addParentWindow(n, l);
    }

    @Override
    public void waitForNativeSandboxProcess() {
        if (this.nativeSandboxProcess != null) {
            try {
                this.nativeSandboxProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.nativeSandboxProcess = null;
        }
    }

    private static native boolean isScreenLockedNative();

    @Override
    public boolean isScreenLocked() {
        boolean bl = WinPlatform.isScreenLockedNative();
        if (DEBUG) {
            Trace.println("WinPlatform:isScreenLocked() result: " + bl);
        }
        return bl;
    }

    @Override
    public String getFireFoxUserProfileDirectory() {
        String string = WinRegistry.getString(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "AppData");
        String string2 = null;
        if (string != null) {
            try {
                File file = new File(string + "\\Mozilla\\Firefox\\profiles.ini");
                if (file.exists()) {
                    string2 = NSPreferences.getFireFoxUserProfileDirectory(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    @Override
    public boolean canAutoDownloadJRE() {
        return this.canBecomeAdmin();
    }

    @Override
    public int[] getIconSizes() {
        return (int[])DEFAULT_SIZES.clone();
    }

    @Override
    public int getSystemShortcutIconSize(boolean bl) {
        if (bl) {
            int n = this.getDesktopIconSize();
            if (n >= 16 && n <= 64) {
                return n;
            }
            return 48;
        }
        return 16;
    }

    @Override
    public List<JREInfo> getInstalledJREList() {
        ArrayList<JREInfo> arrayList = new ArrayList<JREInfo>();
        this.extractInstalledJREListForRegistryView(arrayList, true);
        this.extractInstalledJREListForRegistryView(arrayList, false);
        return arrayList;
    }

    private void extractInstalledJREListForRegistryView(List<JREInfo> list, boolean bl) {
        int n = bl ? 512 : 256;
        for (String string : new String[]{JRE_SUBKEY, OLD_JRE_SUBKEY}) {
            String string2;
            int n2 = 0;
            while ((string2 = WinRegistryWrapper.WinRegEnumKeyEx(-2147483646, string, n2, 255, 0x20019 | n)) != null) {
                String string3 = WinRegistryWrapper.WinRegQueryValueEx(-2147483646, string + "\\" + string2, JAVA_HOME, 0x20019 | n);
                JREInfo jREInfo = new JREInfo(null, string2, null, string3 != null ? string3 : "", "", Config.getOSName(), bl ? "x86" : "x86_64", true, true);
                list.add(jREInfo);
                ++n2;
            }
        }
    }

    @Override
    public String getUserHomeOverride() {
        return Environment.getenv("USERPROFILE");
    }

    @Override
    public void setUserHomeOverride(String string) {
        Properties properties = System.getProperties();
        properties.put("user.home", string);
    }

    @Override
    public boolean samePaths(String string, String string2) {
        try {
            return new File(string.toLowerCase()).getCanonicalPath().equals(new File(string2.toLowerCase()).getCanonicalPath());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public long getNativePID() {
        return this.getPlatformPID();
    }

    @Override
    public boolean isLocalInstallSupported() {
        return true;
    }

    @Override
    public boolean isPlatformIconType(String string) {
        return string.toLowerCase().endsWith(".ico");
    }

    @Override
    public void storeCacheUpgradeInfo(Properties properties) {
        if (properties == null) {
            WinRegistry.deleteKey(-2147483646, DEPLOYMENT_CACHE_UPGRADE_SUBKEY);
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            WinRegistry.setStringValue(-2147483646, DEPLOYMENT_CACHE_UPGRADE_SUBKEY, string, string2);
        }
    }

    @Override
    public Properties getCacheUpgradeInfo(String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = WinRegistry.getString(-2147483646, DEPLOYMENT_CACHE_UPGRADE_SUBKEY, stringArray[i]);
            if (string == null) continue;
            properties.setProperty(stringArray[i], string);
        }
        return properties;
    }

    @Override
    public boolean getSponsorOffersDisabledSettings() {
        Properties properties = this.readSystemConfig();
        return SPONSORS_DISABLED_VALUE.equals(properties.getProperty(SPONSORS_KEY));
    }

    @Override
    public void enableSponsorOffering(boolean bl) {
        this.enableSponsorOfferingImpl(bl);
    }

    @Override
    public void enableRoamingProfile(boolean bl) {
        File file = new File(Config.getRoamingUserPropertiesFile());
        File file2 = new File(Config.getUserPropertiesFile());
        File file3 = new File(file2.getParentFile(), "security");
        File file4 = new File(file.getParentFile(), "security");
        try {
            if (bl && !file.exists()) {
                if (file2.exists()) {
                    file.getParentFile().mkdirs();
                    Cache.copyFile(file2, file);
                } else {
                    file.createNewFile();
                }
                if (file3.exists()) {
                    WinPlatform.copyDirIgnoresErrors(file3, file4);
                }
                Config.getExceptionSitesFile().getParentFile().mkdirs();
            }
            if (!bl && file.exists()) {
                file2.getParentFile().mkdirs();
                Cache.copyFile(file, file2);
                file.delete();
                if (file4.exists()) {
                    WinPlatform.copyDirIgnoresErrors(file4, file3);
                }
            }
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
    }

    protected static void copyDirIgnoresErrors(File file, File file2) {
        if (file.isDirectory()) {
            file2.mkdirs();
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = fileArray[i];
                File file4 = new File(file2, file3.getName());
                if (fileArray[i].isDirectory()) continue;
                try {
                    Cache.copyFile(file3, file4);
                    continue;
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
        }
    }

    private native void enableSponsorOfferingImpl(boolean var1);

    private Properties readSystemConfig() {
        File file = new File(this.getPlatformCommonAppDir() + SYSTEM_CONFIG_FILE_NAME);
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.ignored(fileNotFoundException);
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        return properties;
    }

    @Override
    public void cacheSecurityBaseline(String string, String string2) {
        if (string != null && string2 != null && WinRegistryWrapper.WinRegCreateNoReflectionKey(-2147483647, SECURITY_BASELINE_SUBKEY) == 0) {
            WinRegistryWrapper.WinRegSetValueEx(-2147483647, SECURITY_BASELINE_SUBKEY, string, string2);
        }
    }

    @Override
    public String getJucheckPath() {
        String string = WinRegistry.getString(-2147483646, "Software\\Microsoft\\Windows\\CurrentVersion", "CommonFilesDir (x86)");
        if (string == null) {
            string = WinRegistry.getString(-2147483646, "Software\\Microsoft\\Windows\\CurrentVersion", "CommonFilesDir");
        }
        return string + File.separator + "Java" + File.separator + "Java Update" + File.separator + "jucheck.exe";
    }

    @Override
    public Properties getPendingConfigProperties() {
        int n = 0;
        String string = WinRegistryWrapper.WinRegEnumValue(-2147483647, this.getPendingDeploymentPropSubKey(), n, 2048);
        Properties properties = null;
        while (string != null) {
            String string2 = WinRegistryWrapper.WinRegQueryValueEx(-2147483647, this.getPendingDeploymentPropSubKey(), string);
            if (properties == null) {
                properties = new Properties();
            }
            properties.put(string, string2);
            string = WinRegistryWrapper.WinRegEnumValue(-2147483647, this.getPendingDeploymentPropSubKey(), ++n, 2048);
        }
        return properties;
    }

    @Override
    public void cacheCurrentConfig(Properties properties) {
        if (Platform.get().isNativeSandbox()) {
            return;
        }
        if (properties == null) {
            return;
        }
        WinRegistryWrapper.WinRegDeleteKey(-2147483647, this.getDeploymentPropSubKey());
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (WinRegistryWrapper.WinRegCreateNoReflectionKey(-2147483647, this.getDeploymentPropSubKey()) != 0) continue;
            WinRegistryWrapper.WinRegSetValueEx(-2147483647, this.getDeploymentPropSubKey(), string, string2);
        }
    }

    @Override
    public Platform.WebJavaSwitch getWebJavaSwitch() {
        return this.javaSwitch;
    }

    @Override
    public boolean isCompatibleArch(String string, String string2) {
        return string.equals(string2) || this.isSystem64Bit() && ("x86".equals(string) || "x86_64".equals(string)) && ("x86".equals(string2) || "x86_64".equals(string2));
    }

    @Override
    public native boolean shouldPromptForAutoCheck();

    @Override
    public native void handleUserResponse(int var1);

    @Override
    public native boolean canBecomeAdmin();

    @Override
    public native boolean hasAdminPrivileges();

    @Override
    public native String getLongPathName(String var1);

    @Override
    public native void onLoad(Object var1);

    @Override
    public native void onSave(Object var1);

    private native long getSysTickCount();

    @Override
    public boolean showDocument(String string) {
        if (IntegrityProcess.getIntegrityLevel() == 1) {
            if (this.initNativeSandboxBroker()) {
                return this.sandboxBroker.showDocument(string);
            }
            return false;
        }
        return super.showDocument(string);
    }

    @Override
    public boolean updateJava(String string) {
        String string2;
        if (IntegrityProcess.getIntegrityLevel() != 1 && (string2 = this.getJucheckPath()) != null && new File(string2).exists()) {
            try {
                try {
                    Runtime.getRuntime().exec(new String[]{string2});
                    return true;
                }
                catch (IOException iOException) {
                    String[] stringArray = new String[]{"cmd", "/c", string2};
                    Runtime.getRuntime().exec(stringArray);
                    return true;
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
        }
        return this.showDocument(string);
    }

    @Override
    public void openControlPanel(String[] stringArray) {
        WinPlatform.nativeOpenControlPanel(stringArray);
    }

    private static native void nativeOpenControlPanel(String[] var0);

    @Override
    public native String getBrowserPath();

    @Override
    public native String getBrowserHomePath();

    @Override
    public native boolean isNativeModalDialogUp();

    @Override
    public native int getPlatformMaxCommandLineLength();

    @Override
    public native int updateShortcut(String var1, String var2);

    @Override
    public native int installShortcut(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    @Override
    public native String getShortcutJnlpName(String var1);

    @Override
    public native void addRemoveProgramsAdd(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    @Override
    public native void addRemoveProgramsRemove(String var1, boolean var2);

    public native boolean isPlatformWindows8orLater();

    @Override
    public native boolean isBrowserFireFox();

    public native boolean isProcessWow64();

    public native boolean isSystem64Bit();

    public native String getPlatformUserHome();

    public native String getPlatformUserLocalDir();

    public native String getPlatformRoamingUserDir();

    public native String getPlatformCommonAppDir();

    private native String getPlatformSystemHome();

    private native String getSystemExecutableHome();

    protected native long getPlatformPID();

    protected native int getDesktopIconSize();

    @Override
    public native String getLoadedNativeLibPath(String var1);

    public static final class WinWebJavaSwitch
    extends Platform.WebJavaSwitch {
        private WinWebJavaSwitch() {
        }

        @Override
        protected boolean isSystemWebJavaEnabled() {
            String string = WinRegistry.getString(-2147483646, "Software\\Oracle\\JavaDeploy", "WebDeployJava");
            return !"disabled".equals(string);
        }

        @Override
        protected void setSystemWebJavaEnabled(boolean bl) {
            this.setSystemWebJavaEnabledImpl(bl);
        }

        private native void setSystemWebJavaEnabledImpl(boolean var1);
    }
}

