/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.net.DownloadException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.JarVerifier;
import java.net.URL;

public class JARSigningException
extends DownloadException {
    private static final long serialVersionUID = 4830540871182803150L;
    private int _code;
    private String _missingEntry;
    private String _weakAlgorithm;
    public static final int MULTIPLE_SIGNERS = 1;
    public static final int BAD_SIGNING = 2;
    public static final int UNSIGNED_FILE = 3;
    public static final int MISSING_ENTRY = 4;
    public static final int BLACKLISTED = 5;
    public static final int WEAK_ALGORITHM = 6;

    public JARSigningException(URL uRL, String string, int n) {
        super(uRL, string);
        this.setCode(n);
    }

    public JARSigningException(URL uRL, String string, int n, String string2) {
        super(uRL, string);
        this.setCode(n);
        this._missingEntry = string2;
    }

    public JARSigningException(URL uRL, String string, int n, Exception exception) {
        super(uRL, string, exception);
        this.setCode(n);
    }

    private void setCode(int n) {
        this._code = n;
        switch (this._code) {
            case 6: {
                this._weakAlgorithm = JarVerifier.getWeakAlgorithmMessage();
            }
        }
    }

    @Override
    public String getRealMessage() {
        switch (this._code) {
            case 1: {
                return ResourceManager.getString("launch.error.jarsigning-multisigners");
            }
            case 2: {
                return ResourceManager.getString("launch.error.jarsigning-badsigning");
            }
            case 3: {
                return ResourceManager.getString("launch.error.jarsigning-unsignedfile");
            }
            case 4: {
                return ResourceManager.getString("launch.error.jarsigning-missingentry") + "\n" + ResourceManager.getString("launch.error.jarsigning-missingentryname", this._missingEntry);
            }
            case 5: {
                return ResourceManager.getString("downloadengine.check.blacklist.found");
            }
            case 6: {
                return this._weakAlgorithm;
            }
        }
        return "<error>";
    }
}

