/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.protocol.https;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.BrowserKeystore;
import com.sun.deploy.security.X509DeployKeyManager;
import com.sun.deploy.security.X509Extended7DeployTrustManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class Handler
extends sun.net.www.protocol.https.Handler {
    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        Initializer.init();
        return super.openConnection(uRL);
    }

    static class Initializer {
        Initializer() {
        }

        static void init() {
        }

        static {
            String string = null;
            try {
                string = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return System.getProperty("https.protocols");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
            if (string == null || string.trim().length() == 0) {
                boolean bl = false;
                for (String string2 : Config.getAllTlsProtocols()) {
                    if (!Config.getBooleanProperty(string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    SecurityException securityException = new SecurityException("No TLS/SSL protocol is enabled.");
                    Trace.println("No TLS/SSL protocol is enabled", TraceLevel.NETWORK);
                    Trace.ignored(securityException);
                    throw securityException;
                }
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
                            BrowserKeystore.registerSecurityProviders();
                        }
                        SecureRandom secureRandom = new SecureRandom();
                        SSLContext sSLContext = SSLContext.getInstance("SSL");
                        X509Extended7DeployTrustManager x509Extended7DeployTrustManager = new X509Extended7DeployTrustManager();
                        TrustManager[] trustManagerArray = new TrustManager[]{x509Extended7DeployTrustManager};
                        X509DeployKeyManager x509DeployKeyManager = new X509DeployKeyManager();
                        KeyManager[] keyManagerArray = new KeyManager[]{x509DeployKeyManager};
                        sSLContext.init(keyManagerArray, trustManagerArray, secureRandom);
                        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
        }
    }
}

