/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.resources;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ResourceManager {
    private static ResourceBundle rb;
    private static final Method transferToMethod;
    static Class<?> _keyEventClazz;

    private static byte[] loadResourceData(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        if (transferToMethod != null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                transferToMethod.invoke((Object)inputStream, byteArrayOutputStream);
            }
            catch (Exception exception) {
                Trace.printException(exception);
            }
        } else {
            int n;
            byte[] byArray = new byte[65536];
            byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
        }
        return byteArrayOutputStream.toByteArray();
    }

    static void reset() {
        rb = ResourceBundle.getBundle("com.sun.deploy.resources.Deployment");
    }

    public static ResourceBundle getResourceBundle() {
        return rb;
    }

    public static String getString(String string) {
        try {
            return ResourceManager.removeMnemonics(rb.getString(string));
        }
        catch (MissingResourceException missingResourceException) {
            ResourceManager.missing(string, missingResourceException);
            return string;
        }
    }

    public static String getString(String string, Object ... objectArray) {
        try {
            return MessageFormat.format(ResourceManager.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            ResourceManager.missing(string, missingResourceException);
            return string;
        }
    }

    public static ImageIcon getIcon(String string) {
        String string2 = ResourceManager.getString(string);
        if (string2 != null) {
            return ResourceManager.getIconResource(string2);
        }
        return null;
    }

    public static InputStream getImageResourceStream(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(47) == -1) {
            string = "image/" + string;
        }
        return ResourceManager.class.getResourceAsStream(string);
    }

    public static Image getImageResource(String string) {
        return ResourceManager.getImageResource(ResourceManager.getImageResourceStream(string));
    }

    public static Image getImageResource(InputStream inputStream) {
        try {
            byte[] byArray = ResourceManager.loadResourceData(inputStream);
            if (byArray != null) {
                return Toolkit.getDefaultToolkit().createImage(byArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        return null;
    }

    public static ImageIcon getIconResource(String string) {
        return new ImageIcon(ResourceManager.getImageResource(string), string);
    }

    public static ImageIcon[] getButtonIcons(String string) {
        ImageIcon[] imageIconArray = new ImageIcon[4];
        String string2 = ResourceManager.getString(string);
        imageIconArray[0] = ResourceManager.getIconResource(string2);
        int n = string2.lastIndexOf(".");
        String string3 = string2;
        String string4 = "";
        if (n > 0) {
            string3 = string2.substring(0, n);
            string4 = string2.substring(n);
        }
        imageIconArray[1] = ResourceManager.getIconResource(string3 + "-p" + string4);
        imageIconArray[2] = ResourceManager.getIconResource(string3 + "-d" + string4);
        imageIconArray[3] = ResourceManager.getIconResource(string3 + "-o" + string4);
        return imageIconArray;
    }

    public static Font getUIFont() {
        return new JLabel().getFont();
    }

    public static int getMinFontSize() {
        int n = 0;
        try {
            n = (Integer)rb.getObject("ui.min.font.size");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return n;
    }

    private static String removeMnemonics(String string) {
        int n = string.indexOf("&");
        int n2 = string.length();
        if (n < 0 || n == n2 - 1) {
            return string;
        }
        int n3 = string.indexOf("&", n + 1);
        if (n3 == n + 1) {
            if (n3 + 1 == n2) {
                return string.substring(0, n);
            }
            return string.substring(0, n) + ResourceManager.removeMnemonics(string.substring(n3 + 1));
        }
        if (n == 0) {
            return ResourceManager.removeMnemonics(string.substring(1));
        }
        return string.substring(0, n) + ResourceManager.removeMnemonics(string.substring(n + 1));
    }

    private static String extractMnemonic(String string) {
        if (string != null) {
            try {
                int n = string.indexOf("&");
                int n2 = string.length();
                if (n < 0 || n == n2 - 1) {
                    return null;
                }
                int n3 = string.indexOf("&", n + 1);
                if (n3 == n + 1) {
                    if (n3 + 1 == n2) {
                        return null;
                    }
                    return ResourceManager.extractMnemonic(string.substring(n3 + 1));
                }
                return string.substring(n + 1, n + 2);
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
        }
        return null;
    }

    public static int getMnemonic(String string) {
        String string2;
        try {
            string2 = rb.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            ResourceManager.missing(string, missingResourceException);
            return 0;
        }
        String string3 = ResourceManager.extractMnemonic(string2);
        if (string3 == null || string3.length() != 1) {
            return 0;
        }
        String string4 = "VK_" + string3.toUpperCase();
        try {
            if (_keyEventClazz == null) {
                _keyEventClazz = Class.forName("java.awt.event.KeyEvent");
            }
            Field field = _keyEventClazz.getDeclaredField(string4);
            int n = field.getInt(null);
            return n;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.ignoredException(classNotFoundException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Trace.ignoredException(noSuchFieldException);
        }
        catch (SecurityException securityException) {
            Trace.ignoredException(securityException);
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
        return 0;
    }

    private static void missing(String string, MissingResourceException missingResourceException) {
        if (!string.endsWith(".tooltip") && string.contains(".") && !string.contains(" ")) {
            Trace.println(missingResourceException.toString(), TraceLevel.UI);
        }
    }

    static {
        Method method = null;
        try {
            method = InputStream.class.getDeclaredMethod("transferTo", OutputStream.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        transferToMethod = method;
        ResourceManager.reset();
        _keyEventClazz = null;
    }
}

