/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.LazyRootStore;
import com.sun.deploy.security.RevocationChecker;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.trace.Trace;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

class RevocationCheckHelper {
    private final CertStore sessionStore;
    private final boolean crlCheck;
    private final boolean ocspCheck;
    private final String ocspSigner;
    private final String ocspURL;
    private final boolean ocspValidConfig;
    private final String revType;
    private final X509CRL crl509;
    private final boolean bestEffort;
    private final String timeout;
    private final String clockSkew;
    private volatile boolean sessionStoreLoaded;
    private final Object sessionStoreLock = new Object();

    RevocationCheckHelper() {
        this.sessionStore = new SessionCertStore("RevocationCheckHelper");
        this.revType = Config.getStringProperty("deployment.security.tls.revocation.check");
        boolean bl = !this.revType.equals("NO_CHECK");
        this.timeout = Config.getStringProperty("deployment.security.tls.validation.timeout");
        this.clockSkew = Config.getStringProperty("deployment.security.tls.validation.clockskew");
        this.crlCheck = bl && Config.getBooleanProperty("deployment.security.tls.validation.crl");
        this.crl509 = this.crlCheck ? RevocationCheckHelper.retrieveCRL(Config.getStringProperty("deployment.security.tls.validation.crl.url")) : null;
        this.ocspCheck = bl && Config.getBooleanProperty("deployment.security.tls.validation.ocsp");
        this.ocspSigner = this.ocspCheck ? Config.getStringProperty("deployment.security.tls.validation.ocsp.signer") : null;
        this.ocspURL = this.ocspCheck ? Config.getStringProperty("deployment.security.tls.validation.ocsp.url") : null;
        this.ocspValidConfig = this.ocspSigner != null && this.ocspSigner.length() > 0 && this.ocspURL != null && this.ocspURL.length() > 0;
        this.bestEffort = SecuritySettings.getManagedBooleanValue("deployment.security.tls.revocation.check.best.effort");
    }

    static X509CRL retrieveCRL(final String string) {
        final X509CRL[] x509CRLArray = new X509CRL[1];
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    if (string != null && string.length() > 0) {
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                        URL uRL = new URL(string);
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setDoInput(true);
                        uRLConnection.setUseCaches(false);
                        try (DataInputStream dataInputStream = null;){
                            dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                            x509CRLArray[0] = (X509CRL)certificateFactory.generateCRL(dataInputStream);
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException);
        }
        return x509CRLArray[0];
    }

    boolean checkRevocationStatus(X509Certificate[] x509CertificateArray, X509Certificate x509Certificate, String string, List<X509Certificate> list, LazyRootStore lazyRootStore, boolean[] blArray, String string2) throws CertificateException {
        try {
            return this.doRevocationCheck(x509CertificateArray, x509Certificate, string, list, lazyRootStore, blArray, string2);
        }
        catch (KeyStoreException keyStoreException) {
            Trace.printException(keyStoreException);
            throw new CertificateException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.printException(noSuchAlgorithmException);
            throw new CertificateException(noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            Trace.printException(iOException);
            throw new CertificateException(iOException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Trace.printException(invalidAlgorithmParameterException);
            throw new CertificateException(invalidAlgorithmParameterException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRevocationCheck(X509Certificate[] x509CertificateArray, X509Certificate x509Certificate, String string, List<X509Certificate> list, LazyRootStore lazyRootStore, boolean[] blArray, String string2) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (!this.ocspCheck && !this.crlCheck) {
            Trace.msgSecurityPrintln("Revocation check disabled");
            return false;
        }
        HashSet<TrustAnchor> hashSet = this.sessionStoreLock;
        synchronized (hashSet) {
            if (!this.sessionStoreLoaded) {
                this.sessionStore.load();
                this.sessionStoreLoaded = true;
            }
            if (this.sessionStore.contains(x509CertificateArray[0], string, false)) {
                return false;
            }
        }
        hashSet = new HashSet<TrustAnchor>(list.size());
        Object object = list.iterator();
        while (object.hasNext()) {
            hashSet.add(new TrustAnchor(object.next(), null));
        }
        object = new PKIXParameters(hashSet);
        ((PKIXParameters)object).setDate(new Date());
        boolean bl = this.doRevocationCheck(x509CertificateArray, x509Certificate, (PKIXParameters)object, blArray, lazyRootStore, string2);
        if (!bl) {
            Object object2 = this.sessionStoreLock;
            synchronized (object2) {
                this.sessionStore.add(x509CertificateArray[0], string, false);
            }
        }
        return bl;
    }

    private boolean doRevocationCheck(X509Certificate[] x509CertificateArray, X509Certificate x509Certificate, PKIXParameters pKIXParameters, boolean[] blArray, LazyRootStore lazyRootStore, String string) throws CertificateException {
        boolean bl = false;
        X509Certificate x509Certificate2 = null;
        if (this.ocspCheck && this.ocspValidConfig) {
            try {
                lazyRootStore.containSubject(this.ocspSigner);
                x509Certificate2 = lazyRootStore.getOCSPCert();
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
        }
        boolean bl2 = this.revType.equals("SERVER_CERTIFICATE_ONLY");
        RevocationChecker revocationChecker = new RevocationChecker(x509Certificate, pKIXParameters, this.ocspCheck, this.crlCheck, this.ocspURL, x509Certificate2, bl2, this.crl509, null, this.timeout, this.clockSkew, string);
        for (int i = x509CertificateArray.length - 1; i >= 0; --i) {
            X509Certificate x509Certificate3 = x509CertificateArray[i];
            try {
                revocationChecker.check(x509Certificate3, blArray[i]);
                continue;
            }
            catch (CertificateException certificateException) {
                if (certificateException instanceof RevocationChecker.StatusUnknownException && this.bestEffort) {
                    bl = true;
                    Trace.msgSecurityPrintln("Revocation Status Unknown");
                    Trace.ignored(certificateException);
                    continue;
                }
                throw certificateException;
            }
        }
        return bl;
    }
}

