/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.ArgumentParsingUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.ManagementPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Set;

public class ParameterUtil {
    private static final AccessControlContext ACC_ARGS_INSTANCE;

    private ParameterUtil() {
    }

    public static boolean hasRunningVMRequiredArgs(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Object object;
                if (string == null) {
                    return true;
                }
                List<Object> list = new LinkedList();
                String string2 = null;
                try {
                    object = ManagementFactory.getRuntimeMXBean();
                    list = object.getInputArguments();
                    string2 = object.getClassPath();
                }
                catch (Throwable throwable) {
                    Trace.ignored(throwable);
                }
                if (list.isEmpty()) {
                    return string.trim().length() == 0;
                }
                object = ArgumentParsingUtil.parseCommandLine(string.trim());
                Set set = ParameterUtil.toVMParameters((List)object);
                Set set2 = ParameterUtil.toVMParameters(list);
                if (string2 != null) {
                    set2.add(ParameterUtil.parseVMParameter("-cp"));
                    set2.add(ParameterUtil.parseVMParameter(string2));
                }
                return set2.containsAll(set);
            }
        }, ACC_ARGS_INSTANCE);
    }

    public static List<String> mergeArgs(List<String> list, List<String> list2, int n) {
        Object object2;
        if (list.isEmpty()) {
            return new LinkedList<String>(list2);
        }
        if (list2.isEmpty()) {
            return new LinkedList<String>(list);
        }
        LinkedHashMap<VMParameter, Object> linkedHashMap = new LinkedHashMap<VMParameter, Object>();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = object3.next().trim();
            VMParameter object4 = ParameterUtil.parseVMParameter((String)object2);
            linkedHashMap.put(object4, object2);
        }
        object3 = list2.iterator();
        while (object3.hasNext()) {
            object2 = object3.next().trim();
            VMParameter vMParameter = ParameterUtil.parseVMParameter((String)object2);
            switch (n) {
                case 0: {
                    linkedHashMap.put(vMParameter, object2);
                    break;
                }
                case 2: {
                    if (linkedHashMap.containsKey(vMParameter)) break;
                    linkedHashMap.put(vMParameter, object2);
                    break;
                }
                case 1: {
                    if (linkedHashMap.containsKey(vMParameter) && Config.isSecureVmArg((String)object2)) break;
                    linkedHashMap.put(vMParameter, object2);
                    break;
                }
            }
        }
        object3 = new LinkedList();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object3.add(entry.getValue());
        }
        return object3;
    }

    private static Set<VMParameter> toVMParameters(List<String> list) {
        HashSet<VMParameter> hashSet = new HashSet<VMParameter>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().trim();
            hashSet.add(ParameterUtil.parseVMParameter(string));
        }
        return hashSet;
    }

    private static VMParameter parseVMParameter(String string) {
        String string2 = string;
        if (string.indexOf(61) > 0) {
            string2 = string.split("=")[0];
        } else if (string.startsWith("-XX:")) {
            string2 = string;
        } else if (string.indexOf(58) > 0) {
            string2 = string.split(":")[0];
        } else if (string.startsWith("-Xms")) {
            string2 = "-Xms";
        } else if (string.startsWith("-Xmx")) {
            string2 = "-Xmx";
        } else if (string.startsWith("-Xss")) {
            string2 = "-Xss";
        }
        return new VMParameter(string2, string);
    }

    static {
        Permissions permissions = new Permissions();
        ((PermissionCollection)permissions).add(new ManagementPermission("monitor"));
        ((PermissionCollection)permissions).add(new PropertyPermission("*", "read"));
        ACC_ARGS_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    public static interface MergeMode {
        public static final int OVERRIDE_ALL = 0;
        public static final int OVERRIDE_INSECURE = 1;
        public static final int NO_OVERRIDE = 2;
    }

    private static class VMParameter {
        private final String key;
        private final String parameter;

        public VMParameter(String string, String string2) {
            this.key = "-classpath".equals(string) ? "-cp" : string;
            this.parameter = string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof VMParameter)) {
                return false;
            }
            if (this.key.startsWith("-Xbootclasspath")) {
                return this.parameter.equals(((VMParameter)object).parameter);
            }
            return this.key.equals(((VMParameter)object).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String getKey() {
            return this.key;
        }

        public String getParameter() {
            return this.parameter;
        }

        public String toString() {
            return "  key: " + this.key + " - parameter: " + this.parameter;
        }
    }
}

