/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.event.AppInitEvent;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ComponentRef;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.HtmlOptions;
import com.sun.javaws.IconUtil;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JreExecException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.OfflineLaunchException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.javaws.progress.Progress;
import com.sun.javaws.security.AppContextUtil;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JNLPSignedResourcesHelper;
import com.sun.javaws.security.JavaWebStartSecurity;
import com.sun.javaws.ui.ApplicationIconGenerator;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.util.JavawsConsoleController;
import com.sun.javaws.util.JfxHelper;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.SingleInstanceServiceImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import sun.awt.AppContext;

public class Launcher
implements Runnable {
    private LaunchDesc _initialLaunchDesc;
    protected LaunchDesc _launchDesc;
    protected String[] _args;
    protected boolean _exit = true;
    private JAuthenticator _ja;
    private LocalApplicationProperties _lap = null;
    private JNLPClassLoader _jnlpClassLoader = null;
    private JREInfo _jreInfo = null;
    private boolean _isRelaunch = false;
    private boolean _isCached = false;
    private boolean _isUpdated = false;
    private boolean _disableCustomPreloader = false;
    boolean securityManagerDiabledForTests = false;
    private boolean _shownDownloadWindow = false;

    public Launcher(LaunchDesc launchDesc) {
        this._initialLaunchDesc = launchDesc;
    }

    public Launcher(LaunchDesc launchDesc, String[] stringArray, boolean bl) {
        this(launchDesc);
        this._args = stringArray;
        this._exit = bl;
    }

    public void launch(String[] stringArray, boolean bl) {
        this._args = stringArray != null ? (String[])stringArray.clone() : null;
        this._exit = bl;
        if (this.checkForSingleInstance()) {
            return;
        }
        if (this.prepareToLaunch()) {
            this.initiateUpdateCheck();
            if (this.useAppletLifecycle()) {
                return;
            }
            new Thread(Main.getLaunchThreadGroup(), this, "javawsApplicationMain").start();
        } else if (!Environment.isImportMode()) {
            LaunchErrorDialog.show(Progress.get(null).getOwner(), new Exception(ResourceManager.getString((String)"launch.error.category.unexpected")), true);
        }
    }

    @Override
    public void run() {
        block9: {
            try {
                this.checkDeprecationWarning(this._launchDesc);
                this.doLaunchApp();
            }
            catch (Throwable throwable) {
                int n;
                ExitException exitException = null;
                Throwable throwable2 = throwable.getCause();
                exitException = throwable2 != null && throwable2 instanceof ExitException ? (ExitException)throwable2 : (throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3));
                int n2 = n = exitException.getReason() == 0 || throwable instanceof BlockedException ? 0 : -1;
                if (n != 0 && this._launchDesc != null && this._launchDesc.isApplication()) {
                    URL uRL = this._launchDesc.getCanonicalHome();
                    SecureStaticVersioning.resetAcceptedVersion((URL)uRL, (AppInfo)this._launchDesc.getAppInfo());
                }
                if (exitException.getReason() == 3) {
                    if (this._launchDesc != null && this._launchDesc.getUpdater().isBackgroundUpdateRunning() && this._lap != null) {
                        this._lap.setForceUpdateCheck(true);
                        try {
                            this._lap.store();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    LaunchErrorDialog.show(Progress.get(null).getOwner(), exitException.getException(), this._exit);
                }
                if (!this._exit) break block9;
                try {
                    Main.systemExit(n);
                }
                catch (ExitException exitException2) {
                    Trace.println((String)("systemExit: " + exitException2), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)exitException2);
                }
            }
        }
    }

    public boolean isImport() {
        return Environment.isImportMode() || this._launchDesc != null && this._launchDesc.isLibrary();
    }

    public LocalApplicationProperties getLap() {
        return this._lap;
    }

    boolean prepareToLaunch() {
        boolean bl = this.tryOffline();
        try {
            if (!bl && DeployOfflineManager.isForcedOffline()) {
                throw new CacheUpdateRequiredException("Forced offline mode!");
            }
            boolean bl2 = this.prepareToLaunch(bl);
            return bl2;
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            return this.handleCacheUpdateRequiredException(cacheUpdateRequiredException, bl);
        }
    }

    private boolean canRelaunch() {
        if (this._isRelaunch) {
            Trace.println((String)"JAVAWS: Relaunch ignored: relaunched already", (TraceLevel)TraceLevel.BASIC);
            return false;
        }
        return true;
    }

    private boolean prepareToLaunch(boolean bl) throws CacheUpdateRequiredException {
        try {
            this.updateLaunchDesc(bl);
            this.prepareAllResources(bl);
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            throw cacheUpdateRequiredException;
        }
        catch (Throwable throwable) {
            this.handleExitException(throwable);
            return false;
        }
        return true;
    }

    public boolean useAppletLifecycle() {
        if (this._launchDesc == null) {
            return false;
        }
        String string = System.getProperty("jnlp.tk");
        boolean bl = "jfx".equals(string);
        boolean bl2 = this._launchDesc.isFXApp();
        boolean bl3 = this._launchDesc.isApplet();
        if (bl2 && bl || !bl2 && bl3) {
            Trace.println((String)("using applet lifecycle because " + (bl ? "using FX Toolkit" : "it is an Applet")), (TraceLevel)TraceLevel.BASIC);
            return true;
        }
        Trace.println((String)"not using applet lifecycle", (TraceLevel)TraceLevel.BASIC);
        return false;
    }

    protected boolean updateFinalLaunchDesc(LaunchDesc launchDesc, int n, boolean bl) throws ExitException, CacheUpdateRequiredException {
        int n2 = ResourceProvider.get().incrementInternalUse();
        try {
            File file;
            URL uRL = launchDesc.getLocation();
            if (uRL == null) {
                this._launchDesc = launchDesc;
                if (launchDesc.getCanonicalHome() == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                LaunchDesc launchDesc2 = LaunchDownload.updateLaunchDescInCache(launchDesc);
                boolean bl3 = launchDesc == launchDesc2;
                return bl3;
            }
            URL uRL2 = this.deriveCodebase(uRL);
            boolean bl4 = SystemUtils.isPathFromCache((String)this._args[0]);
            Resource resource = ResourceProvider.get().getResource(uRL, null, false, 1, null);
            File file2 = file = resource != null ? resource.getDataFile() : null;
            if (!bl && bl4) {
                LaunchDesc launchDesc3 = LaunchDownload.getUpdatedLaunchDesc(uRL, null, false);
                if (launchDesc3 == null) {
                    this._launchDesc = launchDesc;
                    boolean bl5 = false;
                    return bl5;
                }
                URL uRL3 = launchDesc3.getLocation();
                if (uRL3 == null || !uRL3.toString().equals(uRL.toString()) && n == 0) {
                    ResourceProvider.get().markRetired(resource, false);
                    boolean bl6 = this.updateFinalLaunchDesc(launchDesc3, ++n, false);
                    return bl6;
                }
                this._launchDesc = launchDesc3;
                boolean bl7 = true;
                return bl7;
            }
            if (file != null) {
                boolean bl8;
                block39: {
                    bl8 = false;
                    if (!bl) {
                        resource = ResourceProvider.get().getResource(uRL, null, true, 1, null);
                        file = resource != null ? resource.getDataFile() : null;
                        bl8 = true;
                    }
                    try {
                        this._launchDesc = LaunchDescFactory.buildDescriptor(file, uRL2, null, uRL);
                    }
                    catch (LaunchDescException launchDescException) {
                        this._launchDesc = LaunchDescFactory.buildDescriptor(file);
                        if (this._launchDesc != null) break block39;
                        throw launchDescException;
                    }
                }
                LaunchDesc launchDesc4 = null;
                if (!launchDesc.hasIdenticalContent(this._launchDesc)) {
                    if (n == 0 && bl) {
                        throw new CacheUpdateRequiredException("Given JNLP is newer than cached copy!");
                    }
                    Trace.println((String)"Launch copy is different than cached, force update", (TraceLevel)TraceLevel.BASIC);
                    launchDesc4 = LaunchDownload.getUpdatedLaunchDesc(uRL, null, true);
                }
                if (launchDesc4 != null) {
                    this._launchDesc = launchDesc4;
                    URL uRL4 = this._launchDesc.getLocation();
                    if (uRL4 == null || !uRL4.toString().equals(uRL.toString()) && n == 0) {
                        ResourceProvider.get().markRetired(resource, bl);
                        boolean bl9 = this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                        return bl9;
                    }
                    boolean bl10 = true;
                    return bl10;
                }
                if (bl8) {
                    boolean bl11 = true;
                    return bl11;
                }
                Cache.removeRemovedApp((String)uRL.toString(), (String)this._launchDesc.getInformation().getTitle());
                URL uRL5 = this._launchDesc.getLocation();
                if (uRL5 == null || !uRL5.toString().equals(uRL.toString()) && n == 0) {
                    ResourceProvider.get().markRetired(resource, false);
                    boolean bl12 = this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                    return bl12;
                }
                boolean bl13 = false;
                return bl13;
            }
            if (bl) {
                throw new CacheUpdateRequiredException("Missing from the cache: " + uRL);
            }
            if (Cache.isCacheEnabled()) {
                resource = ResourceProvider.get().getResource(uRL, null, true, 1, null);
                File file3 = file = resource != null ? resource.getDataFile() : null;
                if (file != null) {
                    this._launchDesc = LaunchDescFactory.buildDescriptor(file, uRL2, null, uRL);
                    URL uRL6 = this._launchDesc.getLocation();
                    if (uRL6 == null || !uRL6.toString().equals(uRL.toString()) && n == 0) {
                        ResourceProvider.get().markRetired(resource, false);
                        boolean bl14 = this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                        return bl14;
                    }
                    boolean bl15 = true;
                    return bl15;
                }
                throw new Exception("cache failed for" + uRL);
            }
            this._launchDesc = LaunchDescFactory.buildDescriptor(uRL, uRL2);
            URL uRL7 = this._launchDesc.getLocation();
            if (uRL7 != null && !uRL7.toString().equals(uRL.toString()) && n == 0) {
                boolean bl16 = this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                return bl16;
            }
            boolean bl17 = false;
            return bl17;
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            throw cacheUpdateRequiredException;
        }
        catch (Exception exception) {
            throw new ExitException(exception, 3);
        }
        finally {
            ResourceProvider.get().decrementInternalUse(n2);
        }
    }

    private URL deriveCodebase(URL uRL) {
        try {
            return new URL(uRL.toString().substring(0, uRL.toString().lastIndexOf("/") + 1));
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException((Exception)malformedURLException);
            return null;
        }
    }

    private void removeTempJnlpFile(LaunchDesc launchDesc) {
        File file = null;
        if (launchDesc.isApplicationDescriptor()) {
            file = ResourceProvider.get().getCachedJNLPFile(launchDesc.getCanonicalHome(), null);
        }
        if (file == null) {
            return;
        }
        if (this._args != null && file != null && JnlpxArgs.shouldRemoveArgumentFile()) {
            new File(this._args[0]).delete();
            JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
            this._args[0] = file.getPath();
        }
    }

    public void prepareAllResources(boolean bl) throws ExitException, CacheUpdateRequiredException {
        ArrayList<File> arrayList = new ArrayList<File>();
        boolean bl2 = this.prepareLaunchFile(this._launchDesc, this._args, bl, arrayList);
        this.prepareSecurity(this._launchDesc);
        final PreloaderDelegate preloaderDelegate = Progress.get(null);
        final JNLPSignedResourcesHelper jNLPSignedResourcesHelper = new JNLPSignedResourcesHelper(this._launchDesc);
        if (!bl) {
            this.prepareEnvironment(this._launchDesc);
            if (!Globals.isSilentMode() && !bl) {
                boolean bl3 = !this._launchDesc.getUpdate().isBackgroundCheck() && !this._launchDesc.getUpdate().isPromptPolicy() && !this._isRelaunch;
                boolean bl4 = !this._isCached || bl3;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SplashScreen.hide();
                        try {
                            boolean bl = jNLPSignedResourcesHelper.checkSignedResources(Progress.get(null), true);
                            Trace.println((String)("Security check for progress jars: allSigned=" + bl), (TraceLevel)TraceLevel.SECURITY);
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                        if (Launcher.this.disableCustomPreloader(Launcher.this._launchDesc)) {
                            preloaderDelegate.setPreloaderClass(null);
                        }
                        preloaderDelegate.initPreloader((ClassLoader)((Object)Launcher.this._jnlpClassLoader), Main.getLaunchThreadGroup());
                    }
                };
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        preloaderDelegate.setPreloaderClass(null);
                        SplashScreen.hide();
                        preloaderDelegate.initPreloader((ClassLoader)((Object)Launcher.this._jnlpClassLoader), Main.getLaunchThreadGroup());
                    }
                };
                new LaunchDownload(this._launchDesc).prepareCustomProgress(preloaderDelegate, jNLPSignedResourcesHelper, runnable, runnable2, bl4);
            }
        }
        this.prepareResources(this._launchDesc, this._args, this._isUpdated, bl, bl2, arrayList, jNLPSignedResourcesHelper);
        if (bl) {
            this.prepareEnvironment(this._launchDesc);
            preloaderDelegate.setPreloaderClass(this._launchDesc.getProgressClassName());
            preloaderDelegate.initPreloader((ClassLoader)((Object)this._jnlpClassLoader), Main.getLaunchThreadGroup());
        }
    }

    private boolean prepareLaunchFile(LaunchDesc launchDesc, String[] stringArray, boolean bl, ArrayList<File> arrayList) throws ExitException, CacheUpdateRequiredException {
        Serializable serializable;
        Object object;
        boolean bl2 = false;
        if (launchDesc.getResources() == null) {
            this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.noappresources", (Object[])new Object[]{launchDesc.getSpecVersion()}), null));
        }
        if (!this.isImport() && launchDesc.isLibrary()) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, "Internal Error: !isImport() && ld.isLibrary()", null);
            this.handleJnlpFileException(launchDesc, launchDescException);
        }
        boolean bl3 = launchDesc.isInstaller();
        JNLPException.setDefaultLaunchDesc(launchDesc);
        JREInfo jREInfo = JREInfo.getHomeJRE();
        Trace.println((String)("Launcher: isInstaller: " + bl3 + ", isRelaunch: " + this._isRelaunch + ", isImport(): " + this.isImport() + ", java.home:" + Environment.getJavaHome() + ", Running JRE: " + jREInfo), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)"JREInfos", (TraceLevel)TraceLevel.BASIC);
        JREInfo.traceJREs();
        if (jREInfo == null) {
            object = new LaunchDescException(launchDesc, "Internal Error: no running JRE", null);
            this.handleJnlpFileException(launchDesc, (Exception)object);
        }
        if (!launchDesc.getInformation().supportsOfflineOperation() && DeployOfflineManager.isGlobalOffline()) {
            throw new ExitException(new OfflineLaunchException(1), 3);
        }
        object = new LaunchDownload(launchDesc);
        if ((this._isRelaunch || launchDesc.getUpdate().isBackgroundCheck() || launchDesc.getUpdate().isPromptPolicy()) && (this._lap == null || !this._lap.forceUpdateCheck())) {
            this._isCached = ((LaunchDownload)object).isInCache();
        }
        if (!this._isCached && !bl) {
            try {
                ((LaunchDownload)object).downloadExtensions(null, 0, arrayList);
                bl2 = true;
            }
            catch (Exception exception) {
                if (!launchDesc.getInformation().supportsOfflineOperation() || !((LaunchDownload)object).isInCache()) {
                    throw new ExitException(exception, 3);
                }
                Trace.ignoredException((Exception)exception);
            }
        } else {
            bl2 = this._isCached;
        }
        if (!bl2) {
            if (!launchDesc.getInformation().supportsOfflineOperation() || !((LaunchDownload)object).isInCache()) {
                throw new CacheUpdateRequiredException("Some of required resources are not cached.");
            }
            bl2 = true;
        }
        JREMatcher jREMatcher = launchDesc.getJREMatcher();
        JVMParameters jVMParameters = jREMatcher.getSelectedJVMParameters();
        this._jreInfo = jREMatcher.getSelectedJREInfo();
        JREDesc jREDesc = jREMatcher.getSelectedJREDesc();
        if (this._jreInfo == null && jREDesc == null || null == jVMParameters) {
            Trace.println((String)jREMatcher.toString());
            serializable = new LaunchDescException(launchDesc, "Internal Error: Internal error, jreMatcher uninitialized", null);
            this.handleJnlpFileException(launchDesc, (Exception)serializable);
        }
        if ((serializable = launchDesc.getCanonicalHome()) == null) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainjar"), null);
            throw new ExitException(launchDescException, 3);
        }
        if (bl3) {
            this._lap = Cache.getLocalApplicationProperties((String)stringArray[0]);
            if (this._lap == null || !Environment.isInstallMode()) {
                this.handleJnlpFileException(launchDesc, new MissingFieldException(launchDesc.getSource(), "<application-desc>|<applet-desc>"));
            }
            serializable = this._lap.getLocation();
        } else if (!launchDesc.isLibrary()) {
            this._lap = Cache.getLocalApplicationProperties((URL)serializable);
        }
        Trace.println((String)("LaunchDesc location: " + serializable), (TraceLevel)TraceLevel.BASIC);
        return bl2;
    }

    private void prepareEnvironment(LaunchDesc launchDesc) throws ExitException {
        if (this.isImport() && !launchDesc.isInstaller()) {
            return;
        }
        AppPolicy appPolicy = AppPolicy.createInstance(launchDesc.getCanonicalHome().getHost());
        this._jnlpClassLoader = JNLPClassLoader.createClassLoader(launchDesc, appPolicy);
        try {
            String string = "http";
            URL uRL = launchDesc.getCanonicalHome();
            if (uRL.getProtocol().equalsIgnoreCase("file") && uRL.getHost().equals("")) {
                string = "file";
            }
            BasicServiceImpl.initialize(launchDesc.getCodebase(), true, string);
            if (launchDesc.getLaunchType() == 4) {
                String string2 = this._lap.getInstallDirectory();
                if (string2 == null) {
                    string2 = Cache.getNewExtensionInstallDirectory();
                    this._lap.setInstallDirectory(string2);
                }
                ExtensionInstallerServiceImpl.initialize(launchDesc.isSecure() ? null : string2, this._lap, Progress.get(null));
            }
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        if (!this.securityManagerDiabledForTests) {
            System.setSecurityManager(new JavaWebStartSecurity());
        }
    }

    private boolean isJfxSupportSatisfied(LaunchDesc launchDesc) {
        if (!launchDesc.needFX()) {
            return true;
        }
        if (launchDesc.isFXApp() && !ToolkitStore.setPreferredToolkit((ToolkitStore.ToolkitType)ToolkitStore.ToolkitType.FX_TOOLKIT)) {
            return false;
        }
        return JfxHelper.isJfxSupportSatisfied(null, launchDesc);
    }

    protected void relaunch(JREDesc jREDesc, LaunchDesc launchDesc, String[] stringArray, JVMParameters jVMParameters, boolean bl) throws ExitException {
        File file;
        if (!this.canRelaunch()) {
            return;
        }
        if (OSType.isMac()) {
            String string;
            String string2 = launchDesc.getInformation().getTitle();
            if (string2 != null) {
                System.setProperty("macosx.jnlpx.dock.name", string2);
            }
            if ((string = IconUtil.getIconPath(launchDesc)) == null) {
                string = Platform.get().getDefaultIconPath();
            }
            if (string != null) {
                System.setProperty("macosx.jnlpx.dock.icon", string);
            }
        }
        long l = jREDesc.getMinHeap();
        long l2 = jREDesc.getMaxHeap();
        HtmlOptions htmlOptions = HtmlOptions.get();
        if (htmlOptions != null) {
            try {
                file = File.createTempFile("jnl", ".tmp");
                htmlOptions.export(new FileOutputStream(file));
                stringArray = new String[]{"-nocodebase", file.getAbsolutePath()};
            }
            catch (IOException iOException) {
                throw new ExitException("Failed to relaunch. Can not save launch file.", iOException);
            }
        }
        if ((file = SessionState.save()) != null) {
            System.setProperty("jnlpx.session.data", file.getAbsolutePath());
        }
        try {
            Object object;
            if (bl) {
                object = new JVMParameters();
                object.setIncludeExtendedASCIIValues(true);
                object.parse(jREDesc.getVmArgs());
                jVMParameters.addArguments((JVMParameters)object);
            }
            stringArray = this.insertApplicationArgs(stringArray);
            object = JnlpxArgs.execProgram(this._jreInfo, stringArray, l, l2, jVMParameters, bl, launchDesc.isFXApp(), launchDesc.needFX());
            try {
                InputStream inputStream;
                ((Process)object).waitFor(3L, TimeUnit.SECONDS);
                if (!((Process)object).isAlive() && ((Process)object).exitValue() != 0 && (inputStream = ((Process)object).getErrorStream()) != null) {
                    Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");
                    String string = scanner.hasNext() ? scanner.next() : "";
                    LaunchErrorDialog.show(Progress.get(null).getOwner(), new Exception(string), true);
                    inputStream.close();
                }
                if (Platform.get().getRunInNativeSandbox()) {
                    ((Process)object).waitFor();
                }
            }
            catch (InterruptedException interruptedException) {
                Trace.ignoredException((Exception)interruptedException);
            }
        }
        catch (IOException iOException) {
            throw new ExitException(new JreExecException(this._jreInfo.getPath(), iOException), 3);
        }
        if (JnlpxArgs.shouldRemoveArgumentFile()) {
            JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
        }
        throw new ExitException(null, 0);
    }

    private boolean runInNativeSandbox(LaunchDesc launchDesc) {
        if (Platform.get().isNativeSandbox()) {
            return false;
        }
        DeploymentRuleSet deploymentRuleSet = launchDesc.getMainDeploymentRuleSet();
        if (deploymentRuleSet != null && !deploymentRuleSet.allowNativeSandbox()) {
            return false;
        }
        ArrayList<LaunchDesc> arrayList = new ArrayList<LaunchDesc>();
        JNLPSignedResourcesHelper.addExtensions(arrayList, launchDesc);
        for (LaunchDesc launchDesc2 : arrayList) {
            JARDesc[] jARDescArray;
            ResourcesDesc resourcesDesc;
            LaunchDesc launchDesc3 = launchDesc2;
            if (launchDesc3.getSecurityModel() == 0 || (resourcesDesc = launchDesc3.getResources()) == null || (jARDescArray = resourcesDesc.getLocalJarDescs()) == null || jARDescArray.length == 0) continue;
            return false;
        }
        return true;
    }

    private boolean disableCustomPreloader(LaunchDesc launchDesc) {
        if (this._disableCustomPreloader) {
            Trace.println((String)"Custom preloader: disabled", (TraceLevel)TraceLevel.PRELOADER);
            return true;
        }
        if (this.runInNativeSandbox(launchDesc)) {
            Trace.println((String)"Custom preloader: disabled", (TraceLevel)TraceLevel.PRELOADER);
            return true;
        }
        if (this._lap != null && this._lap.getEnableCustomPreloader()) {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
            return false;
        }
        if (Platform.get().isNativeSandbox()) {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
            return false;
        }
        DeploymentRuleSet deploymentRuleSet = launchDesc.getMainDeploymentRuleSet();
        if (deploymentRuleSet != null && !deploymentRuleSet.allowNativeSandbox()) {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
            return false;
        }
        ArrayList<LaunchDesc> arrayList = new ArrayList<LaunchDesc>();
        JNLPSignedResourcesHelper.addExtensions(arrayList, launchDesc);
        boolean bl = false;
        boolean bl2 = false;
        for (LaunchDesc launchDesc2 : arrayList) {
            if (launchDesc2.getSecurityModel() == 0) {
                bl2 = true;
            } else {
                bl = true;
            }
            if (!bl || !bl2) continue;
            this._disableCustomPreloader = true;
            break;
        }
        if (this._disableCustomPreloader) {
            Trace.println((String)"Custom preloader: disabled", (TraceLevel)TraceLevel.PRELOADER);
        } else {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
        }
        return this._disableCustomPreloader;
    }

    private void prepareResources(LaunchDesc launchDesc, String[] stringArray, boolean bl, boolean bl2, boolean bl3, ArrayList<File> arrayList, JNLPSignedResourcesHelper jNLPSignedResourcesHelper) throws ExitException, CacheUpdateRequiredException {
        LaunchDownload launchDownload;
        boolean bl4;
        boolean bl5 = launchDesc.isInstaller();
        boolean bl6 = this._isCached && DeployOfflineManager.isGlobalOffline();
        boolean bl7 = !this.isImport() && this._jreInfo == null || bl5;
        boolean bl8 = bl4 = !this._isCached || bl7;
        if (bl4 && bl6) {
            throw new ExitException(new OfflineLaunchException(0), 3);
        }
        boolean bl9 = bl4;
        if (!bl6) {
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                Trace.println((String)"Forced update check in LAP, do full update", (TraceLevel)TraceLevel.BASIC);
                bl9 = true;
            } else if (!bl2 && !launchDesc.getUpdate().isBackgroundCheck() && launchDesc.getUpdate().getPolicy() == 0) {
                bl9 = true;
            } else if (!bl2) {
                try {
                    bl9 = launchDesc.getUpdater().isUpdateAvailable();
                }
                catch (Exception exception) {
                    throw new ExitException(exception, 3);
                }
                if (bl9 && launchDesc.getUpdate().getPolicy() != 0) {
                    this._isCached = new LaunchDownload(launchDesc).isInCache();
                    if (this._isCached) {
                        bl4 = bl7;
                    }
                }
                if (launchDesc.getUpdater().isCheckAborted()) {
                    throw new ExitException(new LaunchDescException(launchDesc, "User rejected cert - aborted", null), 4);
                }
            }
        }
        Trace.println((String)("Offline mode: " + bl6 + "\nIsInCache: " + this._isCached + "\nforceUpdate: " + bl4 + "\nneedUpdate: " + bl9 + "\nIsInstaller: " + bl5), (TraceLevel)TraceLevel.BASIC);
        if (bl9 && !bl4) {
            bl4 = launchDesc.getUpdater().needUpdatePerPolicy(Progress.get(null));
        }
        if (bl4 && bl6) {
            throw new ExitException(new OfflineLaunchException(0), 3);
        }
        if (bl4) {
            this.downloadResources(launchDesc, arrayList, bl3, bl5);
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                this._lap.setForceUpdateCheck(false);
                try {
                    this._lap.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
        }
        PreloaderDelegate preloaderDelegate = Progress.get(null);
        try {
            preloaderDelegate.handleEvent((PreloaderEvent)new DownloadEvent(1, launchDesc.getLocation(), null, null, 1L, 1L, 100));
        }
        catch (CancelException cancelException) {
            throw new ExitException(cancelException, 3);
        }
        try {
            preloaderDelegate.waitTillLoaded();
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (IOException iOException) {
            launchDownload = new LaunchDownload(launchDesc);
            if (launchDesc.getInformation().supportsOfflineOperation() && launchDownload.isInCache(bl3)) {
                Trace.ignoredException((Exception)iOException);
            }
            throw new ExitException(iOException, 3);
        }
        ApplicationIconGenerator.generate(launchDesc, bl);
        if (!this.isImport() && !arrayList.isEmpty()) {
            if (bl5) {
                // empty if block
            }
            JnlpxArgs.executeInstallers(arrayList, Progress.get(null));
        }
        if (!Globals.isSilentMode() && launchDesc.isInstaller()) {
            try {
                Progress.get(null).handleEvent((PreloaderEvent)new ConfigEvent(3, launchDesc.getAppInfo()));
                Progress.get(null).handleEvent((PreloaderEvent)new InitEvent(2));
            }
            catch (CancelException cancelException) {
                throw new ExitException(cancelException, 3);
            }
        }
        JREMatcher jREMatcher = launchDesc.getJREMatcher();
        launchDownload = jREMatcher.getSelectedJVMParameters();
        this._jreInfo = jREMatcher.getSelectedJREInfo();
        JREDesc jREDesc = jREMatcher.getSelectedJREDesc();
        if (this.isImport()) {
            try {
                Progress.get(null).handleEvent((PreloaderEvent)new InitEvent(5));
            }
            catch (CancelException cancelException) {
                throw new ExitException(cancelException, 3);
            }
            boolean bl10 = LaunchDownload.isJnlpCached(launchDesc) && bl;
            Launcher.notifyLocalInstallHandler(launchDesc, this._lap, Globals.isSilentMode(), bl10, null);
            Trace.println((String)"Exiting after import", (TraceLevel)TraceLevel.BASIC);
            throw new ExitException(null, 0);
        }
        if (!launchDesc.isValidSpecificationVersion()) {
            JNLPException.setDefaultLaunchDesc(launchDesc);
            this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.badjnlversion", (Object[])new Object[]{launchDesc.getSpecVersion()}), null));
        }
        boolean bl11 = false;
        try {
            jNLPSignedResourcesHelper.checkSignedLaunchDesc();
            bl11 = jNLPSignedResourcesHelper.checkSignedResources(Progress.get(null), false);
            boolean bl12 = bl11 = bl11 && launchDesc.isSigned();
            if (this._disableCustomPreloader) {
                this._lap.setEnableCustomPreloader(true);
                this._lap.store();
            }
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 3);
        }
        SplashScreen.generateCustomSplash(launchDesc, bl);
        DeploymentRuleSet deploymentRuleSet = launchDesc.getMainDeploymentRuleSet();
        try {
            if (this._jreInfo == null) {
                SecureStaticVersioning.useLatest((AppInfo)launchDesc.getAppInfo(), (DeploymentRuleSet)deploymentRuleSet, (String)jREDesc.getVersion(), (int)2);
                this._jreInfo = launchDesc.selectJRE(true);
                jREMatcher = launchDesc.getJREMatcher();
                jREDesc = jREMatcher.getSelectedJREDesc();
                launchDownload = jREMatcher.getSelectedJVMParameters();
            } else if (!SecureStaticVersioning.canUse((AppInfo)launchDesc.getAppInfo(), (DeploymentRuleSet)deploymentRuleSet, (String)this._jreInfo.getProduct())) {
                this._jreInfo = launchDesc.selectJRE(true);
                jREMatcher = launchDesc.getJREMatcher();
                jREDesc = jREMatcher.getSelectedJREDesc();
                launchDownload = jREMatcher.getSelectedJVMParameters();
            }
        }
        catch (BlockedException blockedException) {
            throw new ExitException(blockedException, 0);
        }
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            Trace.println((String)("passing security checks; secureArgs:" + launchDesc.isSecureJVMArgs() + ", allSigned:" + bl11), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("trusted app: " + !launchDesc.isSecure() + ", -secure=" + Globals.isSecureMode()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)jREMatcher.toString(), (TraceLevel)TraceLevel.BASIC);
        }
        boolean bl13 = jREMatcher.isRunningJVMSatisfying(bl11);
        boolean bl14 = this.runInNativeSandbox(launchDesc);
        if (!bl13 || !this.isJfxSupportSatisfied(launchDesc) || bl14 || this._disableCustomPreloader) {
            if (bl14) {
                Platform.get().setRunInNativeSandbox(true);
            } else {
                Platform.get().setRunInNativeSandbox(false);
                if (this._disableCustomPreloader) {
                    Platform.get().checkAndUpdateSandboxWindow(true);
                }
            }
            this.relaunch(jREDesc, launchDesc, stringArray, (JVMParameters)launchDownload, bl11);
        }
        String string = " - " + launchDesc.getInformation().getTitle();
        JavawsConsoleController.getInstance().setTitle("console.caption", string);
        JavawsConsoleController.getInstance().showConsoleIfEnabled();
        JnlpxArgs.removeArgumentFile(stringArray[0]);
        if (Cache.isCacheEnabled() && (LocalInstallHandler.getInstance() != null && !LocalInstallHandler.getInstance().isShortcutExists(this._lap) || Globals.isIconImageUpdated())) {
            Launcher.notifyLocalInstallHandler(launchDesc, this._lap, Globals.isSilentMode(), bl || Globals.isIconImageUpdated(), Progress.get(null).getOwnerRef());
            if (Globals.isIconImageUpdated()) {
                Globals.setIconImageUpdated(false);
            }
        }
        Trace.println((String)"continuing launch in this VM", (TraceLevel)TraceLevel.BASIC);
        Config.getHooks().confirmAppRun();
    }

    private String[] insertApplicationArgs(String[] stringArray) {
        String[] stringArray2 = Globals.getApplicationArgs();
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray2.length + stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = stringArray2[i];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i++] = stringArray[i];
        }
        return stringArray3;
    }

    private void doLaunchApp() throws ExitException {
        Object object;
        AppContextUtil.createApplicationAppContext();
        JNLPClassLoader jNLPClassLoader = this._jnlpClassLoader;
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)jNLPClassLoader));
        ToolkitStore.get().setContextClassLoader((ClassLoader)((Object)jNLPClassLoader));
        String string = this._launchDesc.getInformation().getTitle();
        AppContext.getAppContext().put("deploy.trust.decider.app.name", string);
        this._launchDesc.storeVersionsInAppContext();
        String string2 = null;
        Class<?> clazz = null;
        try {
            ClassLoader classLoader;
            Object object2;
            ClassLoader classLoader2;
            string2 = LaunchDownload.getMainClassName(this._launchDesc);
            Trace.println((String)("Main-class: " + string2), (TraceLevel)TraceLevel.BASIC);
            if (string2 == null) {
                throw new ClassNotFoundException(string2);
            }
            ToolkitStore.get().getAppContext().put((Object)"deploy-main-class", (Object)string2);
            if (!Config.checkPackageAccess((String)string2, (AccessControlContext)Config.getNoPermissionACC())) {
                SecurityException securityException = new SecurityException("Bad package name of main-class");
                throw new ExitException(securityException, 3);
            }
            Progress.get(null).handleEvent((PreloaderEvent)new AppInitEvent(1));
            this._launchDesc.getUpdater().storeBackgroundListInAppContext();
            clazz = ((ClassLoader)((Object)jNLPClassLoader)).loadClass(string2);
            Class[] classArray = new Class[]{new String[0].getClass()};
            object = clazz.getMethod("main", classArray);
            Class<?> clazz2 = ((Method)object).getDeclaringClass();
            if (clazz2 != clazz) {
                classLoader2 = clazz2.getClassLoader();
                object2 = ClassLoader.getSystemClassLoader();
                for (classLoader = classLoader2; classLoader != null && classLoader.getParent() != null; classLoader = classLoader.getParent()) {
                }
                if (classLoader2 == object2 || classLoader2 == classLoader) {
                    throw new ClassNotFoundException(string2);
                }
            }
            if (this.getClass().getPackage().equals(clazz.getPackage())) {
                throw new ClassNotFoundException(string2);
            }
            classLoader2 = clazz.getClassLoader();
            if (classLoader2 != jNLPClassLoader && classLoader2 != ((ClassLoader)((Object)jNLPClassLoader)).getParent()) {
                object2 = new SecurityException("Bad main-class name");
                throw new ExitException((Throwable)object2, 3);
            }
            object2 = clazz.getProtectionDomain().getCodeSource();
            if (object2 != null) {
                classLoader = this._launchDesc.getMainDeploymentRuleSet();
                if (((CodeSource)object2).getCertificates() != null) {
                    DeployManifestChecker.verifyMainJar((DeploymentRuleSet)classLoader, (URL)((CodeSource)object2).getLocation(), (!this._launchDesc.isSecure() ? 1 : 0) != 0, (AppInfo)this._launchDesc.getAppInfo());
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExitException(classNotFoundException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (Exception exception) {
            for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
                if (!(throwable instanceof ExitException)) continue;
                throw (ExitException)throwable;
            }
            throw new ExitException(exception, 3);
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        try {
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("JNLP Launching");
            }
            this.executeMainClass(this._launchDesc, this._lap, clazz, Progress.get(null));
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Trace.ignored((Throwable)invocationTargetException);
            object = invocationTargetException;
            while (((Throwable)object).getCause() != null) {
                object = ((Throwable)object).getCause();
            }
            throw new ExitException((Throwable)object, 3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExitException(noSuchMethodException, 3);
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        if (this._launchDesc.getLaunchType() == 4) {
            throw new ExitException(null, 0);
        }
    }

    private void downloadResources(LaunchDesc launchDesc, ArrayList<File> arrayList, boolean bl, boolean bl2) throws ExitException {
        LaunchDownload launchDownload = new LaunchDownload(launchDesc);
        try {
            if (!this._shownDownloadWindow && !Globals.isSilentMode()) {
                this._shownDownloadWindow = true;
                PreloaderDelegate preloaderDelegate = Progress.get(null);
                preloaderDelegate.handleEvent((PreloaderEvent)new ConfigEvent(3, launchDesc.getAppInfo()));
                if (!bl2) {
                    preloaderDelegate.handleEvent((PreloaderEvent)new InitEvent(4));
                }
            }
            if (!bl) {
                launchDownload.downloadExtensions(Progress.get(null), 0, arrayList);
            }
            LaunchDownload.checkJNLPSecurity(launchDesc);
            boolean bl3 = Environment.isImportMode();
            launchDownload.downloadEagerorAll(bl3, Progress.get(null), false);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (Exception exception) {
            if (launchDesc.getInformation().supportsOfflineOperation() && launchDownload.isInCache(bl)) {
                Trace.ignoredException((Exception)exception);
            }
            throw new ExitException(exception, 3);
        }
    }

    public void prepareSecurity(LaunchDesc launchDesc) throws ExitException {
        try {
            LaunchDownload.checkJNLPSecurity(launchDesc);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
    }

    public static void notifyLocalInstallHandler(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, boolean bl2, ComponentRef componentRef) {
        LocalInstallHandler localInstallHandler;
        if (localApplicationProperties == null) {
            return;
        }
        URL uRL = LaunchDescFactory.getDerivedCodebase();
        if (uRL != null) {
            localApplicationProperties.setCodebase(uRL.toString());
        }
        localApplicationProperties.setLastAccessed(new Date());
        if (!Environment.isImportMode() && !launchDesc.isLibrary()) {
            localApplicationProperties.incrementLaunchCount();
        }
        if ((localInstallHandler = LocalInstallHandler.getInstance()) != null) {
            localInstallHandler.install(launchDesc, localApplicationProperties, bl2, bl, componentRef);
        }
        try {
            localApplicationProperties.store();
        }
        catch (IOException iOException) {
            Trace.println((String)("Couldn't save LAP: " + iOException), (TraceLevel)TraceLevel.BASIC);
        }
    }

    private void executeMainClass(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, PreloaderDelegate preloaderDelegate) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        launchDesc.getUpdater().startBackgroundUpdateOpt();
        this.executeApplication(launchDesc, localApplicationProperties, clazz, preloaderDelegate);
    }

    private void executeApplication(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, PreloaderDelegate preloaderDelegate) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Object[] objectArray;
        String[] stringArray = null;
        if (launchDesc.getLaunchType() == 4) {
            stringArray = new String[]{localApplicationProperties.isExtensionInstalled() ? "uninstall" : "install"};
            localApplicationProperties.setExtensionInstalled(false);
            localApplicationProperties.setRebootNeeded(false);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        } else {
            SplashScreen.hide();
            stringArray = null;
            if (!launchDesc.isFXApp()) {
                if (!launchDesc.isSigned() && HtmlOptions.get() != null) {
                    stringArray = HtmlOptions.get().getHtmlApplicationArgs();
                }
                if (stringArray == null) {
                    stringArray = launchDesc.getApplicationDescriptor().getArguments();
                }
            }
            if ((objectArray = Globals.getApplicationArgs()) != null) {
                stringArray = objectArray;
            }
        }
        objectArray = new Object[]{stringArray};
        Class[] classArray = new Class[]{new String[0].getClass()};
        Method method = clazz.getMethod("main", classArray);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException(ResourceManager.getString((String)"launch.error.nonstaticmainmethod"));
        }
        try {
            Progress.get(null).handleEvent((PreloaderEvent)new AppInitEvent(2));
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        method.invoke(null, objectArray);
    }

    public void handleJnlpFileException(LaunchDesc launchDesc, Exception exception) throws ExitException {
        Resource resource = ResourceProvider.get().getCachedResource(launchDesc.getCanonicalHome(), null);
        if (resource != null) {
            ResourceProvider.get().markRetired(resource, false);
        }
        throw new ExitException(exception, 3);
    }

    public void handleExitException(Throwable throwable) {
        int n;
        ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
        int n2 = n = exitException.getReason() == 0 || throwable instanceof BlockedException ? 0 : -1;
        if (!(throwable instanceof BlockedException)) {
            if (exitException.getReason() == 3) {
                LaunchErrorDialog.show(Progress.get(null).getOwner(), exitException.getException(), this._exit);
            } else if (exitException.getReason() == 6) {
                LaunchErrorDialog.show(Progress.get(null).getOwner(), exitException, this._exit);
            }
        }
        if (n == 0) {
            Trace.println((String)"Exiting", (TraceLevel)TraceLevel.BASIC);
        } else {
            Trace.ignoredException((Exception)exitException);
        }
        if (this._exit) {
            try {
                Main.systemExit(n);
            }
            catch (ExitException exitException2) {
                Trace.println((String)("systemExit: " + exitException2), (TraceLevel)TraceLevel.BASIC);
                Trace.ignoredException((Exception)exitException2);
            }
        }
    }

    public boolean handleCacheUpdateRequiredException(CacheUpdateRequiredException cacheUpdateRequiredException, boolean bl) {
        Trace.println((String)(ResourceManager.getString((String)"launch.error.cache") + " [" + cacheUpdateRequiredException.getMessage() + "]"), (TraceLevel)TraceLevel.BASIC);
        if (bl) {
            if (DeployOfflineManager.isForcedOffline()) {
                DeployOfflineManager.setForcedOffline((boolean)false);
                if (!DeployOfflineManager.askUserGoOnline((URL)this._initialLaunchDesc.getLocation())) {
                    DeployOfflineManager.setForcedOffline((boolean)true);
                    Trace.println((String)"User chose not to go online and we can not not start in offline mode");
                    LaunchErrorDialog.show(Progress.get(null).getOwner(), new OfflineLaunchException(0), this._exit);
                    return false;
                }
            } else if (!JnlpxArgs.getIsRelaunch()) {
                this._initialLaunchDesc = LaunchDescFactory.tryUpdateDescriptor(this._initialLaunchDesc);
            }
        }
        try {
            boolean bl2 = this.prepareToLaunch(false);
            return bl2;
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException2) {
            Trace.println((String)("Unexpected exception: " + cacheUpdateRequiredException2));
            return false;
        }
    }

    public boolean checkForSingleInstance() {
        String string = SingleInstanceServiceImpl.getIDString(this._initialLaunchDesc);
        if (!Environment.isImportMode() && SingleInstanceManager.isServerRunning((String)string)) {
            String[] stringArray = Globals.getApplicationArgs();
            if (stringArray == null && HtmlOptions.get() != null) {
                stringArray = HtmlOptions.get().getHtmlApplicationArgs();
            }
            if (stringArray != null && stringArray.length > 0 && this._initialLaunchDesc.getApplicationDescriptor() != null) {
                this._initialLaunchDesc.getApplicationDescriptor().setArguments(stringArray);
            }
            if (SingleInstanceManager.connectToServer((String)this._initialLaunchDesc.getSource())) {
                JnlpxArgs.removeArgumentFile(this._args[0]);
                Trace.println((String)"Exiting (launched in the other instance)", (TraceLevel)TraceLevel.BASIC);
                try {
                    ToolkitStore.get().dispose();
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
                return true;
            }
        }
        return false;
    }

    public boolean tryOffline() {
        boolean bl = Cache.isCacheEnabled() && (this._initialLaunchDesc.getUpdate().isBackgroundCheck() || DeployOfflineManager.isForcedOffline() || JnlpxArgs.getIsRelaunch());
        return bl;
    }

    public LaunchDesc updateLaunchDesc(boolean bl) throws CacheUpdateRequiredException, ExitException {
        String string;
        Object object;
        URL uRL;
        boolean bl2;
        Trace.println((String)("prepareToLaunch: offlineOnly=" + bl), (TraceLevel)TraceLevel.NETWORK);
        try {
            this._isUpdated = this.updateFinalLaunchDesc(this._initialLaunchDesc, 0, bl);
        }
        catch (ExitException exitException) {
            boolean bl3 = this._initialLaunchDesc.getUpdate().getCheck() == 0;
            bl2 = this._initialLaunchDesc.getInformation().supportsOfflineOperation();
            if (bl || bl3 || !bl2) {
                throw exitException;
            }
            this._isUpdated = this.updateFinalLaunchDesc(this._initialLaunchDesc, 0, true);
        }
        if (this._launchDesc != null && this._launchDesc.isFXApp()) {
            ToolkitStore.setToolkitType((ToolkitStore.ToolkitType)ToolkitStore.ToolkitType.FX_TOOLKIT);
        }
        ToolkitStore.get().getAppContext().put((Object)"deploy-main-class", (Object)this._launchDesc.getMainClassName());
        this.removeTempJnlpFile(this._launchDesc);
        if (this._isUpdated && this._launchDesc.isApplicationDescriptor()) {
            Resource resource = ResourceProvider.get().getCachedResource(this._launchDesc.getCanonicalHome(), null);
            File file = resource != null ? resource.getDataFile() : null;
            bl2 = this._launchDesc.getLocation() != null;
            boolean bl4 = JnlpxArgs.shouldRemoveArgumentFile();
            if (Cache.isCacheEnabled() && (bl2 || bl4) && this._args != null && file != null) {
                this._args[0] = file.getPath();
            }
        }
        boolean bl5 = this._launchDesc.isInstaller();
        this._isRelaunch = JnlpxArgs.getIsRelaunch();
        URL uRL2 = this._launchDesc.getCanonicalHome();
        if (!bl5 && !this._launchDesc.isLibrary()) {
            this._lap = Cache.getLocalApplicationProperties((URL)uRL2);
            if (bl && this._lap != null && this._lap.forceUpdateCheck()) {
                throw new CacheUpdateRequiredException("Need to update: force update set in LAP");
            }
        }
        if (this._isUpdated && this._lap != null && Cache.isCacheEnabled() && this._lap.isShortcutInstalled() && LocalInstallHandler.getInstance() != null && LocalInstallHandler.getInstance().isShortcutExists(this._lap)) {
            Launcher.notifyLocalInstallHandler(this._launchDesc, this._lap, Globals.isSilentMode(), this._isUpdated, Progress.get(null).getOwnerRef());
        }
        if ((uRL = this._launchDesc.getLocation()) != null) {
            Cache.removeRemovedApp((String)uRL.toString(), (String)this._launchDesc.getInformation().getTitle());
        }
        Trace.println((String)("isUpdated: " + this._isUpdated), (TraceLevel)TraceLevel.NETWORK);
        if (this._launchDesc.getResources() != null) {
            Globals.getDebugOptionsFromProperties(this._launchDesc.getResources().getResourceProperties());
        }
        if (Config.getBooleanProperty((String)"deployment.security.authenticator")) {
            this._ja = JAuthenticator.getInstance(Progress.get(null).getOwnerRef());
            Authenticator.setDefault((Authenticator)((Object)this._ja));
        }
        if (this._lap != null) {
            URL uRL3 = LaunchDescFactory.getDerivedCodebase();
            if (uRL3 != null) {
                this._lap.setCodebase(uRL3.toString());
            }
            if (this._args != null && this._args.length > 0 && (((String)(object = URLUtil.filterProtocols((String)this._args[0].toLowerCase()))).startsWith("http://") || ((String)object).startsWith("https://"))) {
                this._lap.setOriginalURL(this._args[0]);
            }
            try {
                this._lap.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            object = this._lap.getOriginalURL();
            if (object != null && this._launchDesc.getSourceURL() == null) {
                try {
                    this._launchDesc.setSourceURL(new URL((String)object));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (this.useAppletLifecycle()) {
            string = this._launchDesc.getDocumentBase().toString() + ": " + this._launchDesc.getArgumentsString();
        } else {
            object = this._launchDesc.getCodebase();
            String string2 = string = object != null ? ((URL)object).toString() + ": " : "(no codebase): " + this._launchDesc.getMainClassName() + " " + this._launchDesc.getArgumentsString();
        }
        if (this._launchDesc.getSourceURL() != null) {
            string = string + " sourceURL=" + this._launchDesc.getSourceURL();
        }
        Config.getHooks().storeAppName(string);
        return this._launchDesc;
    }

    public void initiateUpdateCheck() {
        String string = Platform.get().getSystemJavawsPath();
        File file = ResourceProvider.get().getCachedJNLPFile(this._launchDesc.getCanonicalHome(), null);
        try {
            String[] stringArray;
            String string2 = null;
            if (file != null) {
                string2 = file.getCanonicalPath();
            } else if (this._launchDesc.getLocation() != null) {
                string2 = this._launchDesc.getLocation().toString();
            }
            if (string2 == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = string;
                stringArray = stringArray2;
                stringArray2[1] = string2;
            }
            String[] stringArray3 = stringArray;
            Platform.get().getAutoUpdater().checkForUpdate(stringArray3);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
            Platform.get().getAutoUpdater().checkForUpdate(null);
        }
    }

    private void checkDeprecationWarning(LaunchDesc launchDesc) {
        String string;
        boolean bl = false;
        AppInfo appInfo = launchDesc.getAppInfo();
        String string2 = ResourceManager.getString((String)"security.dialog.notverified.subject").toUpperCase();
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)appInfo.getLapURL());
        String string3 = localApplicationProperties != null && !string2.equals(localApplicationProperties.getMainPublisher()) ? localApplicationProperties.getMainPublisher() : null;
        String string4 = localApplicationProperties != null ? localApplicationProperties.getMainTitle() : null;
        appInfo.setVendor(string3);
        appInfo.setTitle(string4);
        String string5 = string = string3 == null ? "" : Launcher.quoteString(string3);
        if (Config.getBooleanProperty((String)"deployment.deprecation.javaws.dialog.show")) {
            if (Config.isJavaVersionAtLeast9()) {
                int n = ToolkitStore.getUI().showMessageDialog(null, appInfo, 8, ResourceManager.getString((String)"deprecated.plugin.dialog.title"), ResourceManager.getString((String)"deprecated.plugin.dialog.masthead"), ResourceManager.getString((String)"deprecated.plugin.dialog.message", (Object[])new Object[]{string}), null, null, null, null, ResourceManager.getString((String)"deprecated.plugin.dialog.alwaysText"));
                bl = n == 2;
            } else {
                ToolkitStore.getUI().showMessageDialog(null, appInfo, 2, ResourceManager.getString((String)"deprecated.plugin.dialog.title"), ResourceManager.getString((String)"deprecated.plugin.dialog.masthead"), ResourceManager.getString((String)"deprecated.plugin.dialog.message", (Object[])new Object[]{string}), null, null, null, null, ResourceManager.getString((String)"deprecated.plugin.dialog.alwaysText"));
                bl = true;
            }
            if (bl) {
                Config.setBooleanProperty((String)"deployment.deprecation.javaws.dialog.show", (boolean)false);
                Config.get().storeIfNeeded();
            }
        }
        Trace.println((String)ResourceManager.getString((String)"deprecated.plugin.console.message", (Object[])new Object[]{string}));
    }

    private static String quoteString(String string) {
        if (string != null && string.trim().length() > 0) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public class CacheUpdateRequiredException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CacheUpdateRequiredException(String string) {
            super(string);
        }
    }
}

