/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppUtility;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Platform;
import com.sun.deploy.config.WinPlatform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.WinRegistry;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.IconUtil;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;

public class WinInstallHandler
extends LocalInstallHandler {
    private static final String INSTALLED_DESKTOP_SHORTCUT_KEY = "installed.desktop";
    private static final String INSTALLED_START_MENU_KEY = "installed.menu";
    private static final String UNINSTALLED_START_MENU_KEY = "installed.uninstalled";
    private static final String RCONTENT_START_MENU_KEY = "installed.rc";
    public static final int TYPE_DESKTOP = 1;
    public static final int TYPE_START_MENU = 2;
    private static final String REG_SHORTCUT_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    private static final String REG_DESKTOP_PATH_KEY = "Desktop";
    private static final String REG_START_MENU_PATH_KEY = "Programs";
    private static final int MAX_PATH = 260;
    private static final String SHORTCUT_EXTENSION = ".lnk";
    private static final int MAX_SHORTCUT = 260 - (".lnk".length() + 1);
    private boolean _loadedPaths = false;
    private String _desktopPath;
    private String _startMenuPath;
    private final String nameBadChars = "\"\\/|:?*<>";
    private final String dirBadChars = "\"|:?*<>";
    private static final char[] WHITESPACE_PAD;
    private static final String ELLIPSIS = "...";
    private static final int MAX_INSTALL_DESCRIPTION_LENGTH = 80;

    @Override
    public boolean isShortcutExists(LocalApplicationProperties localApplicationProperties) {
        String string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        String string2 = localApplicationProperties.get(INSTALLED_START_MENU_KEY);
        boolean bl = false;
        boolean bl2 = false;
        if (string != null) {
            bl = new File(string).exists();
        }
        if (string2 != null) {
            bl2 = new File(string2).exists();
        }
        if (string != null && string2 != null) {
            return bl && bl2;
        }
        return bl || bl2;
    }

    @Override
    public boolean[] whichShortcutsExist(LocalApplicationProperties localApplicationProperties) {
        boolean[] blArray = new boolean[2];
        String string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        blArray[0] = string != null && new File(string).exists();
        String string2 = localApplicationProperties.get(INSTALLED_START_MENU_KEY);
        blArray[1] = string2 != null && new File(string2).exists();
        return blArray;
    }

    @Override
    public String getDefaultIconPath() {
        return Platform.get().getSystemJavawsPath();
    }

    @Override
    public String getAssociationOpenCommand(String string) {
        return "\"" + Platform.get().getSystemJavawsPath() + "\" \"-localfile\" \"-open\" \"%1\" \"" + string + "\"";
    }

    @Override
    public String getAssociationPrintCommand(String string) {
        return "\"" + Platform.get().getSystemJavawsPath() + "\" \"-localfile\" \"-print\" \"%1\" \"" + string + "\"";
    }

    @Override
    public void registerAssociationInternal(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Association association) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService(localApplicationProperties);
        if (Environment.isSystemCacheMode()) {
            associationService.registerSystemAssociation(association);
        } else {
            associationService.registerUserAssociation(association);
        }
    }

    @Override
    public void unregisterAssociationInternal(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Association association) throws AssociationNotRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService(localApplicationProperties);
        if (Environment.isSystemCacheMode()) {
            associationService.unregisterSystemAssociation(association);
        } else {
            associationService.unregisterUserAssociation(association);
        }
    }

    @Override
    public boolean hasAssociation(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Association association) {
        AssociationService associationService = new AssociationService(localApplicationProperties);
        return associationService.hasAssociation(association);
    }

    @Override
    public boolean isLocalInstallSupported() {
        return true;
    }

    @Override
    public boolean isAssociationSupported() {
        return true;
    }

    @Override
    protected boolean isAssociationFileExtSupported(String string) {
        if (string == null) {
            return false;
        }
        String string2 = AppUtility.removeDotFromFileExtension((String)string.toLowerCase());
        return !string2.equals("exe") && !string2.equals("com") && !string2.equals("bat");
    }

    @Override
    public boolean removePathShortcut(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    @Override
    public boolean updateShortcutToLatestJRE(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        if (!(Platform.get() instanceof WinPlatform)) {
            return false;
        }
        WinPlatform winPlatform = (WinPlatform)Platform.get();
        String string = winPlatform.getSystemJavawsPath();
        if (string == null) {
            return false;
        }
        String string2 = localApplicationProperties.get(INSTALLED_START_MENU_KEY);
        if (string2 != null) {
            winPlatform.updateShortcut(string2, string);
        }
        if ((string2 = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY)) != null) {
            winPlatform.updateShortcut(string2, string);
        }
        if (localApplicationProperties.isJnlpInstalled()) {
            this.removeFromInstallPanel(launchDesc, localApplicationProperties, false);
            this.registerWithInstallPanel(launchDesc, localApplicationProperties);
        }
        return true;
    }

    private void deleteClonedShortcutIcon(LaunchDesc launchDesc, boolean bl) {
        String string = this.getIconPath(launchDesc, bl);
        File file = new File(this.getNewIconFilePath(string) + File.separator + this.getIconFileName(string));
        Cache.ensureFileDeleted((File)file);
    }

    @Override
    protected boolean removeShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        String string;
        String string2;
        if (localApplicationProperties == null) {
            Trace.println((String)"No LAP for uninstall, bailing!", (TraceLevel)TraceLevel.TEMP);
            return false;
        }
        String string3 = null;
        boolean bl2 = false;
        WinPlatform winPlatform = null;
        if (Platform.get() instanceof WinPlatform) {
            winPlatform = (WinPlatform)Platform.get();
        }
        if ((string2 = localApplicationProperties.get(INSTALLED_START_MENU_KEY)) != null) {
            if (!this.deleteShortcut(string2)) {
                bl2 = true;
            } else {
                localApplicationProperties.put(INSTALLED_START_MENU_KEY, null);
            }
            string3 = string2;
            if (winPlatform != null && winPlatform.isPlatformWindows8orLater()) {
                this.deleteClonedShortcutIcon(launchDesc, false);
            }
        }
        if ((string2 = localApplicationProperties.get(UNINSTALLED_START_MENU_KEY)) != null) {
            if (!this.deleteShortcut(string2)) {
                bl2 = true;
            } else {
                localApplicationProperties.put(UNINSTALLED_START_MENU_KEY, null);
            }
            string3 = string2;
        }
        if ((string = localApplicationProperties.get(RCONTENT_START_MENU_KEY)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreElements()) {
                string2 = stringTokenizer.nextToken();
                if (string2 == null) continue;
                if (!this.deleteShortcut(string2)) {
                    bl2 = true;
                }
                string3 = string2;
            }
            localApplicationProperties.put(RCONTENT_START_MENU_KEY, null);
        }
        if (string3 != null) {
            this.checkEmpty(string3);
        }
        if (bl) {
            string2 = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
            if (string2 != null) {
                if (!this.deleteShortcut(string2)) {
                    bl2 = true;
                } else {
                    localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, null);
                }
            }
            if (winPlatform != null && winPlatform.isPlatformWindows8orLater()) {
                this.deleteClonedShortcutIcon(launchDesc, true);
            }
        }
        if (bl2) {
            Trace.println((String)"uninstall shortcut failed", (TraceLevel)TraceLevel.TEMP);
        }
        localApplicationProperties.setShortcutInstalled(false);
        WinInstallHandler.save(localApplicationProperties);
        return !bl2;
    }

    private void checkEmpty(String string) {
        try {
            for (File file = new File(string).getParentFile(); file != null && file.isDirectory() && file.list().length == 0; file = file.getParentFile()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean hasValidTitle(LaunchDesc launchDesc) {
        if (launchDesc == null) {
            return false;
        }
        InformationDesc informationDesc = launchDesc.getInformation();
        if (informationDesc == null || this.nameFilter(informationDesc.getTitle()) == null) {
            Trace.println((String)"Invalid: No title!", (TraceLevel)TraceLevel.TEMP);
            return false;
        }
        return true;
    }

    @Override
    protected boolean createShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean[] blArray) {
        boolean bl;
        if (!this.hasValidTitle(launchDesc)) {
            return false;
        }
        if (this.isShortcutExists(localApplicationProperties) && !WinInstallHandler.shouldInstallOverExisting(launchDesc)) {
            return false;
        }
        String string = null;
        File file = ResourceProvider.get().getCachedJNLPFile(launchDesc.getCanonicalHome(), null);
        if (file != null) {
            string = file.getPath();
        }
        if (string == null) {
            this.installFailed(launchDesc);
            return false;
        }
        ShortcutDesc shortcutDesc = launchDesc.getInformation().getShortcut();
        boolean bl2 = shortcutDesc == null ? true : shortcutDesc.getDesktop();
        boolean bl3 = bl = shortcutDesc == null ? true : shortcutDesc.getMenu();
        if (blArray != null) {
            bl2 = bl2 && blArray[0];
            boolean bl4 = bl = bl && blArray[1];
        }
        if (bl2 && !this.handleInstall(launchDesc, shortcutDesc, localApplicationProperties, string, 1)) {
            this.installFailed(launchDesc);
            return false;
        }
        if (bl && !this.handleInstall(launchDesc, shortcutDesc, localApplicationProperties, string, 2)) {
            this.removeShortcuts(launchDesc, localApplicationProperties, bl2);
            this.installFailed(launchDesc);
            return false;
        }
        if (bl || bl2) {
            localApplicationProperties.setShortcutInstalled(true);
            WinInstallHandler.save(localApplicationProperties);
        }
        return true;
    }

    @Override
    protected void registerWithInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        InformationDesc informationDesc = launchDesc.getInformation();
        String string = Platform.get().toExecArg(launchDesc.getCanonicalHome().toString());
        String string2 = this.nameFilter(informationDesc.getTitle());
        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
            String string3 = this.getIconPath(launchDesc, false);
            String string4 = informationDesc.getVendor();
            String string5 = this.getBestFitDescription(informationDesc);
            URL uRL = informationDesc.getHome();
            String string6 = null;
            boolean bl = Environment.isSystemCacheMode();
            if (uRL != null) {
                string6 = informationDesc.getHome().toExternalForm();
            }
            if (string4 == null) {
                string4 = string6;
            }
            if (string4 == null && string5.trim().length() == 0) {
                string4 = null;
                string5 = null;
                string6 = null;
            }
            localApplicationProperties.setRegisteredTitle(string2);
            Platform.get().addRemoveProgramsAdd(string, string2, string3, string4, string5, string6, bl);
        }
    }

    @Override
    protected void removeFromInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        boolean bl2 = Environment.isSystemCacheMode();
        String string = localApplicationProperties.getRegisteredTitle();
        if (bl && string == null) {
            string = this.nameFilter(launchDesc.getInformation().getTitle());
        }
        if (string != null && string.length() != 0) {
            Platform.get().addRemoveProgramsRemove(string, bl2);
        }
    }

    private String getBestFitDescription(InformationDesc informationDesc) {
        String string = informationDesc.getDescription(2);
        if (string == null && (string = informationDesc.getDescription(0)) == null && (string = informationDesc.getDescription(1)) == null) {
            string = informationDesc.getDescription(3);
        }
        if (string != null) {
            int n = string.length();
            if (n < WHITESPACE_PAD.length) {
                string = new StringBuffer(string).append(WHITESPACE_PAD, 0, WHITESPACE_PAD.length - n).toString();
            } else if (n > 80) {
                int n2 = ELLIPSIS.length();
                string = new StringBuffer(string).delete(80 - n2, n).append(ELLIPSIS).toString();
            }
        } else {
            string = new String(WHITESPACE_PAD);
        }
        return string;
    }

    private void installFailed(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = ResourceManager.getString((String)"common.ok_btn");
                String string2 = ResourceManager.getString((String)"common.detail.button");
                ToolkitStore.getUI().showMessageDialog(null, null, 0, ResourceManager.getString((String)"install.installFailedTitle"), ResourceManager.getString((String)"install.installFailed", (Object[])new Object[]{WinInstallHandler.this.getInstallName(launchDesc)}), null, null, string, string2, null);
            }
        };
        WinInstallHandler.invokeRunnable(runnable);
    }

    private void uninstallFailed(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = ResourceManager.getString((String)"common.ok_btn");
                String string2 = ResourceManager.getString((String)"common.detail.button");
                ToolkitStore.getUI().showMessageDialog(null, null, 0, ResourceManager.getString((String)"install.uninstallFailedTitle"), ResourceManager.getString((String)"install.uninstallFailed", (Object[])new Object[]{WinInstallHandler.this.getInstallName(launchDesc)}), null, null, string, string2, null);
            }
        };
        WinInstallHandler.invokeRunnable(runnable);
    }

    private String getIconFileName(String string) {
        return string.substring(string.lastIndexOf(File.separator) + 1);
    }

    private String getNewIconFilePath(String string) {
        int n = string.lastIndexOf(File.separator);
        if (n < 0) {
            return string;
        }
        if (!(Platform.get() instanceof WinPlatform)) {
            return string;
        }
        WinPlatform winPlatform = (WinPlatform)Platform.get();
        String string2 = winPlatform.getPlatformUserHome().toLowerCase();
        if (string.toLowerCase().contains(string2)) {
            int n2 = string2.length();
            String string3 = winPlatform.getPlatformUserLocalDir();
            return string3 != null ? string3 + string.substring(n2, n) : string;
        }
        return string;
    }

    private String copyIconFileForWindows8(String string) {
        if (!(Platform.get() instanceof WinPlatform)) {
            return string;
        }
        String string2 = string;
        WinPlatform winPlatform = (WinPlatform)Platform.get();
        String string3 = winPlatform.getPlatformUserHome().toLowerCase();
        if (string.toLowerCase().contains(string3)) {
            string2 = this.getNewIconFilePath(string);
            String string4 = this.getIconFileName(string);
            try {
                File file = new File(string2);
                file.mkdirs();
                Cache.copyFile((File)new File(string), (File)new File(file, string4));
                string2 = string2 + File.separator + string4;
            }
            catch (IOException iOException) {
                return string;
            }
        }
        return string2;
    }

    private boolean handleInstall(LaunchDesc launchDesc, ShortcutDesc shortcutDesc, LocalApplicationProperties localApplicationProperties, String string, int n) {
        InformationDesc informationDesc = launchDesc.getInformation();
        String string2 = null;
        String string3 = this.getIconPath(launchDesc, true);
        String string4 = this.getIconPath(launchDesc, false);
        String string5 = Platform.get().getSystemJavawsPath();
        String string6 = informationDesc.getDescription(0);
        String string7 = informationDesc.getDescription(3);
        String string8 = string7 == null ? string6 : string7;
        boolean bl = true;
        String string9 = launchDesc.getLocation() != null ? launchDesc.getLocation().toString() : null;
        String string10 = string9 == null || string9.endsWith(".jarjnlp") ? "" : "-J-Djnlp.application.href=" + string9 + " ";
        boolean bl2 = !informationDesc.supportsOfflineOperation() || shortcutDesc == null || shortcutDesc.getOnline();
        String string11 = bl2 ? "" : "-offline ";
        String string12 = "-localfile " + string11 + string10 + "\"" + string + "\"";
        if (string12.length() >= 255) {
            string12 = "-localfile " + string11 + "\"" + string + "\"";
        }
        WinPlatform winPlatform = null;
        if (Platform.get() instanceof WinPlatform) {
            winPlatform = (WinPlatform)Platform.get();
        }
        if (n == 1) {
            int n2;
            String string13 = this.getDesktopPath(launchDesc);
            string2 = this.getInstallName(launchDesc);
            if (winPlatform != null && winPlatform.isPlatformWindows8orLater()) {
                string3 = this.copyIconFileForWindows8(string3);
            }
            if ((n2 = this.installWrapper(string13, string2, string8, string5, string12, null, string3)) == 0) {
                localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, string13);
                Trace.println((String)("Installed desktop shortcut for: " + string2 + "."), (TraceLevel)TraceLevel.TEMP);
            } else {
                bl = false;
                Trace.println((String)("Installed desktop shortcut for: " + string2 + " failed (" + n2 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
            }
        } else {
            File file = new File(this.getSubMenuPath(launchDesc));
            if (file.exists() || file.mkdirs()) {
                int n3;
                String string14 = this.getStartMenuPath(launchDesc);
                string2 = this.getInstallName(launchDesc);
                if (winPlatform != null && winPlatform.isPlatformWindows8orLater()) {
                    string4 = this.copyIconFileForWindows8(string4);
                }
                if ((n3 = this.installWrapper(string14, string2, string8, string5, string12, null, string4)) == 0) {
                    localApplicationProperties.put(INSTALLED_START_MENU_KEY, string14);
                    Trace.println((String)("Installed menu shortcut for: " + string2 + "."), (TraceLevel)TraceLevel.TEMP);
                } else {
                    bl = false;
                    Trace.println((String)("Installed menu shortcut for: " + string2 + " failed (" + n3 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                }
                String string15 = this.getSubMenuDir(launchDesc);
                if ((string15 == null || !string15.equals("Startup")) && this.addUninstallShortcut()) {
                    string12 = "-uninstall \"" + string + "\"";
                    string14 = this.getUninstallPath(launchDesc);
                    n3 = this.installWrapper(string14, string2 = this.getUninstallMenuName(launchDesc), string8, string5, string12, null, string4);
                    if (n3 == 0) {
                        localApplicationProperties.put(UNINSTALLED_START_MENU_KEY, string14);
                        Trace.println((String)("Installed menu shortcut for: " + string2 + "."), (TraceLevel)TraceLevel.TEMP);
                    } else {
                        bl = false;
                        Trace.println((String)("Installed menu shortcut for: " + string2 + " failed (" + n3 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                    }
                }
                RContentDesc[] rContentDescArray = informationDesc.getRelatedContent();
                StringBuilder stringBuilder = new StringBuilder();
                if (rContentDescArray != null) {
                    for (RContentDesc rContentDesc : rContentDescArray) {
                        string2 = this.nameFilter(rContentDesc.getTitle());
                        URL uRL = rContentDesc.getHref();
                        if (uRL.toString().endsWith("jnlp")) continue;
                        string8 = rContentDesc.getDescription();
                        URL uRL2 = rContentDesc.getIcon();
                        String string16 = null;
                        if (uRL2 != null) {
                            string16 = IconUtil.getIconPath(uRL2, null);
                        }
                        if (string16 == null) {
                            string16 = string3;
                        }
                        string14 = this.getRCPath(launchDesc, string2);
                        File file2 = CacheUtil.getCachedFileNative(uRL);
                        string5 = Platform.get().getBrowserPath();
                        if (file2 != null) {
                            string12 = "\"file:" + file2.getAbsolutePath() + "\"";
                            n3 = this.installWrapper(string14, string2, string8, string5, string12, null, string16);
                            if (n3 == 0) {
                                stringBuilder.append(string14);
                                stringBuilder.append(File.pathSeparator);
                                Trace.println((String)("Installed menu shortcut for: " + string2 + "."), (TraceLevel)TraceLevel.TEMP);
                                continue;
                            }
                            bl = false;
                            Trace.println((String)("Installed menu shortcut for: " + string2 + " failed (" + n3 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                            continue;
                        }
                        string12 = uRL.toString();
                        n3 = this.installWrapper(string14, string2, string8, string5, string12, null, string16);
                        if (n3 == 0) {
                            stringBuilder.append(string14);
                            stringBuilder.append(File.pathSeparator);
                            Trace.println((String)("Installed menu shortcut for: " + string2 + "."), (TraceLevel)TraceLevel.TEMP);
                            continue;
                        }
                        bl = false;
                        Trace.println((String)("Installed menu shortcut for: " + string2 + " failed (" + n3 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                    }
                }
                if (stringBuilder.length() > 0) {
                    localApplicationProperties.put(RCONTENT_START_MENU_KEY, stringBuilder.toString());
                } else {
                    localApplicationProperties.put(RCONTENT_START_MENU_KEY, null);
                }
            } else {
                bl = false;
                Trace.println((String)("Installed menu shortcut for: " + string2 + " failed (can't create directory \"" + file.getAbsolutePath() + "\")!!!"), (TraceLevel)TraceLevel.TEMP);
            }
        }
        return bl;
    }

    private String getInstallName(LaunchDesc launchDesc) {
        return this.nameFilter(launchDesc.getInformation().getTitle());
    }

    private String getUninstallMenuName(LaunchDesc launchDesc) {
        String string = ResourceManager.getString((String)"install.startMenuUninstallShortcutName", (Object[])new Object[]{this.getInstallName(launchDesc)});
        return string;
    }

    private String getDesktopPath(LaunchDesc launchDesc) {
        return this.getShortcutPath(this.getDesktopPath(), this.getInstallName(launchDesc));
    }

    private String getStartMenuPath(LaunchDesc launchDesc) {
        return this.getShortcutPath(this.getSubMenuPath(launchDesc), this.getInstallName(launchDesc));
    }

    private String getRCPath(LaunchDesc launchDesc, String string) {
        return this.getShortcutPath(this.getSubMenuPath(launchDesc), string);
    }

    private String getUninstallPath(LaunchDesc launchDesc) {
        return this.getShortcutPath(this.getSubMenuPath(launchDesc), this.getUninstallMenuName(launchDesc));
    }

    private String getSubMenuPath(LaunchDesc launchDesc) {
        String string;
        String string2 = this.getStartMenuPath();
        if (string2 != null && (string = this.getSubMenuDir(launchDesc)) != null) {
            string2 = string2 + string + File.separator;
        }
        return string2;
    }

    private String getSubMenuDir(LaunchDesc launchDesc) {
        String string;
        String string2 = this.getInstallName(launchDesc);
        ShortcutDesc shortcutDesc = launchDesc.getInformation().getShortcut();
        if (shortcutDesc != null && (string = shortcutDesc.getSubmenu()) != null) {
            string2 = this.dirFilter(string);
        }
        if (string2 != null && string2.equalsIgnoreCase("startup")) {
            string2 = "Startup";
        }
        return string2;
    }

    private String getDesktopPath() {
        this.loadPathsIfNecessary();
        return this._desktopPath;
    }

    private String getStartMenuPath() {
        this.loadPathsIfNecessary();
        return this._startMenuPath;
    }

    private void loadPathsIfNecessary() {
        int n = -2147483647;
        String string = "";
        if (Environment.isSystemCacheMode()) {
            n = -2147483646;
            string = "Common ";
        }
        if (!this._loadedPaths) {
            this._desktopPath = WinRegistry.getString((int)n, (String)REG_SHORTCUT_PATH, (String)(string + REG_DESKTOP_PATH_KEY));
            if (this._desktopPath != null && this._desktopPath.length() > 0 && this._desktopPath.charAt(this._desktopPath.length() - 1) != '\\') {
                this._desktopPath = this._desktopPath + '\\';
            }
            this._startMenuPath = WinRegistry.getString((int)n, (String)REG_SHORTCUT_PATH, (String)(string + REG_START_MENU_PATH_KEY));
            if (this._startMenuPath != null && this._startMenuPath.length() > 0 && this._startMenuPath.charAt(this._startMenuPath.length() - 1) != '\\') {
                this._startMenuPath = this._startMenuPath + '\\';
            }
            this._loadedPaths = true;
            Trace.println((String)("Start path: " + this._startMenuPath + " desktop " + this._desktopPath), (TraceLevel)TraceLevel.TEMP);
        }
    }

    private String nameFilter(String string) {
        return this.Filter(string, "\"\\/|:?*<>", '-');
    }

    private String dirFilter(String string) {
        String string2 = this.Filter(string, "\"|:?*<>", '-');
        return this.Filter(string2, "\\/", File.separatorChar);
    }

    private String Filter(String string, String string2, char c) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("nul")) {
            return "-nul-";
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return this.checkTitleString(string, string2, c);
    }

    private boolean deleteShortcut(String string) {
        File file = new File(string);
        if (file.exists()) {
            boolean bl = file.delete();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                Trace.ignoredException((Exception)interruptedException);
            }
            return bl;
        }
        return true;
    }

    private String getIconPath(LaunchDesc launchDesc, boolean bl) {
        String string;
        String string2 = this.getDefaultIconPath();
        if (launchDesc != null && (string = IconUtil.getIconPath(launchDesc, bl)) != null) {
            string2 = string;
        }
        return string2;
    }

    private String getShortcutPath(String string, String string2) {
        String string3 = null;
        if (string != null && string.length() < MAX_SHORTCUT - 1 && string2 != null) {
            StringBuilder stringBuilder = new StringBuilder(324);
            stringBuilder.append(string).append(string2);
            if (stringBuilder.length() > MAX_SHORTCUT) {
                stringBuilder.delete(MAX_SHORTCUT, stringBuilder.length());
            }
            stringBuilder.append(SHORTCUT_EXTENSION);
            string3 = stringBuilder.toString();
        }
        return string3;
    }

    private int installWrapper(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Trace.println((String)"installshortcut with args:", (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    path: " + string), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    name: " + string2), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    desc: " + string3), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    appP: " + string4), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    args: " + string5), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    dir : " + string6), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    icon: " + string7), (TraceLevel)TraceLevel.TEMP);
        Trace.flush();
        return Platform.get().installShortcut(string, string2, string3, string4, string5, string6, string7);
    }

    static {
        String string = System.getProperty("os.name");
        WHITESPACE_PAD = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    }
}

