/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.jnlp.JNLPRandomAccessFileImpl;
import com.sun.jnlp.JNLPRandomAccessFileNSBImpl;
import com.sun.jnlp.MeteredFileOutputStream;
import com.sun.jnlp.MeteredFileOutputStreamNSB;
import com.sun.jnlp.PersistenceServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import javax.jnlp.FileContents;
import javax.jnlp.JNLPRandomAccessFile;

public final class FileContentsImpl
implements FileContents {
    private String _name = null;
    private File _file = null;
    private long _limit = Long.MAX_VALUE;
    private URL _url = null;
    private JNLPRandomAccessFile _raf = null;
    private PersistenceServiceImpl _psCallback = null;
    private static final AccessControlContext ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions permissions = new Permissions();
            FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write");
            ((PermissionCollection)permissions).add(filePermission);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }
    });

    FileContentsImpl(File file, long l) throws IOException {
        this._file = file;
        this._limit = l;
        this._name = this._file.getName();
    }

    FileContentsImpl(File file, PersistenceServiceImpl persistenceServiceImpl, URL uRL, long l) {
        this._file = file;
        this._url = uRL;
        this._psCallback = persistenceServiceImpl;
        this._limit = l;
        int n = uRL.getFile().lastIndexOf(47);
        this._name = n != -1 ? uRL.getFile().substring(n + 1) : uRL.getFile();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public long getLength() {
        Long l = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return FileContentsImpl.this._file.length();
            }
        }, ACC_FILE_INSTANCE);
        return l;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            InputStream inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return new FileInputStream(FileContentsImpl.this._file);
                }
            }, ACC_FILE_INSTANCE);
            return inputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.rethrowException(privilegedActionException);
        }
    }

    @Override
    public OutputStream getOutputStream(final boolean bl) throws IOException {
        try {
            OutputStream outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    if (Platform.get().isNativeSandbox()) {
                        return new MeteredFileOutputStreamNSB(FileContentsImpl.this._file, !bl, FileContentsImpl.this);
                    }
                    return new MeteredFileOutputStream(FileContentsImpl.this._file, !bl, FileContentsImpl.this);
                }
            }, ACC_FILE_INSTANCE);
            return outputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.rethrowException(privilegedActionException);
        }
    }

    @Override
    public boolean canRead() throws IOException {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return FileContentsImpl.this._file.canRead();
            }
        }, ACC_FILE_INSTANCE);
        return bl;
    }

    @Override
    public boolean canWrite() throws IOException {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return FileContentsImpl.this.canWriteFile(FileContentsImpl.this._file);
            }
        }, ACC_FILE_INSTANCE);
        return bl;
    }

    private boolean canWriteFile(File file) {
        if (file.exists()) {
            return file.canWrite();
        }
        File file2 = file.getParentFile();
        return file2 != null && file2.exists() && file2.canWrite();
    }

    @Override
    public JNLPRandomAccessFile getRandomAccessFile(final String string) throws IOException {
        if (Platform.get().isNativeSandbox() && string.equals("rw")) {
            return new JNLPRandomAccessFileNSBImpl(this._file, string, this);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JNLPRandomAccessFile>(){

                @Override
                public JNLPRandomAccessFile run() throws MalformedURLException, IOException {
                    return new JNLPRandomAccessFileImpl(FileContentsImpl.this._file, string, FileContentsImpl.this);
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.rethrowException(privilegedActionException);
        }
    }

    @Override
    public long getMaxLength() throws IOException {
        return this._limit;
    }

    @Override
    public long setMaxLength(long l) throws IOException {
        if (this._psCallback != null) {
            this._limit = this._psCallback.setMaxLength(this._url, l);
            return this._limit;
        }
        this._limit = l;
        return this._limit;
    }

    private IOException rethrowException(PrivilegedActionException privilegedActionException) throws IOException {
        Exception exception = privilegedActionException.getException();
        if (exception instanceof IOException) {
            throw new IOException("IOException from FileContents");
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new IOException(exception.getMessage());
    }
}

