/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SafeThreadFactory;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import java.awt.AWTPermission;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FilePermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.PrintService;

public final class PrintServiceImpl
implements PrintService {
    private static PrintServiceImpl _sharedInstance = null;
    private static ApiDialog _apiDialog = new ApiDialog();
    private PageFormat _pageFormat = null;
    private static final AccessControlContext ACC_PRINT_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions permissions = new Permissions();
            AWTPermission aWTPermission = new AWTPermission("accessClipboard");
            ((PermissionCollection)permissions).add(aWTPermission);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }
    });
    private static final AccessControlContext ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions permissions = new Permissions();
            FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write");
            ((PermissionCollection)permissions).add(filePermission);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }
    });

    private PrintServiceImpl() {
    }

    public static synchronized PrintServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new PrintServiceImpl();
        }
        return _sharedInstance;
    }

    @Override
    public PageFormat getDefaultPage() {
        return AccessController.doPrivileged(new PrivilegedAction<PageFormat>(){

            @Override
            public PageFormat run() {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                if (printerJob != null) {
                    return printerJob.defaultPage();
                }
                return null;
            }
        }, ACC_PRINT_INSTANCE);
    }

    @Override
    public PageFormat showPageFormatDialog(final PageFormat pageFormat) {
        return AccessController.doPrivileged(new PrivilegedAction<PageFormat>(){

            @Override
            public PageFormat run() {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                if (printerJob != null) {
                    PrintServiceImpl.this._pageFormat = printerJob.pageDialog(pageFormat);
                    return PrintServiceImpl.this._pageFormat;
                }
                return null;
            }
        }, ACC_PRINT_INSTANCE);
    }

    @Override
    public synchronized boolean print(Pageable pageable) {
        return this.doPrinting(null, pageable);
    }

    @Override
    public synchronized boolean print(Printable printable) {
        return this.doPrinting(printable, null);
    }

    private boolean doPrinting(final Printable printable, final Pageable pageable) {
        if (!this.askUser()) {
            return false;
        }
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                final PrinterJob printerJob = PrinterJob.getPrinterJob();
                if (printerJob == null) {
                    return Boolean.FALSE;
                }
                if (pageable != null) {
                    printerJob.setPageable(pageable);
                } else if (PrintServiceImpl.this._pageFormat == null) {
                    printerJob.setPrintable(printable);
                } else {
                    printerJob.setPrintable(printable, PrintServiceImpl.this._pageFormat);
                }
                if (printerJob.printDialog()) {
                    Thread thread = SafeThreadFactory.createThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                printerJob.print();
                            }
                            catch (PrinterException printerException) {
                                Trace.ignoredException((Exception)printerException);
                            }
                        }
                    });
                    thread.start();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }, ACC_PRINT_INSTANCE);
        return bl;
    }

    private synchronized boolean askUser() {
        if (CheckServicePermission.hasPrintAccessPermissions()) {
            return true;
        }
        return PrintServiceImpl.requestPrintPermission();
    }

    public static boolean requestPrintPermission() {
        Object object;
        final LocalApplicationProperties localApplicationProperties = JNLPUtils.getLocalApplicationProperties();
        if (localApplicationProperties != null && (object = localApplicationProperties.get("jnlp.api.always.PrintService.print")) != null) {
            return true;
        }
        object = _apiDialog.askUser(ResourceManager.getString((String)"api.print.title"), ResourceManager.getString((String)"api.print.message"), ResourceManager.getString((String)"api.print.always"));
        if (object == ApiDialog.DialogResult.ALWAYS) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    localApplicationProperties.put("jnlp.api.always.PrintService.print", "skip");
                    try {
                        localApplicationProperties.store();
                    }
                    catch (Throwable throwable) {
                        Trace.ignored((Throwable)throwable);
                    }
                    return null;
                }
            }, ACC_FILE_INSTANCE);
        }
        return object == ApiDialog.DialogResult.OK || object == ApiDialog.DialogResult.ALWAYS;
    }
}

