﻿#include "BufferBase64Encoder.hh"
#include "BufferDynamicHolder.hh"
#include "Base64.hh"
#include "Boolean.hh"

#include <cstring>

Boolean couldFitTheBuffer(long requestedSize) {
  unsigned int typedSize = (unsigned int)requestedSize;
  return typedSize == requestedSize;
}

BufferHolder* BufferBase64Encoder::transform(const void* buffer, long sizeInBytes)
{
  BufferDynamicHolder* bufferHolder = nullptr;
  if (couldFitTheBuffer(sizeInBytes)) {
    auto convertedBuffer = base64Encode((char const*)buffer, (unsigned)sizeInBytes, True);
    bufferHolder = new BufferDynamicHolder(convertedBuffer, strlen(convertedBuffer));
  }
  return bufferHolder;
}
