﻿#include "CryptoSockets.h"

#include <WinSock2.h>

bool EncryptedSocketFactory::registerSocket(int socket, EncryptedSocket* proxy)
{
  for (int i = 0; i < MAX_LOCK_SOCKETS; ++i)
  {
    if (InterlockedCompareExchange(lockSockets_ + i, socket, 0) == 0) {
      Sockets_[i] = proxy;
      return true;
    }
  }
  return false;
}

bool EncryptedSocketFactory::unregisterSocket(int socket)
{
  if (!socket)
    return false;
  for (int i = 0; i < MAX_LOCK_SOCKETS; ++i)
  {
    if (InterlockedCompareExchange(lockSockets_ + i, 0, socket) == socket) {
      return true;
    }
  }
  return false;
}

EncryptedSocket* EncryptedSocketFactory::findSocket(int socket)
{
  if (!socket)
    return NULL;
  for (int i = 0; i < MAX_LOCK_SOCKETS; ++i)
  {
    if (InterlockedCompareExchange(lockSockets_ + i, socket, socket) == socket) {
      return Sockets_[i];
    }
  }
  return NULL;
}

int EncryptedSocketFactory::send(int s, const char * buf, int len, int flags)
{
  EncryptedSocket* proxy = findSocket(s);
  if (!proxy)
  {
    return ::send(s, buf, len, flags);
  }
  return proxy->send(s, buf, len, flags);
}

int EncryptedSocketFactory::recv(int s, char * buf, int len, int flags)
{
  EncryptedSocket* proxy = findSocket(s);
  if (!proxy)
  {
    return ::recv(s, buf, len, flags);
  }
  return proxy->recv(s, buf, len, flags);
}

int EncryptedSocketFactory::recvfrom(int s, char * buf, int len, int flags, void* adr, int*adrlen)
{
  EncryptedSocket* proxy = findSocket(s);
  if (!proxy)
  {
    return ::recvfrom(s, buf, len, flags, (sockaddr *)adr, adrlen);
  }
  return proxy->recvfrom(s, buf, len, flags, adr, adrlen);
}

bool EncryptedSocketFactory::hasMoreData(int s)
{
  EncryptedSocket* proxy = findSocket(s);
  return proxy != NULL && proxy->hasMoreData();
}
