﻿#pragma once

class EncryptedSocket;

class EncryptedSocketFactory {
public:
  static bool registerSocket(int socket, EncryptedSocket* proxy);
  static bool unregisterSocket(int socket);

  static int send(int s, const char * buf, int len, int flags);
  static int recv(int s, char * buf, int len, int flags);
  static int recvfrom(int s, char * buf, int len, int flags, void* adr, int*adrlen);
  static bool hasMoreData(int s);
private:
#define MAX_LOCK_SOCKETS 20
  static long lockSockets_[MAX_LOCK_SOCKETS];
  static EncryptedSocket* Sockets_[MAX_LOCK_SOCKETS];

  static EncryptedSocket* findSocket(int socket);
};

class EncryptedSocket {
public:
  EncryptedSocket(int Socket) : Socket_(Socket)
  {
    EncryptedSocketFactory::registerSocket(Socket_, this);
  };
  virtual ~EncryptedSocket()
  {
    EncryptedSocketFactory::unregisterSocket(Socket_);
  };
  virtual int send(int s, const char * buf, int len, int flags) { return 0; };
  virtual int recv(int s, char * buf, int len, int flags) { return 0; };
  virtual int recvfrom(int s, char * buf, int len, int flags, void* adr, int*adrlen) { return 0; };
  virtual bool hasMoreData() { return false; }
protected:
  int Socket_;
};
