﻿#pragma once

#ifndef _MULTI_FRAMED_RTP_SOURCE_HH
#include "MultiFramedRTPSource.hh"
#endif


#include <vector>

class JpegSegment : public std::vector<unsigned char> {
public:
  JpegSegment();
  int getData(unsigned char*& pp);
  unsigned char* reserveForAccess(int type, int size);
  int initForAdd(int type, int size);
  int copyForAdd(const unsigned char header[4], const unsigned char* p, int size);
  int addData(const unsigned char* p, int size);
  int getType() const;
  int getSize() const;
  enum Status {
    Empty,
    Recalculated,
    Received,
    Backup
  };
  Status getStatus() const { return status_; };
  void setStatus(Status s) { status_ = s; };
  int waiting() const { return waiting_; };
  void frameDone();
  void clean();
private:
  Status status_ = Empty;
  int waiting_ = 0;
};

void ConstructApp0(JpegSegment& segment);
void ConstructDri(JpegSegment& segment, int dri);
void ConstructSof(JpegSegment& segment, int width, int height, int type, int quantCount);
void ConstructSos(JpegSegment& segment);
void ConstructQuantization(JpegSegment& segment0, JpegSegment& segment1, int quality);
void CopyQuantization(JpegSegment& segment0, JpegSegment& segment1, const unsigned char* p);
void ConstructHuffman(JpegSegment& segment0, JpegSegment& segment1, JpegSegment& segment2, JpegSegment& segment3);


struct JpegContext {
public:
  /*
  ready for next frame
  ext
  payload
  */
  bool nextPacketExt(BufferedPacket* packet, unsigned header);
  bool nextPacketFrame(BufferedPacket* packet, unsigned& resultSpecialHeaderSize);
  bool pushHeader(BufferedPacket* packet, unsigned& resultSpecialHeaderSize);
  void frameDone();
  void getResolution(unsigned& fFrameWidth, unsigned& fFrameHeight);
private:
  JpegSegment App0;
  JpegSegment Dri;
  JpegSegment Sof;
  JpegSegment Sos;
  JpegSegment Dht[4];
  JpegSegment Dqt[2];

  struct RTPHeader {
    int width = 0;
    int height = 0;
    int type = 0;
    int quant = 0;
    int dri = 0;
  };
  RTPHeader rtp;
  JpegSegment* unfinished = nullptr;         //!< know segment partially processed
  unsigned char header[4];         //!< segment header intermediate data
  int headerSize = 0;                  //!< segment header intermediate data filled size
  int waitingOtherSegment_ = 0;    //!< segment header parsed, segment is not known, skipping data for specified size
  int passJpegSegments(BufferedPacket* packet, const unsigned char* p, int size);
  int completeJpegHeader(const unsigned char* p, int size);
  int passJpegSegment(const unsigned char* h, const unsigned char* p, int size);
  //bool frameDone_ = false;
  bool headersDone_ = false;
  //bool 
  //bool payloadInExt_ = false;
  bool nextPacketFFF8(BufferedPacket* packet, unsigned header);
  bool nextPacketABAC(BufferedPacket* packet, unsigned header);

  int formHeaders(BufferedPacket* packet, unsigned& resultSpecialHeaderSize, int type, int Q, int width, int height, int dri);
  void headerDone();
};
