﻿#include "Debug.h"

#include <stdio.h>
#include <stdarg.h>
#include <memory>
#include <string>

#include <windows.h>

std::string formatMessage(const char* format, va_list sizeArgs, va_list formatArgs) {
  char sz[1];
  int bufSize = vsnprintf(sz, 1, format, sizeArgs) + 1;
  std::unique_ptr<char[]> formattedString(new char[bufSize]);
  int afterLastCharPos = vsnprintf(formattedString.get(), bufSize, format, formatArgs);
  formattedString[afterLastCharPos] = '\0';
  return std::string(formattedString.get());
}

void dprintf(const char* format, ...) {
  va_list argsSize, argsFormat;
  va_start(argsSize, format);
  va_start(argsFormat, format);
  std::string formatted = formatMessage(format, argsSize, argsFormat);
  va_end(argsSize);
  va_end(argsFormat);

  if (formatted.back() != '\n') {
    formatted += '\n';
  }

  OutputDebugStringA(formatted.c_str());
}
