﻿#include <NetCommon.h>
#include <liveMedia.hh>

#include "Formats.h"
#include "FullConfig.h"

std::string ToMulti(const WCHAR* Name)
{
  size_t size = wcstombs(0, Name, wcslen(Name)) + 1;
  if (!size) return std::string();

  char *char_str = new char[size];
  if (!char_str) return std::string();

  WideCharToMultiByte(CP_ACP, 0, Name, -1, char_str, (int)size, 0, 0);
  char_str[size - 1] = 0; // make sure that string is properly ended

  std::string result = char_str;
  delete [] char_str;
  return result;
}

void LoadIniString(std::string &str, const WCHAR* Default, const WCHAR* File, const WCHAR* Key, const WCHAR* Elem)
{
  WCHAR Buffer[2048];
  GetPrivateProfileStringW(Key,
    Elem,
    Default,
    Buffer,
    2047,
    File);
  str = ToMulti(Buffer);
}

#define LOAD_INI_STRING(Key, Elem, Default) \
  LoadIniString(Key.Elem, Default, fileName, L#Key, L#Elem)

#define LOAD_INI_INTEGER(Key, Elem, Default) \
  Key.Elem = GetPrivateProfileIntW(L#Key, L#Elem, Default, fileName)

#define LOAD_INI_BOOLEAN(Key, Elem, Default) \
  Key.Elem = !!GetPrivateProfileIntW(L#Key, L#Elem, Default, fileName)

#define LOAD_INI_ENUM(Key, Elem, Default, Type) \
  Key.Elem = (Type)GetPrivateProfileIntW(L#Key, L#Elem, Default, fileName)

#define RESTORE_CLRF(var)                \
  while (char *clrf = strstr((char*)TestSequence.var.c_str(), "$$")) \
  {                                      \
    *clrf++ = '\r';                      \
    *clrf = '\n';                        \
  }

void SFullConfig::Load(const WCHAR* fileName)
{
  LOAD_INI_STRING(ControlConnection, Uri, L"rtsp://127.0.0.1");
  LOAD_INI_STRING(ControlConnection, TransportUri, L"");
  if (ControlConnection.TransportUri.empty())
  {
    ControlConnection.TransportUri = ControlConnection.Uri;
  }
  if (ControlConnection.Uri.substr(0, 5) == "https")
  {
    ControlConnection.Uri = "rtsp" + ControlConnection.Uri.substr(5);
  }
  if (ControlConnection.Uri.substr(0, 4) == "http")
  {
    ControlConnection.Uri = "rtsp" + ControlConnection.Uri.substr(4);
  }
  LOAD_INI_STRING(ControlConnection, User, L"");//
  LOAD_INI_STRING(ControlConnection, Password, L"");//
  LOAD_INI_ENUM(ControlConnection, Transport, ELT_UDP, ELiveTransport);
  LOAD_INI_INTEGER(ControlConnection, Port, 0);
  LOAD_INI_INTEGER(ControlConnection, NICIndex, 0);
  LOAD_INI_INTEGER(ControlConnection, Timeout, 60000);
  LOAD_INI_BOOLEAN(ControlConnection, ForceDigest, false);

  LOAD_INI_INTEGER(TestSequence, ObjectId, 0);
  LOAD_INI_INTEGER(TestSequence, SequenceNumber, 0);
  LOAD_INI_INTEGER(TestSequence, Timeout, 60000);
  LOAD_INI_STRING(TestSequence, CustomSetupFields, L"");
  LOAD_INI_STRING(TestSequence, CustomPlayFields, L"");
  LOAD_INI_STRING(TestSequence, CustomPauseFields, L"");
  RESTORE_CLRF(CustomSetupFields);
  RESTORE_CLRF(CustomPlayFields);
  RESTORE_CLRF(CustomPauseFields);
  LOAD_INI_BOOLEAN(TestSequence, UseVideo, true);
  LOAD_INI_BOOLEAN(TestSequence, UseAudio, false);
  LOAD_INI_BOOLEAN(TestSequence, UseMetadata, false);
  LOAD_INI_BOOLEAN(TestSequence, UseBackchannel, false);
  LOAD_INI_BOOLEAN(TestSequence, CheckOptions, false);
  LOAD_INI_BOOLEAN(TestSequence, CheckActualResolution, false);
  LOAD_INI_BOOLEAN(TestSequence, CheckJPEGExtension, false);
  LOAD_INI_BOOLEAN(TestSequence, Base64LineBreaks, false);

  LOAD_INI_STRING(Video, MulticastAddress, L"");
  LOAD_INI_INTEGER(Video, MulticastRtpPort, 0);
  LOAD_INI_INTEGER(Video, MulticastTTL, 0);
  LOAD_INI_STRING(Video, Codec, L"JPEG");
  //Video.Codec = "H265";
  LOAD_INI_INTEGER(Video, Width, 320);
  LOAD_INI_INTEGER(Video, Height, 240);
  LOAD_INI_INTEGER(Video, FPS, 30);

  LOAD_INI_STRING(Audio, MulticastAddress, L"");
  LOAD_INI_INTEGER(Audio, MulticastRtpPort, 0);
  LOAD_INI_INTEGER(Audio, MulticastTTL, 0);
  LOAD_INI_STRING(Audio, Codec, L"PCMU");
  LOAD_INI_INTEGER(Audio, Channels, 1);
  LOAD_INI_INTEGER(Audio, Frequency, 8);
  Audio.Frequency *= 1000;

  LOAD_INI_STRING(Metadata, MulticastAddress, L"");
  LOAD_INI_INTEGER(Metadata, MulticastRtpPort, 0);
  LOAD_INI_INTEGER(Metadata, MulticastTTL, 0);
  LOAD_INI_STRING(Metadata, Codec, L"VND.ONVIF.METADATA");

  LOAD_INI_STRING(Backchannel, MulticastAddress, L"");
  LOAD_INI_STRING(Backchannel, Codec, L"PCMU");
  LOAD_INI_BOOLEAN(Backchannel, UsePostChannel, false);

  Groupsock::NICIndex = ControlConnection.NICIndex;
}
