﻿#pragma once
#ifndef FULL_CONFIG_H
#define FULL_CONFIG_H

#include <string>
#include "rtspwrapper.h"

struct SControlConnection {
  std::string Uri;
  std::string User;
  std::string Password;
  ELiveTransport Transport;
  std::string TransportUri;
  //  std::string TransportKey;
  int Port;
  int NICIndex;
  int Timeout;
  bool ForceDigest;
};

struct SChannelSettings {
  std::string MulticastAddress;
  int MulticastRtpPort;
  int MulticastTTL;
  std::string Codec;
  int Width;
  int Height;
  int FPS;
  int Channels;
  int Frequency;
  bool UsePostChannel;
};

struct STestSequence {
  int ObjectId;
  int SequenceNumber;
  int Timeout;
  std::string CustomSetupFields;
  std::string CustomPlayFields;
  std::string CustomPauseFields;
  bool UseVideo;
  bool UseAudio;
  bool UseMetadata;
  bool UseBackchannel;
  bool CheckOptions;
  bool CheckActualResolution;
  bool CheckJPEGExtension;
  bool Base64LineBreaks;
};

struct SFullConfig {
  SControlConnection ControlConnection;
  STestSequence TestSequence;
  SChannelSettings Video;
  SChannelSettings Audio;
  SChannelSettings Metadata;
  SChannelSettings Backchannel;
  void Load(const WCHAR* FileName);
};

#endif
