﻿///////////////////////////////////////////////////////////////////////////
//!  @author        Alexander Ryltsov
////

#pragma once

#ifndef __PUSHGUIDS_DEFINED
#define __PUSHGUIDS_DEFINED


// {ACD3F473-6F12-4C48-8DB1-5480A8257927}
DEFINE_GUID(CLSID_SourceFilter,
  0xacd3f473, 0x6f12, 0x4c48, 0x8d, 0xb1, 0x54, 0x80, 0xa8, 0x25, 0x79, 0x27);


// {AC189557-F766-4799-B729-7B7448F36E38}
DEFINE_GUID(IID_TestControl,
  0xac189557, 0xf766, 0x4799, 0xb7, 0x29, 0x7b, 0x74, 0x48, 0xf3, 0x6e, 0x38);

// {9C8180F1-5DDA-4683-A164-8504850ABD3D}
DEFINE_GUID(IID_Library,
  0x9c8180f1, 0x5dda, 0x4683, 0xa1, 0x64, 0x85, 0x4, 0x85, 0xa, 0xbd, 0x3d);


DECLARE_INTERFACE_(ITestControl, IUnknown)
{
  STDMETHOD(RunSequence) (int Sequence) = 0;
  STDMETHOD(RunStep) (int Step) = 0;
  STDMETHOD(GetActivity) (int *Activity) = 0;
  STDMETHOD(StopActivity) () = 0;
  STDMETHOD(GetEvents)(LPOLESTR *EventText) = 0;
};


#endif


