﻿#pragma once
#ifndef INTEROP_SYSTEM_H
#define INTEROP_SYSTEM_H
#include <string>

#include "Formats.h"

typedef void(__stdcall * TSharpStepCallback)(int ObjectId, int StepNumber, int Type, const char* Text);

class CCriticalSection {
public:
  CCriticalSection()
  {
    InitializeCriticalSection(&Door);
  };
  ~CCriticalSection()
  {
    DeleteCriticalSection(&Door);
  };
  void Enter()
  {
    EnterCriticalSection(&Door);
  };
  void Leave()
  {
    LeaveCriticalSection(&Door);
  };
private:
  CRITICAL_SECTION Door;
};

class CLocker {
public:
  CLocker(CCriticalSection &Door) : Door(Door)
  {
    Door.Enter();
  };
  ~CLocker()
  {
    Door.Leave();
  };
private:
  CCriticalSection & Door;
};
#endif
