﻿///////////////////////////////////////////////////////////////////////////
//!  @author        Alexander Ryltsov
////

#ifndef LIVE_CAPSULE_H
#define LIVE_CAPSULE_H
#include <deque>
#include <string>

#include "Formats.h"
#include "rtspwrapper.h"
#include "InteropSystem.h"
#include "StepLog.h"
#include "FullConfig.h"

class CFrameQueue {
public:
  CFrameQueue(size_t MaxSize = 20) : MaxSize(MaxSize), PassedCount(0), PlayedCount(0) {};
  virtual ~CFrameQueue() {
    while (Frames.size()) {
      FrameInfo::Release(Frames.front());
      Frames.pop_front();
    }
  }
  void Push(FrameInfo*);
  FrameInfo* Peek();
  FrameInfo* Pop();
  int GetCount();
  int GetPassed() const { return PassedCount; };
  int GetPlayed() const { return PlayedCount; };
private:
  CCriticalSection Door;
  std::deque<FrameInfo*> Frames;
  size_t MaxSize;
  int PassedCount;
  int PlayedCount;
};

class CFramePipe : public CFrameQueue {
public:
  CFramePipe() : Subsession(NULL), Format(NULL), Prefix(NULL) {};
  ~CFramePipe() { delete Subsession; Subsession = nullptr; FrameInfo::Release(Prefix); Prefix = nullptr; };
  IMediaSubsession * Subsession;
  GeneralFormatSupporter* Format;
  FrameInfo * Prefix;
  //std::vector<uint8_t> frameBuffer;
  //long t_sec;
  //long t_usec;
};

class CJPEGExtensionFrames {
public:
  CJPEGExtensionFrames(IMediaSubsession * Subsession, CStepLog& Log) : Log(Log), Subsession(Subsession) {}
  CStepLog& Log;
  IMediaSubsession * Subsession = nullptr;
  int FailedPacketsReceived = 0;
  int PacketsReceived = 0;
};

class CLiveCapsule : CThread {
public:
  CLiveCapsule() : PlayType(0), Terminating(false), Halt(false), InSequence(false), InSleep(false), Sequence(0) { RunThread(); };
  ~CLiveCapsule() { SetTerminating(false); StopThread(); };
  void SetTerminating(bool Halt) { Terminating = true; this->Halt = Halt; Live555Wrapper.Terminate(); };
  void ClearMutators();
  void SetNotificationCallback(TSharpStepCallback StepCallback) { StepLog.SetNotificationCallback(StepCallback); };
  bool Play();
  void Pause();
  void Stop();
  bool RunSequence(int Sequence);
  bool RunStep(int Step);
  bool RunStepSync(int Step);
  ELiveStep GetCurrentStep() const { return Live555Wrapper.GetCurrentStep(); };
  bool IsNeedTeardown() const { return Live555Wrapper.IsNeedTeardown(); };
  bool IsInSequence();

  bool Configure(const WCHAR* FileName);
  bool HasAudio() const;
  bool HasVideo() const;
  bool HasMeta() const;
  bool IsFakeVideo() const;
  RTSPClientState GetState() const;
  bool GetVideoFormat(CMediaType *pmt);
  bool CheckVideoFormat(const CMediaType *pmt) const;
  bool GetAudioFormat(CMediaType *pmt);
  bool CheckAudioFormat(const CMediaType *pmt) const;

  FrameInfo* GetTop(bool Audio);
  int GetCount(bool Audio);
  FrameInfo* GetMeta();
private:
  CFramePipe FramesVideo;
  CFramePipe FramesAudio;
  CFrameQueue FramesMeta;
  CLive555Wrapper Live555Wrapper;
  SFullConfig FullConfig;
  CStepLog StepLog;
  int PlayType;
  bool Terminating;
  bool Halt;
  bool InSequence;
  bool InSleep;
  int Sequence;
  std::string LastResponse;
  void RunSequenceInternal(int Sequence);
  void Thread();
  void InterruptableSleep(int Timeout);

  bool ConfigureWrapper();
  bool GetSpecificErrorDescription(char *Buffer, ELiveStep Step, int &Result);
  static void NotifyFunctionSend(const void* UserData, ELiveStep Step, const char* MessageData);
  static void NotifyFunctionReceive(const void* UserData, ELiveStep Step, const char* MessageData);
  static void NotifyFunctionLog(const void* UserData, ELiveStep Step, const char* MessageData);
  static void VideoDataFunction(
    const void* UserData,
    unsigned char* ReceiveBuffer,
    unsigned FrameSize,
    unsigned NumTruncatedBytes,
    struct timeval PresentationTime,
    unsigned DurationInMicroseconds
  );
  static void AudioDataFunction(
    const void* UserData,
    unsigned char* ReceiveBuffer,
    unsigned FrameSize,
    unsigned NumTruncatedBytes,
    struct timeval PresentationTime,
    unsigned DurationInMicroseconds
  );
  static void MetadataDataFunction(
    const void* UserData,
    unsigned char* ReceiveBuffer,
    unsigned FrameSize,
    unsigned NumTruncatedBytes,
    struct timeval PresentationTime,
    unsigned DurationInMicroseconds
  );

  static void CompleteFunction(const void* UserData, ELiveStep Step, int Result, const char* Body);

  // for general usage
  bool Prepare(unsigned int Timeout);
  bool PrepareRtp();

  bool PlayAsFilter();

  bool FullStop();
  bool PlayAsTestBase(int SleepAfter);
  bool PlayAsTest1TimeWait();
  bool PlayAsTest2FramesWait();
  bool PlayAsTest3TimeWaitRtp();
  bool PlayAsTest4Backchannel();
  bool PlayAsTest5Playback();
  bool PlayAsTest6PlaybackTeardown();
  bool PlayAsTest7TimeWaitAction();
  static const int SequenceCount = 7;

  void ExtractResolutionFromSdp();
  bool CheckResolution();
  bool CheckFrames(bool MakeStep, int Time);
  bool CheckTermination();
  bool CheckOptions(unsigned int Timeout);
};

#endif // LIVE_CAPSULE_H

