﻿#include "StepLog.h"


void CStepLog::RaiseStepCallback(int step, int type, const char* text)
{
  if (StepCallback) {
    StepCallback(ObjectId, step, type, text);
  }
}

int CStepLog::CreateNewStep(const char* Name)
{
  CLocker l(Door);
  LastStep++;
  Log.resize(LastStep + 1);
  int Step = GetCurrentStep();
  Log[Step].Name = Name;
  RaiseStepCallback(Step, ESDT_Begin, Name);
  return Step;
}

void CStepLog::SetRequest(const char* Text, int Step)
{
  if (Step < 0) {
    Step = LastStep;
  }
  CLocker l(Door);
  Step = VerifyStep(Step);
  Log[Step].Request = Text;
  RaiseStepCallback(Step, ESDT_Send, Text);
}

void CStepLog::SetResponse(const char* Text, int Step)
{
  if (Step < 0) {
    Step = LastStep;
  }
  CLocker l(Door);
  Step = VerifyStep(Step);
  Log[Step].Response = Text;
  RaiseStepCallback(Step, ESDT_Receive, Text);
}

void CStepLog::AddLogText(const char* Text, int Step)
{
  if (Step < 0) {
    Step = LastStep;
  }
  CLocker l(Door);
  Step = VerifyStep(Step);
  Log[Step].Log += Text;
  RaiseStepCallback(Step, ESDT_Log, Text);
}

void CStepLog::SetStepResult(int Result, const char* Text, int Step)
{
  if (Step < 0) {
    Step = LastStep;
  }
  CLocker l(Door);
  Step = VerifyStep(Step);
  Log[Step].Result = Result;
  RaiseStepCallback(Step, Result ? ESDT_ResultError : ESDT_ResultOK, Text);
}

void CStepLog::RunCommand(const char* Text)
{
  CLocker l(Door);
  RaiseStepCallback(LastStep, ESDT_Command, Text);
}

int CStepLog::GetCurrentStep()
{
  return LastStep;
  //CLocker l(Door);
  //return Log.size() - 1;
}

int CStepLog::VerifyStep(int Step)
{
  if (Step < 0)
    Step = Log.size() - 1;
  if (Step < 0) {
    Log.resize(1);
    Step = 0;
  }
  if (Step >= (int)Log.size()) {
    Step = Log.size() - 1;
  };
  return Step;
}

