﻿#pragma once
#ifndef STEP_LOG_H
#define STEP_LOG_H

#include "InteropSystem.h"

enum EStepDataType {
  ESDT_Begin,
  ESDT_Send,
  ESDT_Receive,
  ESDT_Log,
  ESDT_ResultOK,
  ESDT_ResultError,
  ESDT_Command
};

struct SStepLogRecord {
  std::string Name;
  std::string Request;
  std::string Response;
  std::string Log;
  int Result;
};

class CStepLog {
public:
  CStepLog() : StepCallback(NULL), LastStep(-1), ObjectId(0) {};
  void SetNotificationCallback(TSharpStepCallback StepCallback) { this->StepCallback = StepCallback; };
  void SetObjectId(int ObjectId) { this->ObjectId = ObjectId; };

  int CreateNewStep(const char* Name);
  void SetRequest(const char* Text, int Step = -1);
  void SetResponse(const char* Text, int Step = -1);
  void AddLogText(const char* Text, int Step = -1);
  void SetStepResult(int Result = 0, const char* Text = "", int Step = -1);
  int GetCurrentStep();
  void RunCommand(const char* Text);
private:
  CCriticalSection Door;
  std::vector<SStepLogRecord> Log;
  int VerifyStep(int Step);
  TSharpStepCallback StepCallback;
  void RaiseStepCallback(int step, int type, const char* text);
  long LastStep;
  int ObjectId;
};

#endif
