﻿#include "StringUtils.h"

std::string stringToLower(const std::string& str)
{
  std::string result(str);
  for (std::string::size_type i = 0; i < result.size(); i++) {
    result[i] = tolower(result[i]);
  }
  return result;
}

bool stringIncludesNoCase(const std::string& str, const std::string& part)
{
  return getSubstringNoCase(str, part) != std::string::npos;
}

bool stringEqualsNoCase(const std::string& str1, const std::string& str2)
{
  return str1.size() == str2.size() &&
    startsWithNoCase(str1, str2);
}

std::string::size_type getSubstringNoCase(const std::string& str, const std::string& substring)
{
  return stringToLower(str).find(stringToLower(substring));
}

bool startsWithNoCase(const std::string& str, const std::string& substring)
{
  return str.size() >= substring.size() &&
    0 == _strnicmp(str.c_str(), substring.c_str(), substring.size());
}
