﻿#include "backchannelwrapper.h"
#include "StringUtils.h"
#include <liveMedia.hh>
#include <string>
#include <iostream>
#include <sstream>
#include <algorithm>
#include <vector>


Boolean BackMediaSubsession::CreateBackSink(std::string const& Codec_, std::string const& Address)
{
  do {
    std::string sdp = fSavedSDPLines;

    std::string Codec = Codec_;
#if 1 // please refer to https://wush.net/trac/onvif-ext/ticket/1764 for details
    if (!stringIncludesNoCase(sdp, Codec) && stringEqualsNoCase(Codec, "MP4A-LATM") && stringIncludesNoCase(sdp, "MPEG4-GENERIC"))
    {
      Codec = "MPEG4-GENERIC";
    }
#endif
    std::istringstream input(sdp);
    std::vector<unsigned char> payloadList;
    std::string mline;
    for (std::string line; std::getline(input, line) && line[0] == 'm'; ) { //parse m attribute
      mline = line;
      //m=<media> <port> <proto> <fmt> ...
      //leave only fmt
      for (int i = 0; i < 3; i++) {
        line = line.substr(line.find(" ") + 1);
      }

      std::cout << line << std::endl;
      std::stringstream s(line);
      int number;
      while(s >> number) {
        payloadList.push_back(number);
      }
    }

    if(stringIncludesNoCase(sdp, Codec)) { //requested codec present in rtpmap
      bool found = false;
      for (auto pf : payloadList) {
        auto pos = std::string::npos;
        if (( pos = getSubstringNoCase(sdp, std::string("a=rtpmap:") + std::to_string(pf) + " " + Codec)) != std::string::npos) {
          fRTPPayloadFormat = pf;
          parseSDPAttribute_rtpmap(sdp.substr(pos).c_str());
          found = true;
          break;
        }
      }
      if(!found) {
        std::string result = "Missed payload format in \"" + mline + "\" for codec " + Codec;
        env().setResultMsg(result.c_str());
        return false;
      }

    } else { //try to guess codec
      if (Codec == "PCMU" && std::find(payloadList.begin(), payloadList.end(), 0) != payloadList.end()) {
        fRTPPayloadFormat = 0;
        fNumChannels = 1;
        fRTPTimestampFrequency = 8000;
      } else {
        std::string result = "Missed a=rtpmap attribute for " + Codec + " or codec not listed in palyoad formats";
        env().setResultMsg(result.c_str());
        return false;
      }
    }

    if (Codec == "PCMU") {
      if (!CreateBackSink711(Address))
        break;
    }
    if (Codec == "G726") {
      if (!CreateBackSink726(Address))
        break;
    }
    if (stringEqualsNoCase(Codec, "MPEG4-GENERIC") ||
        stringEqualsNoCase(Codec, "MP4A-LATM")
      ) {
      auto extensionDotPos = Address.rfind(".");
      if (extensionDotPos == std::string::npos) {
        extensionDotPos = Address.length();
      }
      if (!CreateBackSinkAAC(std::string(Address).insert(extensionDotPos, "_" + std::to_string(rtpTimestampFrequency()) + "_" + std::to_string(numChannels()))))
        break;
    }

    if (sink != NULL && fRTCPSocket != NULL) {
      // If bandwidth is specified, use it and add 5% for RTCP overhead.
      // Otherwise make a guess at 500 kbps.
      unsigned totSessionBandwidth
        = fBandwidth ? fBandwidth + fBandwidth / 20 : 500;
      fRTCPInstance = RTCPInstance::createNew(env(), fRTCPSocket,
        totSessionBandwidth,
        (unsigned char const*)
        fParent.CNAME(),
        NULL /* we're a client */,
        fRTPSource);
      if (fRTCPInstance == NULL) {
        env().setResultMsg("Failed to create RTCP instance");
        break;
      }
    }
    return True;
  } while (0);

  return False; // an error occurred
}

Boolean BackMediaSubsession::CreateBackSink711(std::string const& Address)
{
  WAVAudioFileSource* wavSource = WAVAudioFileSource::createNew(fParent.envir(), Address.c_str());
  if (!wavSource) {
    return False;
  }
  fReadSource = wavSource;

  sink = SimpleRTPSink::createNew(fParent.envir(), fRTPSocket,
    fRTPPayloadFormat, 8000,
    "audio", "PCMU", 1);
  if (!sink) {
    Medium::close(wavSource);
    return False;
  }
  return True;
}

Boolean BackMediaSubsession::CreateBackSink726(std::string const& Address)
{
  WAVAudioFileSource* wavSource = WAVAudioFileSource::createNew(fParent.envir(), Address.c_str());

  if (!wavSource) {
    return False;
  }

  fReadSource = wavSource;

  sink = SimpleRTPSink::createNew(fParent.envir(), fRTPSocket,
    fRTPPayloadFormat, 8000,
    "audio", "G726-16", 1);
  return True;
}

Boolean BackMediaSubsession::CreateBackSinkAAC(std::string const& Address)
{
    ADTSAudioFileSource* adtsSource = ADTSAudioFileSource::createNew(fParent.envir(), Address.c_str());

    if (!adtsSource) {
      return False;
    }

    fReadSource = adtsSource;

    sink = MPEG4GenericRTPSink::createNew(fParent.envir(), fRTPSocket,
      fRTPPayloadFormat,
      adtsSource->samplingFrequency(),
      "audio", "aac-hbr", adtsSource->configStr(),
      adtsSource->numChannels());
    return True;
}
