﻿#include "playbacksupport.h"
#include "LiveCapsule.h"

void PlaybackFrameLog::RtpExtHdrCallback(uint16_t profile, uint16_t seq, uint16_t len, uint8_t* pHdrData, void* pPriv)
{
  if (pPriv && profile == 0xABAC)
  {
    ((PlaybackFrameLog*)pPriv)->RtpExtHdrCallback1(profile, seq, len, pHdrData);
  }
}

void PlaybackFrameLog::RtpExtHdrCallback1(uint16_t profile, uint16_t seq, uint16_t len, uint8_t* pHdrData)
{
  RtpReplayExtension packet;

  // Packet receiving time
  packet.creationTime = GetTickCount();

  // NTP time
  packet.dateTime = ntohl(*((uint32_t*)pHdrData)) - 2208988800UL;
  pHdrData += 4;
  packet.secFrac = ntohl(*((uint32_t*)pHdrData));
  pHdrData += 4;

  packet.bitC = (*pHdrData >> 7) & 1;
  packet.bitE = (*pHdrData >> 6) & 1;
  packet.bitD = (*pHdrData >> 5) & 1;
  packet.CSeq = *(++pHdrData);

  packet.seq = htons(seq);
  pHdrData += 1;
  packet.validLength = *pHdrData & 1;
  packet.startsFrame = (*pHdrData >> 1) & 1;
  packet.endsFrame = (*pHdrData >> 2) & 1;
  packet.type = (*pHdrData >> 5) & 1;
  pHdrData += 2;
  // RTP time
  packet.timestamp = *((uint32_t*)pHdrData);
  pHdrData += 4;
  packet.payload = *((uint8_t*)pHdrData + 0);
  packet.type = *((uint8_t*)pHdrData + 1);

  Frames.push_back(packet);
  char Buffer[256];
  packet.ToString(Buffer);
  Log.AddLogText(Buffer);
}

void RtpReplayExtension::ToString(char* Buffer, bool canSkip)
{
  sprintf(Buffer, "%u:%u.%u.%u.%u.%u.%u.%u.%u.%u.%u.%u.%u.%llu.%u",
    payload, dateTime, secFrac, bitC, bitE, bitD, CSeq, seq, canSkip ? 1 : 0,
    startsFrame, endsFrame, validLength, timestamp, creationTime, type);
}


bool PlaybackFrameLog::GetText(char* Buffer, int Record)
{
  if (!Buffer) {
    return false;
  }
  if ((Record < 0) || Record >= (int)Frames.size()) {
    Buffer[0] = 0;
    return false;
  };
  Frames[Record].ToString(Buffer);
  return true;
}
