﻿#pragma once

#include <vector>

struct RtpReplayExtension
{
  uint64_t creationTime;
  uint32_t dateTime;
  uint32_t secFrac;
  uint8_t bitC;
  uint8_t bitE;
  uint8_t bitD;
  uint8_t CSeq;
  uint16_t seq;
  uint8_t startsFrame;
  uint8_t endsFrame;
  uint8_t validLength;
  uint32_t timestamp;
  uint8_t payload;
  uint8_t type;

  void ToString(char* Buffer, bool canSkip = true);
};

class CStepLog;

class PlaybackFrameLog {
  std::vector<RtpReplayExtension> Frames;
  CStepLog& Log;
public:
  PlaybackFrameLog(CStepLog& Log) : Log(Log) {};
  static void RtpExtHdrCallback(uint16_t profile, uint16_t seq, uint16_t len, uint8_t* pHdrData, void* pPriv);
  int GetRecords() const { return Frames.size(); };
  bool GetText(char* Buffer, int Record);
private:
  void RtpExtHdrCallback1(uint16_t profile, uint16_t seq, uint16_t len, uint8_t* pHdrData);
};
